/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Response;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.factory.ParserFactory;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FormatterUtil.class);

    public static MessageParser.EntityLink getEntityLinkForFieldName(String fieldName, Thread thread) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(thread.getAbout());
        String entityType = thread.getEntityType();
        String entityFQN = entityLink.getEntityFQN();
        String arrayFieldName = null;
        String arrayFieldValue = null;
        if (fieldName.contains(".")) {
            String[] fieldNameParts = FullyQualifiedName.split(fieldName);
            fieldName = fieldNameParts[0];
            if (fieldNameParts.length == 3) {
                arrayFieldName = fieldNameParts[1];
                arrayFieldValue = fieldNameParts[2];
            } else if (fieldNameParts.length == 2) {
                arrayFieldName = fieldNameParts[0].equals("extension") ? fieldNameParts[0] : fieldNameParts[1];
            }
        }
        return new MessageParser.EntityLink(entityType, entityFQN, fieldName, arrayFieldName, arrayFieldValue);
    }

    public static Set<String> getUpdatedField(ChangeEvent event) {
        HashSet<String> fields = new HashSet<String>();
        ChangeDescription description = event.getChangeDescription();
        if (description != null) {
            ArrayList fieldChanges = new ArrayList();
            fieldChanges.addAll(description.getFieldsAdded());
            fieldChanges.addAll(description.getFieldsUpdated());
            fieldChanges.addAll(description.getFieldsDeleted());
            fieldChanges.forEach(field -> {
                String fieldName = field.getName();
                if (fieldName.contains(".")) {
                    String[] tokens = fieldName.split("\\.");
                    if (tokens[0].equals("extension")) {
                        fields.add("extension");
                    } else {
                        fields.add(tokens[tokens.length - 1]);
                    }
                } else {
                    fields.add(fieldName);
                }
            });
        }
        return fields;
    }

    public static String transformMessage(MessageDecorator<?> messageFormatter, Thread thread, FieldChange fieldChange, CHANGE_TYPE changeType) {
        MessageParser.EntityLink link = FormatterUtil.getEntityLinkForFieldName(fieldChange.getName(), thread);
        String arrayFieldValue = link.getArrayFieldValue();
        String updateField = DefaultFieldFormatter.getFieldNameChange(fieldChange.getName(), thread);
        DefaultFieldFormatter fieldSpecificFormatter = CommonUtil.nullOrEmpty((String)arrayFieldValue) ? ParserFactory.getFieldParserObject(messageFormatter, thread, fieldChange, updateField) : ParserFactory.getFieldParserObject(messageFormatter, thread, fieldChange, arrayFieldValue);
        return fieldSpecificFormatter.getFormattedMessage(changeType);
    }

    public static List<Thread> getFormattedMessages(MessageDecorator<?> messageFormatter, Thread thread, ChangeDescription changeDescription) {
        List fieldsUpdated = changeDescription.getFieldsUpdated();
        List<Thread> messages = FormatterUtil.getFormattedMessagesForAllFieldChange(messageFormatter, thread, fieldsUpdated, CHANGE_TYPE.UPDATE);
        List<FieldChange> fieldsAdded = changeDescription.getFieldsAdded();
        List fieldsDeleted = changeDescription.getFieldsDeleted();
        if (fieldsAdded.isEmpty() || fieldsDeleted.isEmpty()) {
            if (!fieldsAdded.isEmpty()) {
                messages.addAll(FormatterUtil.getFormattedMessagesForAllFieldChange(messageFormatter, thread, fieldsAdded, CHANGE_TYPE.ADD));
            } else if (!fieldsDeleted.isEmpty()) {
                messages.addAll(FormatterUtil.getFormattedMessagesForAllFieldChange(messageFormatter, thread, fieldsDeleted, CHANGE_TYPE.DELETE));
            }
            return messages;
        }
        for (FieldChange field : fieldsDeleted) {
            Optional<FieldChange> addedField = fieldsAdded.stream().filter(f -> f.getName().equals(field.getName())).findAny();
            if (addedField.isPresent()) {
                String fieldName = field.getName();
                MessageParser.EntityLink link = FormatterUtil.getEntityLinkForFieldName(fieldName, thread);
                Thread tempThread = JsonUtils.deepCopy(thread, Thread.class);
                String message = ParserFactory.getEntityParser(link.getEntityType()).format(messageFormatter, tempThread, new FieldChange().withName(fieldName).withOldValue(field.getOldValue()).withNewValue(addedField.get().getNewValue()), CHANGE_TYPE.UPDATE);
                tempThread.withMessage(message);
                messages.add(tempThread);
                fieldsAdded = fieldsAdded.stream().filter(f -> !f.equals(addedField.get())).toList();
                continue;
            }
            messages.addAll(FormatterUtil.getFormattedMessagesForAllFieldChange(messageFormatter, thread, Collections.singletonList(field), CHANGE_TYPE.DELETE));
        }
        if (!fieldsAdded.isEmpty()) {
            messages.addAll(FormatterUtil.getFormattedMessagesForAllFieldChange(messageFormatter, thread, fieldsAdded, CHANGE_TYPE.ADD));
        }
        return messages;
    }

    public static List<Thread> getFormattedMessagesForAllFieldChange(MessageDecorator<?> messageFormatter, Thread thread, List<FieldChange> fields, CHANGE_TYPE changeType) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (FieldChange field : fields) {
            Thread tempEntity = JsonUtils.deepCopy(thread, Thread.class).withId(UUID.randomUUID());
            String message = ParserFactory.getEntityParser(thread.getEntityType()).format(messageFormatter, tempEntity, field, changeType);
            tempEntity.withMessage(message);
            threads.add(tempEntity);
        }
        return threads;
    }

    public static Optional<ChangeEvent> getChangeEventFromResponseContext(ContainerResponseContext responseContext, String updateBy) {
        Optional<EventType> eventType = FormatterUtil.getEventTypeFromResponse(responseContext);
        if (eventType.isEmpty() || !responseContext.hasEntity()) {
            return Optional.empty();
        }
        return Optional.ofNullable(FormatterUtil.extractChangeEvent(responseContext, updateBy, eventType.get()));
    }

    private static ChangeEvent extractChangeEvent(ContainerResponseContext responseContext, String updateBy, EventType eventType) {
        Object object = responseContext.getEntity();
        if (object instanceof ChangeEvent) {
            ChangeEvent fieldChangedChangeEvent = (ChangeEvent)object;
            return fieldChangedChangeEvent;
        }
        object = responseContext.getEntity();
        if (object instanceof EntityInterface) {
            EntityInterface entityInterface = (EntityInterface)object;
            return FormatterUtil.createChangeEventForEntity(updateBy, eventType, entityInterface);
        }
        object = responseContext.getEntity();
        if (object instanceof Thread) {
            Thread thread = (Thread)object;
            return FormatterUtil.createChangeEventForThread(updateBy, eventType, thread);
        }
        LOG.debug("Unknown event type in Change Event :  {}", (Object)eventType.value());
        return null;
    }

    private static ChangeEvent createChangeEventForEntity(String updateBy, EventType eventType, EntityInterface entityInterface) {
        return FormatterUtil.getChangeEvent(updateBy, eventType, entityInterface.getEntityReference().getType(), entityInterface).withPreviousVersion(entityInterface.getChangeDescription() != null ? entityInterface.getChangeDescription().getPreviousVersion() : entityInterface.getVersion()).withEntity((Object)entityInterface).withEntityFullyQualifiedName(entityInterface.getEntityReference().getFullyQualifiedName());
    }

    private static ChangeEvent createChangeEventForThread(String updateBy, EventType eventType, Thread threadEntity) {
        return FormatterUtil.getChangeEventForThread(updateBy, eventType, "THREAD", threadEntity).withEntity((Object)threadEntity);
    }

    private static Optional<EventType> getEventTypeFromResponse(ContainerResponseContext responseContext) {
        String changeType = responseContext.getHeaderString("X-OpenMetadata-Change");
        if (changeType != null) {
            return Optional.of(EventType.fromValue((String)changeType));
        }
        if (responseContext.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return Optional.of(EventType.ENTITY_CREATED);
        }
        return Optional.empty();
    }

    private static ChangeEvent getChangeEvent(String updateBy, EventType eventType, String entityType, EntityInterface entityInterface) {
        return new ChangeEvent().withId(UUID.randomUUID()).withEventType(eventType).withEntityId(entityInterface.getId()).withEntityType(entityType).withUserName(updateBy).withTimestamp(entityInterface.getUpdatedAt()).withChangeDescription(entityInterface.getChangeDescription()).withCurrentVersion(entityInterface.getVersion());
    }

    private static ChangeEvent getChangeEventForThread(String updateBy, EventType eventType, String entityType, Thread thread) {
        return new ChangeEvent().withId(UUID.randomUUID()).withEventType(eventType).withEntityId(thread.getId()).withEntityType(entityType).withUserName(updateBy).withTimestamp(thread.getUpdatedAt());
    }

    public static enum CHANGE_TYPE {
        ADD,
        UPDATE,
        DELETE;

    }
}

