/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.entity;

import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.dataInsight.type.KpiResult;
import org.openmetadata.schema.dataInsight.type.KpiTarget;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.entity.EntityFormatter;
import org.openmetadata.service.formatter.util.FormatterUtil;

public class KpiFormatter
implements EntityFormatter {
    private static final String KPI_RESULT_FIELD = "kpiResult";

    @Override
    public String format(MessageDecorator<?> messageFormatter, Thread thread, FieldChange fieldChange, FormatterUtil.CHANGE_TYPE changeType) {
        if (KPI_RESULT_FIELD.equals(fieldChange.getName())) {
            return this.transformKpiResult(messageFormatter, thread, fieldChange);
        }
        return FormatterUtil.transformMessage(messageFormatter, thread, fieldChange, changeType);
    }

    private String transformKpiResult(MessageDecorator<?> messageFormatter, Thread thread, FieldChange fieldChange) {
        EntityInterface entity = (EntityInterface)Entity.getEntity(thread.getEntityType(), thread.getEntityId(), "id", Include.ALL);
        String kpiName = entity.getName();
        KpiResult result = (KpiResult)fieldChange.getNewValue();
        if (result != null) {
            String format = String.format("Added Results for %s. Target Name : %s , Current Value: %s, Target Met: %s", messageFormatter.getBold(), messageFormatter.getBold(), messageFormatter.getBold(), messageFormatter.getBold());
            KpiTarget target = (KpiTarget)result.getTargetResult().get(0);
            return String.format(format, kpiName, target.getName(), target.getValue(), target.getTargetMet());
        }
        String format = String.format("KpiResult %s is updated.", messageFormatter.getBold());
        return String.format(format, kpiName);
    }
}

