/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.vdldoc;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.omnifaces.vdldoc.ImpliedAttribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompositeComponentHandler
extends DefaultHandler {
    private static final String ATTRIBUTE = "attribute";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_TYPE = "component-type";
    private static final String COMPOSITE_NAMESPACE_SUN = "http://java.sun.com/jsf/composite";
    private static final String COMPOSITE_NAMESPACE_JCP = "http://xmlns.jcp.org/jsf/composite";
    private static final Set<String> COMPOSITE_NAMESPACES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http://java.sun.com/jsf/composite", "http://xmlns.jcp.org/jsf/composite")));
    private static final String DEPRECATED = "deprecated";
    private static final String DEPRECATION = "deprecation";
    private static final String DESCRIPTION = "description";
    private static final String DISPLAY_NAME = "displayName";
    private static final String EDITABLE_VALUE_HOLDER = "editableValueHolder";
    private static final String EXAMPLE_URL = "example-url";
    private static final String EXTENSION = "extension";
    private static final String FACELET_COMPOSITE_COMPONENT = "Facelet Composite Component";
    private static final String INTERFACE = "interface";
    private static final String NAME = "name";
    private static final String REQUIRED = "required";
    private static final String SHORT_DESCRIPTION = "shortDescription";
    private static final String SINCE = "since";
    private static final String TAG = "tag";
    private static final String TAG_EXTENSION = "tag-extension";
    private static final String TAG_NAME = "tag-name";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String VALUE_HOLDER = "valueHolder";
    private static final String VDLDOC_NAMESPACE = "http://vdldoc.omnifaces.org";
    private String componentName;
    private Document document;
    private String namespaceURI;
    private boolean valueGiven;
    private boolean valueHolder;
    private Node tagNode;
    private Node taglibNode;
    private Node tagExtensionNode;
    private HashMap<String, ImpliedAttribute> attributeMap;

    public CompositeComponentHandler(String componentName, Document document, String namespaceURI, Node taglibNode, HashMap<String, ImpliedAttribute> properties) {
        this.componentName = componentName;
        this.document = document;
        this.namespaceURI = namespaceURI;
        this.taglibNode = taglibNode;
        this.attributeMap = properties;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri != null && localName != null) {
            if (COMPOSITE_NAMESPACES.contains(uri) && localName.equals(INTERFACE)) {
                if (this.valueHolder) {
                    if (this.valueGiven) {
                        System.out.println("INFO: valueHolder = " + this.valueHolder + ", but valueGiven = " + this.valueGiven + ". Since the xhtml declares a value attribute, we are not adding the implied value attribute for this composite component to the Vdldoc.");
                    } else {
                        this.addImpliedAttribute(this.tagNode, VALUE, VALUE, "The current value of this component.", "false", "java.lang.Object");
                    }
                }
                this.tagNode = null;
            } else if (COMPOSITE_NAMESPACES.contains(uri) && localName.equals(EXTENSION)) {
                this.tagExtensionNode = null;
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void startElement(String uri, String localName, String elementName, Attributes attributes) throws SAXException {
        if (uri != null && localName != null) {
            if (COMPOSITE_NAMESPACES.contains(uri) && localName.equals(INTERFACE)) {
                this.valueGiven = false;
                Element tagElement = this.document.createElementNS(this.namespaceURI, TAG);
                this.tagNode = this.taglibNode.appendChild(tagElement);
                String shortDescription = attributes.getValue(SHORT_DESCRIPTION);
                if (shortDescription != null) {
                    Element shortDescriptionElement = this.document.createElementNS(this.namespaceURI, DESCRIPTION);
                    shortDescriptionElement.setTextContent(shortDescription);
                    this.tagNode.appendChild(shortDescriptionElement);
                }
                Element tagNameElement = this.document.createElementNS(this.namespaceURI, TAG_NAME);
                tagNameElement.setTextContent(this.componentName);
                this.tagNode.appendChild(tagNameElement);
                Element componentElement = this.document.createElementNS(this.namespaceURI, COMPONENT);
                Element componentTypeElement = this.document.createElementNS(this.namespaceURI, COMPONENT_TYPE);
                componentTypeElement.setTextContent(FACELET_COMPOSITE_COMPONENT);
                componentElement.appendChild(componentTypeElement);
                this.tagNode.appendChild(componentElement);
                for (Map.Entry<String, ImpliedAttribute> entry : this.attributeMap.entrySet()) {
                    String name = entry.getKey();
                    ImpliedAttribute attribute = entry.getValue();
                    this.addImpliedAttribute(this.tagNode, name, attribute.getDisplayName(), attribute.getDescription(), attribute.getRequired(), attribute.getType());
                }
            } else if (COMPOSITE_NAMESPACES.contains(uri) && localName.equals(ATTRIBUTE)) {
                if (this.tagNode != null) {
                    String required;
                    String displayName;
                    Node attributeNode = this.tagNode.appendChild(this.document.createElementNS(this.namespaceURI, ATTRIBUTE));
                    String description = attributes.getValue(SHORT_DESCRIPTION);
                    if (description != null) {
                        Element descriptionElement = this.document.createElementNS(this.namespaceURI, DESCRIPTION);
                        descriptionElement.setTextContent(description);
                        attributeNode.appendChild(descriptionElement);
                    }
                    if ((displayName = attributes.getValue(DISPLAY_NAME)) != null) {
                        Element displayNameElement = this.document.createElementNS(this.namespaceURI, DISPLAY_NAME);
                        displayNameElement.setTextContent(displayName);
                        attributeNode.appendChild(displayNameElement);
                    }
                    Element nameElement = this.document.createElementNS(this.namespaceURI, NAME);
                    String name = attributes.getValue(NAME);
                    nameElement.setTextContent(name);
                    attributeNode.appendChild(nameElement);
                    if (VALUE.equals(name)) {
                        this.valueGiven = true;
                    }
                    if ((required = attributes.getValue(REQUIRED)) == null) {
                        required = Boolean.FALSE.toString();
                    }
                    Element requiredElement = this.document.createElementNS(this.namespaceURI, REQUIRED);
                    requiredElement.setTextContent(required);
                    attributeNode.appendChild(requiredElement);
                    String type = attributes.getValue(TYPE);
                    if (type == null) {
                        type = String.class.getName();
                    }
                    Element typeElement = this.document.createElementNS(this.namespaceURI, TYPE);
                    typeElement.setTextContent(type);
                    attributeNode.appendChild(typeElement);
                }
            } else if (COMPOSITE_NAMESPACES.contains(uri) && localName.equals(EXTENSION)) {
                if (this.tagNode != null) {
                    this.tagExtensionNode = this.tagNode.appendChild(this.document.createElementNS(this.namespaceURI, TAG_EXTENSION));
                }
            } else if (uri.equals(VDLDOC_NAMESPACE) && localName.equals(SINCE)) {
                String since;
                if (this.tagExtensionNode != null && (since = attributes.getValue(VALUE)) != null) {
                    Element sinceElement = this.document.createElementNS(VDLDOC_NAMESPACE, SINCE);
                    sinceElement.setTextContent(since);
                    this.tagExtensionNode.appendChild(sinceElement);
                }
            } else if (uri.equals(VDLDOC_NAMESPACE) && localName.equals(EXAMPLE_URL)) {
                String exampleURL;
                if (this.tagExtensionNode != null && (exampleURL = attributes.getValue(VALUE)) != null) {
                    Element exampleURLElement = this.document.createElementNS(VDLDOC_NAMESPACE, EXAMPLE_URL);
                    exampleURLElement.setTextContent(exampleURL);
                    this.tagExtensionNode.appendChild(exampleURLElement);
                }
            } else if (uri.equals(VDLDOC_NAMESPACE) && localName.equals(DEPRECATED)) {
                if (this.tagExtensionNode != null) {
                    Element deprecatedElement = this.document.createElementNS(VDLDOC_NAMESPACE, DEPRECATED);
                    String deprecatedShortDescription = attributes.getValue(SHORT_DESCRIPTION);
                    String deprecatedValue = attributes.getValue(VALUE);
                    if (deprecatedShortDescription != null) {
                        deprecatedElement.setTextContent(deprecatedShortDescription);
                    } else if (deprecatedValue != null) {
                        deprecatedElement.setTextContent(deprecatedValue);
                    }
                    this.tagExtensionNode.appendChild(deprecatedElement);
                }
            } else if (COMPOSITE_NAMESPACES.contains(uri) && localName.equals(VALUE_HOLDER)) {
                if (this.tagNode != null) {
                    this.valueHolder = true;
                }
            } else if (COMPOSITE_NAMESPACES.contains(uri) && localName.equals(EDITABLE_VALUE_HOLDER) && this.tagNode != null) {
                this.valueHolder = true;
            }
        }
    }

    public void addImpliedAttribute(Node node, String name, String displayName, String description, String required, String type) {
        Node attributeNode = node.appendChild(this.document.createElementNS(this.namespaceURI, ATTRIBUTE));
        Element nameElement = this.document.createElementNS(this.namespaceURI, NAME);
        nameElement.setTextContent(name);
        attributeNode.appendChild(nameElement);
        Element displayNameElement = this.document.createElementNS(this.namespaceURI, DISPLAY_NAME);
        displayNameElement.setTextContent(displayName);
        attributeNode.appendChild(displayNameElement);
        Element descriptionElement = this.document.createElementNS(this.namespaceURI, DESCRIPTION);
        descriptionElement.setTextContent(description);
        attributeNode.appendChild(descriptionElement);
        Element requiredElement = this.document.createElementNS(this.namespaceURI, REQUIRED);
        requiredElement.setTextContent(required);
        attributeNode.appendChild(requiredElement);
        Element typeElement = this.document.createElementNS(this.namespaceURI, TYPE);
        typeElement.setTextContent(type);
        attributeNode.appendChild(typeElement);
    }
}

