/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.vdldoc;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.omnifaces.vdldoc.VdldocGenerator;

public class Main {
    private static final String USAGE = " ------------------------------------------------------------------------------\n                         VDL Documentation Generator                           \n Usage:                                                                        \n                vdldoc [options] taglib1 [taglib2 [taglib3 ...]]               \n                                                                               \n options:                                                                      \n   -help                  Displays this help message.                          \n   -d <directory>         Destination directory for output files.              \n                          This defaults to new dir called 'vdldoc'.            \n   -windowtitle <text>    Browser window title. This defaults to               \n                          VDL Documentation Generator - Generated Documentation\n   -doctitle <html-code>  Documentation title for the VDL index page.          \n                          This defaults to the same as window title.           \n   -facesconfig <path>    Path to the faces-config.xml file.                   \n   -attr <path>           Path to properties file containing descriptions for  \n                          implied attributes of composite components, such as  \n                          'id', 'rendered', etc.                               \n   -q                     Quiet Mode, i.e. disable logging.                    \n                                                                               \n taglib1 [taglib2 [taglib3 ...]]: Space separated paths to .taglib.xml files.  \n                                                                               \n     NOTE: if an argument or file path contains by itself spaces, quote it.    \n ------------------------------------------------------------------------------\n";

    public static void main(String[] args) {
        VdldocGenerator generator = new VdldocGenerator();
        Iterator<String> iter = Arrays.asList(args).iterator();
        boolean atLeastOneTaglib = false;
        try {
            while (iter.hasNext()) {
                String arg = iter.next();
                if (arg.equals("-help")) {
                    Main.showUsage(null);
                    continue;
                }
                if (arg.equals("-d")) {
                    generator.setOutputDirectory(new File(iter.next()));
                    continue;
                }
                if (arg.equals("-windowtitle")) {
                    generator.setWindowTitle(iter.next());
                    continue;
                }
                if (arg.equals("-doctitle")) {
                    generator.setDocTitle(iter.next());
                    continue;
                }
                if (arg.equals("-facesconfig")) {
                    generator.setFacesConfig(new File(iter.next()));
                    continue;
                }
                if (arg.equals("-attr")) {
                    generator.setAttributes(new File(iter.next()));
                    continue;
                }
                if (arg.equals("-q")) {
                    generator.setQuiet(true);
                    continue;
                }
                generator.addTaglib(new File(arg));
                atLeastOneTaglib = true;
            }
            if (!atLeastOneTaglib) {
                Main.showUsage("Please specify at least one .taglib.xml file.");
            }
        }
        catch (NoSuchElementException e) {
            Main.showUsage("Invalid Syntax.");
        }
        try {
            generator.generate();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void showUsage(String error) {
        if (error != null) {
            System.err.println("\nERROR: " + error + " See below for the usage.\n");
        }
        System.out.println(USAGE);
        System.exit(error != null ? 1 : 0);
    }
}

