/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.vdldoc;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.omnifaces.vdldoc.CompositeComponentHandler;
import org.omnifaces.vdldoc.ImpliedAttribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VdldocGenerator {
    private static final String RESOURCE_PATH = "/org/omnifaces/vdldoc/resources";
    private static final String DEFAULT_WINDOW_TITLE = "VDL Documentation Generator - Generated Documentation";
    private static final String DEFAULT_DOC_TITLE = "VDL Documentation Generator - Generated Documentation";
    private static final String NS_JAVAEE = "http://java.sun.com/xml/ns/javaee";
    private static final boolean DEBUG_INPUT_DOCUMENT = false;
    private static final String ERROR_INVALID_TAGLIB = "%s is not a .taglib.xml file.";
    private static final String ERROR_INVALID_FACES_CONFIG = "%s is not a faces-config.xml file.";
    private static final String ERROR_INVALID_ATTRIBUTES_FILE = "%s is not a valid attributes file.";
    private static final String ERROR_JAVAEE_MISSING = "%s does not have xmlns=\"http://java.sun.com/xml/ns/javaee\"";
    private static final String ERROR_TAGLIB_MISSING = "%s does not have <facelet-taglib> as root.";
    private static final String ERROR_INVALID_COMPOSITELIB = "%s can not have more than one <composite-library-name>.";
    private static final String WARNING_NO_TAGS = "WARNING: %s does not have any <tag>s or <function>s. Skipping!";
    private static final String WARNING_ID_MISSING = "WARNING: %s does not have <facelet-taglib id> attribute. Defaulting to base filename '%s'... ";
    private static final String WARNING_UNSUPPORTED_ATTRIBUTE = "WARNING: '%s' is not a supported composite attribute. Skipping!";
    private static final String WARNING_INVALID_ATTRIBUTE = "WARNING: '%s' is not in format 'name.attribute=value'. Skipping!";
    private static final String ERROR_DUPLICATE_ID = "Two tag libraries exist with the same <facelet-taglib id> attribute '%s'. This is not supported.";
    private Set<File> taglibs = new LinkedHashSet<File>();
    private File facesConfig;
    private File outputDirectory = new File("vdldoc");
    private String windowTitle = "VDL Documentation Generator - Generated Documentation";
    private String docTitle = "VDL Documentation Generator - Generated Documentation";
    private File attributesFile;
    private boolean quiet;
    private Document summaryDocument;
    private HashMap<String, ImpliedAttribute> compositeAttributeMap;

    public void addTaglib(File taglib) {
        if (!(taglib.exists() && taglib.isFile() && taglib.getName().toLowerCase().endsWith(".taglib.xml"))) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_TAGLIB, taglib.getAbsolutePath()));
        }
        this.taglibs.add(taglib);
    }

    public void setFacesConfig(File facesConfig) {
        if (!(facesConfig.exists() && facesConfig.isFile() && facesConfig.getName().equals("faces-config.xml"))) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_FACES_CONFIG, facesConfig.getAbsolutePath()));
        }
        this.facesConfig = facesConfig;
    }

    public void setAttributes(File attributesFile) {
        if (!attributesFile.exists() || !attributesFile.isFile()) {
            throw new IllegalArgumentException(ERROR_INVALID_ATTRIBUTES_FILE);
        }
        this.attributesFile = attributesFile;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public void setDocTitle(String docTitle) {
        this.docTitle = docTitle;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void generate() throws IllegalArgumentException {
        try {
            this.loadCompositeAttributeMap();
            this.createSummaryDoc();
            this.copyStaticFiles();
            this.generateOverview();
            this.generateTaglibDetail();
            this.println("VDL documentation generation is finished!");
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCompositeAttributeMap() throws IOException {
        this.compositeAttributeMap = new HashMap();
        Properties properties = new Properties();
        if (this.attributesFile == null) {
            properties.load(VdldocGenerator.getResourceAsStream("cc-attributes.properties"));
        } else {
            this.print(String.format("Parsing %s file... ", this.attributesFile.getName()));
            FileInputStream input = new FileInputStream(this.attributesFile);
            try {
                properties.load(input);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.parseCompositeAttributeMap(properties, this.attributesFile != null);
    }

    private void parseCompositeAttributeMap(Properties properties, boolean log) {
        boolean warned = false;
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            String name = "";
            String attributeName = "";
            String[] tokens = key.split("\\.");
            if (tokens.length == 2) {
                name = tokens[0];
                attributeName = tokens[1];
                ImpliedAttribute attribute = this.compositeAttributeMap.get(name);
                if (attribute == null) {
                    attribute = new ImpliedAttribute();
                    attribute.setDisplayName(name);
                    attribute.setDescription(name);
                    attribute.setRequired("false");
                    attribute.setType("java.lang.String");
                }
                if ("displayName".equals(attributeName)) {
                    attribute.setDisplayName(value);
                } else if ("description".equals(attributeName)) {
                    attribute.setDescription(value);
                } else if ("required".equals(attributeName)) {
                    attribute.setRequired(value);
                } else if ("type".equals(attributeName)) {
                    attribute.setType(value);
                } else if (log) {
                    warned = true;
                    this.println("");
                    this.print(String.format(WARNING_UNSUPPORTED_ATTRIBUTE, key));
                }
                this.compositeAttributeMap.put(name, attribute);
                continue;
            }
            if (!log) continue;
            warned = true;
            this.println("");
            this.print(String.format(WARNING_INVALID_ATTRIBUTE, key));
        }
        if (log) {
            this.println(warned ? "" : "OK!");
        }
    }

    private void createSummaryDoc() throws IOException, SAXException, ParserConfigurationException, TransformerException {
        DocumentBuilder builder = VdldocGenerator.createDocumentBuilder();
        this.summaryDocument = builder.newDocument();
        Element vdldocElement = this.summaryDocument.createElementNS(NS_JAVAEE, "vdldoc");
        this.summaryDocument.appendChild(vdldocElement);
        Element configElement = this.summaryDocument.createElementNS(NS_JAVAEE, "config");
        vdldocElement.appendChild(configElement);
        Element windowTitle = this.summaryDocument.createElementNS(NS_JAVAEE, "window-title");
        windowTitle.appendChild(this.summaryDocument.createTextNode(this.windowTitle));
        configElement.appendChild(windowTitle);
        Element docTitle = this.summaryDocument.createElementNS(NS_JAVAEE, "doc-title");
        docTitle.appendChild(this.summaryDocument.createTextNode(this.docTitle));
        configElement.appendChild(docTitle);
        if (this.facesConfig != null) {
            this.print("Parsing faces-config.xml file... ");
            Document doc = VdldocGenerator.parse(builder, this.facesConfig);
            Node facesConfigNode = this.summaryDocument.importNode(doc.getDocumentElement(), true);
            vdldocElement.appendChild(facesConfigNode);
            this.println("OK!");
        }
        for (File taglib : this.taglibs) {
            this.print("Parsing " + taglib.getName() + " file... ");
            Document document = VdldocGenerator.parse(builder, taglib);
            Element element = document.getDocumentElement();
            NodeList compositeNodes = element.getElementsByTagNameNS("*", "composite-library-name");
            NodeList tagNodes = element.getElementsByTagNameNS("*", "tag");
            NodeList functionNodes = element.getElementsByTagNameNS("*", "function");
            int numTags = compositeNodes.getLength() + functionNodes.getLength() + tagNodes.getLength();
            if (numTags > 0) {
                Element taglibNode = (Element)this.summaryDocument.importNode(element, true);
                if (!taglibNode.getNamespaceURI().equals(NS_JAVAEE)) {
                    throw new IllegalArgumentException(String.format(ERROR_JAVAEE_MISSING, taglib.getName()));
                }
                if (!taglibNode.getLocalName().equals("facelet-taglib")) {
                    throw new IllegalArgumentException(String.format(ERROR_TAGLIB_MISSING, taglib.getName()));
                }
                String id = taglibNode.getAttribute("id");
                if (id == null || id.trim().isEmpty()) {
                    id = taglib.getName().substring(0, taglib.getName().indexOf(46));
                    taglibNode.setAttribute("id", id);
                    this.print(String.format(WARNING_ID_MISSING, taglib.getName(), id));
                }
                vdldocElement.appendChild(taglibNode);
                if (compositeNodes.getLength() > 0) {
                    File resourcesFolder;
                    File compositeLibraryFolder;
                    File[] compositeComponentFiles;
                    if (compositeNodes.getLength() > 1) {
                        throw new IllegalArgumentException(String.format(ERROR_INVALID_COMPOSITELIB, taglib.getName()));
                    }
                    String compositeLibraryName = compositeNodes.item(0).getTextContent();
                    File parentFolder = taglib.getParentFile();
                    if (parentFolder.getName().equals("WEB-INF")) {
                        parentFolder = parentFolder.getParentFile();
                    }
                    if ((compositeComponentFiles = (compositeLibraryFolder = new File(resourcesFolder = new File(parentFolder, "resources"), compositeLibraryName)).listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname != null && pathname.getName().endsWith(".xhtml");
                        }
                    })) != null) {
                        for (File compositeComponentFile : compositeComponentFiles) {
                            this.parseCompositeComponentFile(NS_JAVAEE, taglibNode, compositeComponentFile);
                            vdldocElement.appendChild(taglibNode);
                        }
                    }
                }
                this.println("OK!");
                continue;
            }
            this.println(String.format(WARNING_NO_TAGS, taglib.getName()));
        }
    }

    private void parseCompositeComponentFile(String namespaceURI, Node taglibNode, File inputFile) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(false);
        saxParserFactory.setNamespaceAware(true);
        SAXParser saxParser = saxParserFactory.newSAXParser();
        String inputFileName = inputFile.getName();
        String componentName = inputFileName.substring(0, inputFileName.lastIndexOf(".xhtml"));
        saxParser.parse(inputFile, (DefaultHandler)new CompositeComponentHandler(componentName, this.summaryDocument, namespaceURI, taglibNode, this.compositeAttributeMap));
    }

    private void copyStaticFiles() throws IOException {
        this.print("Copying static files... ");
        this.outputDirectory.mkdirs();
        VdldocGenerator.copyResourceToFile("stylesheet.css", this.outputDirectory);
        File outputResourceDirectory = new File(this.outputDirectory, "resources");
        outputResourceDirectory.mkdirs();
        VdldocGenerator.copyResourceToFile("background.gif", outputResourceDirectory);
        VdldocGenerator.copyResourceToFile("tab.gif", outputResourceDirectory);
        VdldocGenerator.copyResourceToFile("titlebar_end.gif", outputResourceDirectory);
        VdldocGenerator.copyResourceToFile("titlebar.gif", outputResourceDirectory);
        this.println("OK!");
    }

    private void generateOverview() throws TransformerException {
        this.print("Generating overview pages... ");
        this.generatePage(new File(this.outputDirectory, "index.html"), "index.html.xsl");
        this.generatePage(new File(this.outputDirectory, "help-doc.html"), "help-doc.html.xsl");
        this.generatePage(new File(this.outputDirectory, "overview-frame.html"), "overview-frame.html.xsl");
        this.generatePage(new File(this.outputDirectory, "alltags-frame.html"), "alltags-frame.html.xsl");
        this.generatePage(new File(this.outputDirectory, "alltags-noframe.html"), "alltags-noframe.html.xsl");
        this.generatePage(new File(this.outputDirectory, "overview-summary.html"), "overview-summary.html.xsl");
        this.println("OK!");
    }

    private void generateTaglibDetail() throws IllegalArgumentException, TransformerException {
        HashSet<String> ids = new HashSet<String>();
        Element root = this.summaryDocument.getDocumentElement();
        NodeList taglibs = root.getElementsByTagNameNS("*", "facelet-taglib");
        int size = taglibs.getLength();
        for (int i = 0; i < size; ++i) {
            Element taglib = (Element)taglibs.item(i);
            String id = taglib.getAttribute("id");
            if (!ids.add(id)) {
                throw new IllegalArgumentException(String.format(ERROR_DUPLICATE_ID, id));
            }
            this.print("Generating docs for taglib '" + id + "'... ");
            File outputDirectory = new File(this.outputDirectory, id);
            outputDirectory.mkdir();
            this.generateTaglibDetail(outputDirectory, id);
            NodeList tags = taglib.getElementsByTagNameNS("*", "tag");
            int numTags = tags.getLength();
            for (int j = 0; j < numTags; ++j) {
                Element tag = (Element)tags.item(j);
                String tagName = VdldocGenerator.findElementValue(tag, "tag-name");
                this.generateTagDetail(outputDirectory, id, tagName);
            }
            NodeList functions = taglib.getElementsByTagNameNS("*", "function");
            int numFunctions = functions.getLength();
            for (int j = 0; j < numFunctions; ++j) {
                Element function = (Element)functions.item(j);
                String functionName = VdldocGenerator.findElementValue(function, "function-name");
                this.generateFunctionDetail(outputDirectory, id, functionName);
            }
            this.println("OK!");
        }
    }

    private void generateTaglibDetail(File outputDirectory, String id) throws TransformerException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        this.generatePage(new File(outputDirectory, "tld-frame.html"), "tld-frame.html.xsl", parameters);
        this.generatePage(new File(outputDirectory, "tld-summary.html"), "tld-summary.html.xsl", parameters);
    }

    private void generateTagDetail(File outputDirectory, String id, String tagName) throws TransformerException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        parameters.put("tagName", tagName);
        this.generatePage(new File(outputDirectory, tagName + ".html"), "tag.html.xsl", parameters);
    }

    private void generateFunctionDetail(File outputDirectory, String id, String functionName) throws TransformerException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        parameters.put("functionName", functionName);
        this.generatePage(new File(outputDirectory, functionName + ".fn.html"), "function.html.xsl", parameters);
    }

    private void generatePage(File outputFile, String inputXSL) throws TransformerException {
        this.generatePage(outputFile, inputXSL, Collections.<String, String>emptyMap());
    }

    private void generatePage(File outputFile, String inputXSL, Map<String, String> params) throws TransformerException {
        InputStream xsl = VdldocGenerator.getResourceAsStream(inputXSL);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xsl));
        for (Map.Entry<String, String> entry : params.entrySet()) {
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
        transformer.transform(new DOMSource(this.summaryDocument), new StreamResult(outputFile));
    }

    private static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new CharArrayReader(new char[0]));
            }
        });
        return documentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parse(DocumentBuilder builder, File file) throws SAXException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            Document document = builder.parse(new InputSource(in));
            return document;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
    }

    private static String findElementValue(Element parent, String tagName) {
        Element child;
        Node body;
        String result = null;
        NodeList elements = parent.getElementsByTagNameNS("*", tagName);
        if (elements.getLength() >= 1 && (body = (child = (Element)elements.item(0)).getFirstChild()).getNodeType() == 3) {
            result = body.getNodeValue();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyResourceToFile(String resourceName, File outputDirectory) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = VdldocGenerator.getResourceAsStream(resourceName);
            out = new FileOutputStream(new File(outputDirectory, resourceName));
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private static InputStream getResourceAsStream(String resourceName) {
        return VdldocGenerator.class.getResourceAsStream("/org/omnifaces/vdldoc/resources/" + resourceName);
    }

    private void print(String message) {
        if (!this.quiet) {
            System.out.print(message);
        }
    }

    private void println(String message) {
        if (!this.quiet) {
            System.out.println(message);
        }
    }
}

