/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.vdldoc;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.omnifaces.vdldoc.ImpliedAttribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompositeComponentHandler
extends DefaultHandler {
    private static final String ATTRIBUTE = "attribute";
    private static final String CC_EDITABLE_VALUE_HOLDER = "cc:editableValueHolder";
    private static final String CC_VALUE_HOLDER = "cc:valueHolder";
    private static final String CC_ATTRIBUTE = "cc:attribute";
    private static final String CC_INTERFACE = "cc:interface";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_TYPE = "component-type";
    private static final String DESCRIPTION = "description";
    private static final String DISPLAY_NAME = "displayName";
    private static final String FACELET_COMPOSITE_COMPONENT = "Facelet Composite Component";
    private static final String NAME = "name";
    private static final String REQUIRED = "required";
    private static final String SHORT_DESCRIPTION = "shortDescription";
    private static final String TAG = "tag";
    private static final String TAG_NAME = "tag-name";
    private static final String TYPE = "type";
    private String componentName;
    private Document document;
    private String namespaceURI;
    private boolean parsingInterface;
    private boolean valueGiven;
    private boolean valueHolder;
    private Node tagNode;
    private Node taglibNode;
    private HashMap<String, ImpliedAttribute> attributeMap;

    public CompositeComponentHandler(String componentName, Document document, String namespaceURI, Node taglibNode, HashMap<String, ImpliedAttribute> properties) {
        this.componentName = componentName;
        this.document = document;
        this.namespaceURI = namespaceURI;
        this.taglibNode = taglibNode;
        this.attributeMap = properties;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName != null && qName.equals(CC_INTERFACE)) {
            this.parsingInterface = false;
            if (this.valueHolder) {
                if (this.valueGiven) {
                    System.out.println("INFO: valueHolder = " + this.valueHolder + ", but valueGiven = " + this.valueGiven + ". Since the xhtml declares a value attribute, we are not adding the implied value attribute for this composite component to the Vdldoc.");
                } else {
                    this.addImpliedAttribute(this.tagNode, "value", "value", "The current value of this component.", "false", "java.lang.Object");
                }
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void startElement(String uri, String localName, String elementName, Attributes attributes) throws SAXException {
        if (elementName != null) {
            if (elementName.equals(CC_INTERFACE)) {
                this.parsingInterface = true;
                this.valueGiven = false;
                Element tagElement = this.document.createElementNS(this.namespaceURI, TAG);
                this.tagNode = this.taglibNode.appendChild(tagElement);
                String shortDescription = attributes.getValue(SHORT_DESCRIPTION);
                if (shortDescription != null) {
                    Element shortDescriptionElement = this.document.createElementNS(this.namespaceURI, DESCRIPTION);
                    shortDescriptionElement.setTextContent(shortDescription);
                    this.tagNode.appendChild(shortDescriptionElement);
                }
                Element tagNameElement = this.document.createElementNS(this.namespaceURI, TAG_NAME);
                tagNameElement.setTextContent(this.componentName);
                this.tagNode.appendChild(tagNameElement);
                Element componentElement = this.document.createElementNS(this.namespaceURI, COMPONENT);
                Element componentTypeElement = this.document.createElementNS(this.namespaceURI, COMPONENT_TYPE);
                componentTypeElement.setTextContent(FACELET_COMPOSITE_COMPONENT);
                componentElement.appendChild(componentTypeElement);
                this.tagNode.appendChild(componentElement);
                for (Map.Entry<String, ImpliedAttribute> entry : this.attributeMap.entrySet()) {
                    String name = entry.getKey();
                    ImpliedAttribute attribute = entry.getValue();
                    this.addImpliedAttribute(this.tagNode, name, attribute.getDisplayName(), attribute.getDescription(), attribute.getRequired(), attribute.getType());
                }
            } else if (elementName.equals(CC_ATTRIBUTE)) {
                if (this.parsingInterface) {
                    String required;
                    String displayName;
                    Node attributeNode = this.tagNode.appendChild(this.document.createElementNS(this.namespaceURI, ATTRIBUTE));
                    String description = attributes.getValue(SHORT_DESCRIPTION);
                    if (description != null) {
                        Element descriptionElement = this.document.createElementNS(this.namespaceURI, DESCRIPTION);
                        descriptionElement.setTextContent(description);
                        attributeNode.appendChild(descriptionElement);
                    }
                    if ((displayName = attributes.getValue(DISPLAY_NAME)) != null) {
                        Element displayNameElement = this.document.createElementNS(this.namespaceURI, DISPLAY_NAME);
                        displayNameElement.setTextContent(displayName);
                        attributeNode.appendChild(displayNameElement);
                    }
                    Element nameElement = this.document.createElementNS(this.namespaceURI, NAME);
                    String name = attributes.getValue(NAME);
                    nameElement.setTextContent(name);
                    attributeNode.appendChild(nameElement);
                    if ("value".equals(name)) {
                        this.valueGiven = true;
                    }
                    if ((required = attributes.getValue(REQUIRED)) == null) {
                        required = Boolean.FALSE.toString();
                    }
                    Element requiredElement = this.document.createElementNS(this.namespaceURI, REQUIRED);
                    requiredElement.setTextContent(required);
                    attributeNode.appendChild(requiredElement);
                    String type = attributes.getValue(TYPE);
                    if (type == null) {
                        type = String.class.getName();
                    }
                    Element typeElement = this.document.createElementNS(this.namespaceURI, TYPE);
                    typeElement.setTextContent(type);
                    attributeNode.appendChild(typeElement);
                }
            } else if (elementName.equals(CC_VALUE_HOLDER)) {
                if (this.parsingInterface) {
                    this.valueHolder = true;
                }
            } else if (elementName.equals(CC_EDITABLE_VALUE_HOLDER) && this.parsingInterface) {
                this.valueHolder = true;
            }
        }
    }

    public void addImpliedAttribute(Node node, String name, String displayName, String description, String required, String type) {
        Node attributeNode = node.appendChild(this.document.createElementNS(this.namespaceURI, ATTRIBUTE));
        Element nameElement = this.document.createElementNS(this.namespaceURI, NAME);
        nameElement.setTextContent(name);
        attributeNode.appendChild(nameElement);
        Element displayNameElement = this.document.createElementNS(this.namespaceURI, DISPLAY_NAME);
        displayNameElement.setTextContent(displayName);
        attributeNode.appendChild(displayNameElement);
        Element descriptionElement = this.document.createElementNS(this.namespaceURI, DESCRIPTION);
        descriptionElement.setTextContent(description);
        attributeNode.appendChild(descriptionElement);
        Element requiredElement = this.document.createElementNS(this.namespaceURI, REQUIRED);
        requiredElement.setTextContent(required);
        attributeNode.appendChild(requiredElement);
        Element typeElement = this.document.createElementNS(this.namespaceURI, TYPE);
        typeElement.setTextContent(type);
        attributeNode.appendChild(typeElement);
    }
}

