/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.antlr.proxy;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;

public class Helper {
    public static final Class<?>[] NO_ARG_SIGNATURE = new Class[0];
    public static final Class<?>[] STRING_ARG_SIGNATURE = new Class[]{String.class};
    public static final Object[] NO_ARGS = new Object[0];
    private final URLClassLoader antlrClassLoader;
    private final Class<?> antlrToolClass;
    private final Class<?> antlrPreprocessorToolClass;
    private final Class<?> antlrHierarchyClass;
    private final Class<?> antlrGrammarFileClass;
    private final Class<?> antlrGrammarClass;
    private final Class<?> antlrOptionClass;
    private final Class<?> antlrIndexedVectorClass;

    public Helper(Artifact antlrArtifact) throws MojoExecutionException {
        try {
            this.antlrClassLoader = new URLClassLoader(new URL[]{antlrArtifact.getFile().toURL()}, ClassLoader.getSystemClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to resolve antlr:antlr artifact url", (Exception)e);
        }
        this.antlrToolClass = this.loadAntlrClass("antlr.Tool");
        this.antlrPreprocessorToolClass = this.loadAntlrClass("antlr.preprocessor.Tool");
        this.antlrHierarchyClass = this.loadAntlrClass("antlr.preprocessor.Hierarchy");
        this.antlrGrammarFileClass = this.loadAntlrClass("antlr.preprocessor.GrammarFile");
        this.antlrGrammarClass = this.loadAntlrClass("antlr.preprocessor.Grammar");
        this.antlrOptionClass = this.loadAntlrClass("antlr.preprocessor.Option");
        this.antlrIndexedVectorClass = this.loadAntlrClass("antlr.collections.impl.IndexedVector");
    }

    private Class<?> loadAntlrClass(String className) throws MojoExecutionException {
        try {
            return this.antlrClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("could not load Antlr class :" + className, (Exception)e);
        }
    }

    public Class<?> getAntlrToolClass() {
        return this.antlrToolClass;
    }

    public Class<?> getAntlrPreprocessorToolClass() {
        return this.antlrPreprocessorToolClass;
    }

    public Class<?> getAntlrHierarchyClass() {
        return this.antlrHierarchyClass;
    }

    public Class<?> getAntlrGrammarFileClass() {
        return this.antlrGrammarFileClass;
    }

    public Class<?> getAntlrGrammarClass() {
        return this.antlrGrammarClass;
    }

    public Class<?> getAntlrOptionClass() {
        return this.antlrOptionClass;
    }

    public Class<?> getAntlrIndexedVectorClass() {
        return this.antlrIndexedVectorClass;
    }
}

