/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.antlr.metadata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.mojo.antlr.metadata.Grammar;
import org.codehaus.mojo.antlr.metadata.GrammarFile;

public class XRef {
    private final Object antlrHierarchy;
    private LinkedHashMap<String, GrammarFile> filesById = new LinkedHashMap();
    private Map<String, GrammarFile> filesByExportVocab = new HashMap<String, GrammarFile>();
    private Map<String, GrammarFile> filesByClassName = new HashMap<String, GrammarFile>();

    public XRef(Object antlrHierarchy) {
        this.antlrHierarchy = antlrHierarchy;
    }

    public Object getAntlrHierarchy() {
        return this.antlrHierarchy;
    }

    void addGrammarFile(GrammarFile grammarFile) {
        this.filesById.put(grammarFile.getId(), grammarFile);
        for (Grammar grammar : grammarFile.getGrammars()) {
            GrammarFile old;
            this.filesByClassName.put(grammar.getClassName(), grammarFile);
            if (grammar.getExportVocab() == null || (old = this.filesByExportVocab.put(grammar.getExportVocab(), grammarFile)) == null || old == grammarFile) continue;
            System.out.println("[WARNING] : multiple grammars defined the same exportVocab : " + grammar.getExportVocab());
        }
    }

    public Iterator<GrammarFile> iterateGrammarFiles() {
        return this.filesById.values().iterator();
    }

    public GrammarFile getGrammarFileById(String id) {
        return this.filesById.get(id);
    }

    public GrammarFile getGrammarFileByClassName(String className) {
        return this.filesByClassName.get(className);
    }

    public GrammarFile getGrammarFileByExportVocab(String exportVocab) {
        return this.filesByExportVocab.get(exportVocab);
    }
}

