/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.antlr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.antlr.Environment;
import org.codehaus.mojo.antlr.metadata.MetadataExtracter;
import org.codehaus.mojo.antlr.metadata.XRef;
import org.codehaus.mojo.antlr.options.Grammar;
import org.codehaus.mojo.antlr.plan.GenerationPlan;
import org.codehaus.mojo.antlr.plan.GenerationPlanBuilder;
import org.codehaus.mojo.antlr.proxy.Helper;
import org.codehaus.plexus.util.StringOutputStream;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractAntlrMojo
extends AbstractMojo
implements Environment {
    protected File sourceDirectory;
    protected MavenProject project;
    private MavenProjectHelper projectHelper;
    protected File outputDirectory;
    protected String grammars;
    protected Grammar[] grammarDefs;
    private boolean debug;
    private boolean diagnostic;
    private boolean trace;
    private boolean traceParser;
    private boolean traceLexer;
    private boolean traceTreeParser;

    @Override
    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected void executeAntlr() throws MojoExecutionException {
        System.setProperty("ANTLR_DO_NOT_EXIT", "true");
        System.setProperty("ANTLR_USE_DIRECT_CLASS_LOADING", "true");
        this.validateParameters();
        Artifact antlrArtifact = this.locateAntlrArtifact();
        MetadataExtracter metadataExtracter = new MetadataExtracter(this, new Helper(antlrArtifact));
        XRef metadata = metadataExtracter.processMetadata(this.getGrammars());
        for (GenerationPlan plan : new GenerationPlanBuilder(this).buildGenerationPlans(metadata)) {
            if (!plan.isOutOfDate()) {
                this.getLog().info((CharSequence)("grammar [" + plan.getId() + "] was up-to-date; skipping"));
                continue;
            }
            this.getLog().info((CharSequence)("performing grammar generation [" + plan.getId() + "]"));
            this.performGeneration(plan, antlrArtifact);
        }
        if (this.project != null) {
            this.projectHelper.addResource(this.project, this.outputDirectory.getAbsolutePath(), Collections.singletonList("**/**.txt"), new ArrayList());
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
    }

    protected final Artifact locateAntlrArtifact() throws NoAntlrDependencyDefinedException {
        Artifact antlrArtifact = null;
        if (this.project.getCompileArtifacts() != null) {
            for (Artifact artifact : this.project.getCompileArtifacts()) {
                if (!"antlr".equals(artifact.getGroupId()) || !"antlr".equals(artifact.getArtifactId()) && !"antlr-all".equals(artifact.getArtifactId())) continue;
                antlrArtifact = artifact;
                break;
            }
        }
        if (antlrArtifact == null) {
            throw new NoAntlrDependencyDefinedException("project did not define antlr:antlr depenency");
        }
        return antlrArtifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performGeneration(GenerationPlan plan, Artifact antlrArtifact) throws MojoExecutionException {
        block15: {
            if (!plan.getGenerationDirectory().getParentFile().exists()) {
                plan.getGenerationDirectory().getParentFile().mkdirs();
            }
            LinkedList<String> arguments = new LinkedList<String>();
            AbstractAntlrMojo.addArgIf(arguments, this.debug, "-debug");
            AbstractAntlrMojo.addArgIf(arguments, this.diagnostic, "-diagnostic");
            AbstractAntlrMojo.addArgIf(arguments, this.trace, "-trace");
            AbstractAntlrMojo.addArgIf(arguments, this.traceParser, "-traceParser");
            AbstractAntlrMojo.addArgIf(arguments, this.traceLexer, "-traceLexer");
            AbstractAntlrMojo.addArgIf(arguments, this.traceTreeParser, "-traceTreeParser");
            this.addArgs(arguments);
            arguments.add("-o");
            arguments.add(plan.getGenerationDirectory().getPath());
            if (plan.getCollectedSuperGrammarIds().size() > 0) {
                arguments.add("-glib");
                StringBuffer buffer = new StringBuffer();
                Iterator ids = plan.getCollectedSuperGrammarIds().iterator();
                while (ids.hasNext()) {
                    buffer.append(new File(this.sourceDirectory, (String)ids.next()));
                    if (!ids.hasNext()) continue;
                    buffer.append(';');
                }
                arguments.add(buffer.toString());
            }
            arguments.add(plan.getSource().getPath());
            Object[] args = arguments.toArray(new String[arguments.size()]);
            if (plan.getImportVocabTokenTypesDirectory() != null && !plan.getImportVocabTokenTypesDirectory().equals(plan.getGenerationDirectory())) {
                CommandLine commandLine = new CommandLine("java");
                commandLine.addArgument("-classpath", false);
                commandLine.addArgument(this.generateClasspathForProcessSpawning(antlrArtifact), true);
                commandLine.addArgument("antlr.Tool", false);
                commandLine.addArguments((String[])args, true);
                DefaultExecutor executor = new DefaultExecutor();
                executor.setWorkingDirectory(plan.getImportVocabTokenTypesDirectory());
                try {
                    executor.execute(commandLine);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Error spawning process to execute antlr tool : " + e.getMessage()));
                }
                return;
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("antlr args=\n" + StringUtils.join((Object[])args, (String)"\n")));
            }
            String originalUserDir = null;
            if (plan.getImportVocabTokenTypesDirectory() != null) {
                originalUserDir = System.getProperty("user.dir");
                System.setProperty("user.dir", plan.getImportVocabTokenTypesDirectory().getPath());
            }
            PrintStream oldErr = System.err;
            StringOutputStream errOS = new StringOutputStream();
            PrintStream err = new PrintStream((OutputStream)errOS);
            System.setErr(err);
            try {
                this.executeAntlrInIsolatedClassLoader(arguments.toArray(new String[0]), antlrArtifact);
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("ANTLR Panic")) {
                    this.getLog().debug((Throwable)e);
                    break block15;
                }
                throw new MojoExecutionException("Antlr execution failed: " + e.getMessage() + "\n Error output:\n" + (OutputStream)errOS, (Exception)e);
            }
            finally {
                if (originalUserDir != null) {
                    System.setProperty("user.dir", originalUserDir);
                }
                System.setErr(oldErr);
                System.err.println(errOS.toString());
            }
        }
    }

    private String generateClasspathForProcessSpawning(Artifact antlrArtifact) {
        return antlrArtifact.getFile().getPath();
    }

    private void executeAntlrInIsolatedClassLoader(String[] args, Artifact antlrArtifact) throws MojoExecutionException {
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{antlrArtifact.getFile().toURI().toURL()}, ClassLoader.getSystemClassLoader());){
            classLoader.loadClass("antlr.Tool").getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to resolve antlr:antlr artifact url", (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("could not locate antlr.Tool class");
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("error locating antlt.Tool#main", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("error perforing antlt.Tool#main", e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("error perforing antlt.Tool#main", (Exception)e);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    protected abstract void addArgs(List<String> var1);

    protected static void addArgIf(List<String> arguments, boolean b, String value) {
        if (b) {
            arguments.add(value);
        }
    }

    private File getGeneratedFile(String grammar, File outputDir) throws IOException {
        String line;
        String generatedFileName = null;
        String packageName = "";
        BufferedReader in = new BufferedReader(new FileReader(grammar));
        while ((line = in.readLine()) != null) {
            line = line.trim();
            int extendsIndex = line.indexOf(" extends ");
            if (line.startsWith("class ") && extendsIndex > -1) {
                generatedFileName = line.substring(6, extendsIndex).trim();
                break;
            }
            if (!line.startsWith("package")) continue;
            packageName = line.substring(8).trim();
        }
        in.close();
        if (generatedFileName == null) {
            throw new IOException("Unable to generate the output file name: is the grammar '" + grammar + "' valide?");
        }
        File genFile = null;
        if ("".equals(packageName)) {
            genFile = new File(outputDir, generatedFileName + ".java");
        } else {
            String packagePath = packageName.replace('.', File.separatorChar);
            packagePath = packagePath.replace(';', File.separatorChar);
            genFile = new File(new File(outputDir, packagePath), generatedFileName + ".java");
        }
        return genFile;
    }

    private void validateParameters() throws MojoExecutionException {
        if (StringUtils.isEmpty((String)this.grammars) && (this.grammarDefs == null || this.grammarDefs.length == 0)) {
            StringBuffer msg = new StringBuffer();
            msg.append("Antlr plugin parameters are invalid/missing.").append('\n');
            msg.append("Inside the definition for plugin 'antlr-maven-plugin' specify the following:").append('\n');
            msg.append('\n');
            msg.append("<configuration>").append('\n');
            msg.append("  <grammars>VALUE</grammars>").append('\n');
            msg.append("- OR - ").append('\n');
            msg.append("  <grammarDefs>VALUE</grammarDefs>").append('\n');
            msg.append("</configuration>").append('\n');
            throw new MojoExecutionException(msg.toString());
        }
    }

    private Grammar[] getGrammars() {
        ArrayList<Grammar> grammarList = new ArrayList<Grammar>();
        HashSet grammarSet = new HashSet();
        if (StringUtils.isNotEmpty((String)this.grammars)) {
            StringTokenizer st = new StringTokenizer(this.grammars, ", ");
            while (st.hasMoreTokens()) {
                String currentGrammar = st.nextToken().trim();
                if (!StringUtils.isNotEmpty((String)currentGrammar)) continue;
                if (currentGrammar.indexOf(42) != -1 || currentGrammar.indexOf(63) != -1) {
                    final String transformedGrammar = currentGrammar.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*").replaceAll("\\?", ".");
                    String[] dir = this.sourceDirectory.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String s) {
                            return Pattern.matches(transformedGrammar, s);
                        }
                    });
                    if (dir == null || dir.length == 0) continue;
                    for (int i = 0; i < dir.length; ++i) {
                        if (grammarSet.contains(dir[i])) continue;
                        Grammar grammar = new Grammar();
                        grammar.setName(dir[i]);
                        grammarList.add(grammar);
                    }
                    continue;
                }
                if (grammarSet.contains(currentGrammar)) continue;
                Grammar grammar = new Grammar();
                grammar.setName(currentGrammar);
                grammarList.add(grammar);
            }
        }
        if (this.grammarDefs != null) {
            grammarList.addAll(Arrays.asList(this.grammarDefs));
        }
        return grammarList.toArray(new Grammar[0]);
    }

    public static class NoAntlrDependencyDefinedException
    extends MojoExecutionException {
        public NoAntlrDependencyDefinedException(String s) {
            super(s);
        }
    }
}

