/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.engine;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.ofdrw.layout.PageLayout;
import org.ofdrw.layout.element.BR;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.element.Position;
import org.ofdrw.layout.engine.Segment;

public class SegmentationEngine {
    private PageLayout pageLayout;

    private SegmentationEngine() {
    }

    public SegmentationEngine(PageLayout pageLayout) {
        this.pageLayout = pageLayout;
    }

    public List<Segment> process(List<Div> streamLayoutQueue) {
        double width = this.pageLayout.contentWidth();
        if (streamLayoutQueue == null || streamLayoutQueue.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Segment> res = new LinkedList<Segment>();
        LinkedList<Div> seq = new LinkedList<Div>(streamLayoutQueue);
        Segment segment = new Segment(width);
        while (!seq.isEmpty()) {
            Div div = seq.pop();
            if (div.getPosition() == Position.Absolute) continue;
            if (div instanceof BR) {
                if (segment.isEmpty()) continue;
                res.add(segment);
                segment = new Segment(width);
                continue;
            }
            boolean addSuccess = segment.tryAdd(div);
            if (addSuccess || segment.isEmpty()) continue;
            res.add(segment);
            segment = new Segment(width);
            seq.push(div);
        }
        if (!segment.isEmpty()) {
            res.add(segment);
        }
        return res;
    }
}

