/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element.canvas;

import java.io.IOException;
import java.nio.file.Path;
import org.ofdrw.layout.element.canvas.Canvas;
import org.ofdrw.layout.element.canvas.CellContentDrawer;
import org.ofdrw.layout.element.canvas.Drawer;
import org.ofdrw.layout.element.canvas.TextAlign;
import org.ofdrw.layout.element.canvas.VerticalAlign;

public class Cell
extends Canvas {
    private final CellContentDrawer cellDrawer = new CellContentDrawer(this);

    public Cell(Double width, Double height) {
        super(width, height);
        this.setDrawer(this.cellDrawer);
    }

    public Cell(double x, double y, double w, double h) {
        super(x, y, w, h);
        this.setDrawer(this.cellDrawer);
    }

    @Override
    public Cell setDrawer(Drawer drawer) {
        if (!(drawer instanceof CellContentDrawer)) {
            throw new IllegalArgumentException("Cell\u7684\u7ed8\u5236\u5668\u5fc5\u987b\u662fCellContentDrawer");
        }
        super.setDrawer(drawer);
        return this;
    }

    @Override
    public CellContentDrawer getDrawer() {
        return this.cellDrawer;
    }

    public String getValue() {
        return this.cellDrawer.getValue();
    }

    public Cell setValue(String value) {
        this.cellDrawer.setValue(value);
        return this;
    }

    public Cell setValue(Path imgPath, double w, double h) {
        this.cellDrawer.setValue(imgPath, w, h);
        return this;
    }

    public Cell setValue(Path imgPath) throws IOException {
        this.cellDrawer.setValue(imgPath);
        return this;
    }

    public String getColor() {
        return this.cellDrawer.getColor();
    }

    public Cell setColor(String color) {
        if (color == null || color.isEmpty()) {
            throw new IllegalArgumentException("\u989c\u8272(color)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.cellDrawer.setColor(color);
        return this;
    }

    public String getFontName() {
        return this.cellDrawer.getFontName();
    }

    public Cell setFontName(String fontName) {
        this.cellDrawer.setFontName(fontName);
        return this;
    }

    public Cell setFont(String fontName, Path fontPath) {
        this.cellDrawer.setFont(fontName, fontPath);
        return this;
    }

    public double getFontSize() {
        return this.cellDrawer.getFontSize();
    }

    public Cell setFontSize(double fontSize) {
        this.cellDrawer.setFontSize(fontSize);
        return this;
    }

    public TextAlign getTextAlign() {
        return this.cellDrawer.getTextAlign();
    }

    public Cell setTextAlign(TextAlign textAlign) {
        this.cellDrawer.setTextAlign(textAlign);
        return this;
    }

    public VerticalAlign getVerticalAlign() {
        return this.cellDrawer.getVerticalAlign();
    }

    public Cell setVerticalAlign(VerticalAlign verticalAlign) {
        this.cellDrawer.setVerticalAlign(verticalAlign);
        return this;
    }

    public Double getLineSpace() {
        return this.cellDrawer.getLineSpace();
    }

    public Cell setLineSpace(Double lineSpace) {
        this.cellDrawer.setLineSpace(lineSpace);
        return this;
    }

    @Deprecated
    public Boolean getBlob() {
        return this.cellDrawer.getBlob();
    }

    @Deprecated
    public Cell setBlob(Boolean blob) {
        this.cellDrawer.setBlob(blob);
        return this;
    }

    public Boolean getBold() {
        return this.cellDrawer.getBold();
    }

    public Cell setBold(Boolean blob) {
        this.cellDrawer.setBold(blob);
        return this;
    }

    public Boolean getItalic() {
        return this.cellDrawer.getItalic();
    }

    public Cell setItalic(Boolean italic) {
        this.cellDrawer.setItalic(italic);
        return this;
    }

    public Double getLetterSpacing() {
        return this.cellDrawer.getLetterSpacing();
    }

    public Cell setLetterSpacing(Double letterSpacing) {
        this.cellDrawer.setLetterSpacing(letterSpacing);
        return this;
    }

    public Cell setUnderline(boolean underline) {
        this.cellDrawer.setUnderline(underline);
        return this;
    }

    public boolean getUnderline() {
        return this.cellDrawer.getUnderline();
    }

    public Cell setDeleteLine(boolean deleteLine) {
        this.cellDrawer.setDeleteLine(deleteLine);
        return this;
    }

    public boolean getDeleteLine() {
        return this.cellDrawer.getDeleteLine();
    }

    public Path getImgPath() {
        return this.cellDrawer.getImgPath();
    }

    public double getImgWidth() {
        return this.cellDrawer.getImgWidth();
    }

    public double getImgHeight() {
        return this.cellDrawer.getImgHeight();
    }
}

