/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element;

import java.util.LinkedList;
import java.util.List;
import org.ofdrw.layout.Rectangle;
import org.ofdrw.layout.element.Span;
import org.ofdrw.layout.element.TextAlign;
import org.ofdrw.layout.element.TxtGlyph;

public class TxtLineBlock {
    private TextAlign textAlign;
    private List<Span> inlineSpans;
    private Double maxSpanHeight = 0.0;
    private Double width = 0.0;
    private Double lineSpace;
    private double lineMaxAvailableWidth;

    private TxtLineBlock() {
    }

    public TxtLineBlock(double lineMaxAvailableWidth, Double lineSpace) {
        this(lineMaxAvailableWidth, lineSpace, TextAlign.left);
    }

    public TxtLineBlock(double lineMaxAvailableWidth, Double lineSpace, TextAlign textAlign) {
        this.lineMaxAvailableWidth = lineMaxAvailableWidth;
        this.lineSpace = lineSpace;
        if (textAlign == null) {
            textAlign = TextAlign.left;
        }
        this.textAlign = textAlign;
        this.inlineSpans = new LinkedList<Span>();
    }

    public boolean tryAdd(Span span) {
        Rectangle rec = span.blockSize();
        if (rec.getWidth() + this.width > this.lineMaxAvailableWidth) {
            return false;
        }
        this.width = this.width + rec.getWidth();
        if (rec.getHeight() > this.maxSpanHeight) {
            this.maxSpanHeight = rec.getHeight();
        }
        this.inlineSpans.add(span);
        return true;
    }

    public Span trySplitAdd(Span span) {
        if (span.isIntegrity().booleanValue()) {
            throw new IllegalStateException("\u6587\u5b57\u5355\u5143\uff08Span\uff09\u4e0d\u53ef\u62c6\u5206");
        }
        double remainWidth = this.lineMaxAvailableWidth - this.width;
        int splitIndex = 0;
        List<TxtGlyph> txtGlyphs = span.glyphList();
        for (int i = 0; i < txtGlyphs.size(); ++i) {
            TxtGlyph txt = txtGlyphs.get(i);
            if (txt.getW() <= remainWidth) {
                remainWidth -= txt.getW();
                continue;
            }
            if (i == 0) {
                return null;
            }
            splitIndex = i;
            break;
        }
        Span[] split = span.split(splitIndex);
        this.tryAdd(split[0]);
        return split[1];
    }

    public boolean isEmpty() {
        return this.inlineSpans.isEmpty();
    }

    public List<Span> getInlineSpans() {
        return this.inlineSpans;
    }

    public Rectangle size() {
        return new Rectangle(this.width, this.maxSpanHeight + this.lineSpace);
    }

    public double getHeight() {
        return this.maxSpanHeight + this.lineSpace;
    }

    public Double getLineSpace() {
        return this.lineSpace;
    }

    public Double getMaxSpanHeight() {
        return this.maxSpanHeight;
    }

    public Double getWidth() {
        return this.width;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public double getLineMaxAvailableWidth() {
        return this.lineMaxAvailableWidth;
    }
}

