/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element;

import java.util.LinkedList;
import org.ofdrw.layout.Rectangle;
import org.ofdrw.layout.element.Span;

public class PlaceholderSpan
extends Span {
    private int holdNum;
    private double holdWidth;

    public PlaceholderSpan(double holdWidth, double height) {
        this.holdWidth = holdWidth;
        this.setFontSize(height);
        this.setIntegrity(true);
    }

    public PlaceholderSpan(int holdNum, double fontSize) {
        this.setFontSize(fontSize);
        this.setIntegrity(true);
        this.setHoldChars(holdNum);
    }

    public PlaceholderSpan(int holdNum, Span sp) {
        this.setIntegrity(true);
        this.setFontSize(sp.getFontSize());
        this.setLetterSpacing(sp.getLetterSpacing());
        this.setHoldChars(holdNum);
    }

    public PlaceholderSpan setHoldChars(int holdNum) {
        this.holdNum = holdNum;
        this.holdWidth = (double)holdNum * (this.getFontSize() + this.getLetterSpacing());
        return this;
    }

    public int getHoldNum() {
        return this.holdNum;
    }

    public double getHoldWidth() {
        return this.holdWidth;
    }

    public PlaceholderSpan setHoldWidth(double holdWidth) {
        this.holdWidth = holdWidth;
        return this;
    }

    @Override
    public Rectangle blockSize() {
        return new Rectangle(this.holdWidth, this.getFontSize());
    }

    @Override
    public LinkedList<Span> splitLineBreak() {
        LinkedList<Span> res = new LinkedList<Span>();
        res.add(this);
        return res;
    }
}

