/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.crypto.encryt;

import java.io.Serializable;
import java.util.Base64;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ofdrw.core.OFDElement;

public class UserInfo
extends OFDElement {
    public static final String UserTypeOwner = "Owner";
    public static final String UserTypeUser = "User";

    public UserInfo(Element proxy) {
        super(proxy);
    }

    public UserInfo() {
        super("UserInfo");
    }

    public UserInfo setUserName(@Nullable String userName) {
        if (userName == null) {
            this.removeAttr("UserName");
            return this;
        }
        this.addAttribute("UserName", userName);
        return this;
    }

    @Nullable
    public String getUserName() {
        return this.attributeValue("UserName");
    }

    public UserInfo setUserType(@Nullable String userType) {
        if (userType == null) {
            this.removeAttr("UserType");
            return this;
        }
        this.addAttribute("UserType", userType);
        return this;
    }

    @NotNull
    public String getUserType() {
        String userType = this.attributeValue("UserType");
        return userType == null ? UserTypeUser : userType;
    }

    public UserInfo setUserCert(@Nullable byte[] userCert) {
        if (userCert == null) {
            this.removeOFDElemByNames("UserCert");
            return this;
        }
        this.addOFDEntity("UserCert", (Serializable)((Object)Base64.getEncoder().encodeToString(userCert)));
        return this;
    }

    @Nullable
    public byte[] getUserCert() {
        Element e = this.getOFDElement("UserCert");
        if (e == null) {
            return null;
        }
        return Base64.getDecoder().decode(e.getTextTrim());
    }

    public UserInfo setEncryptedWK(@NotNull byte[] encryptedWk) {
        if (encryptedWk == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u5bf9\u79f0\u52a0\u5bc6\u7684\u5305\u88c5\u5bc6\u94a5\uff08EncrypteWk\uff09\u4e3a\u7a7a");
        }
        this.setOFDEntity("EncryptedWK", (Serializable)((Object)Base64.getEncoder().encodeToString(encryptedWk)));
        return this;
    }

    @NotNull
    public byte[] getEncryptedWK() {
        Element e = this.getOFDElement("EncryptedWK");
        if (e == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u5bf9\u79f0\u52a0\u5bc6\u7684\u5305\u88c5\u5bc6\u94a5(EncryptedWK)\u4e0d\u5b58\u5728");
        }
        return Base64.getDecoder().decode(e.getTextTrim());
    }

    public UserInfo setIVValue(byte[] ivValue) {
        if (ivValue == null) {
            this.removeOFDElemByNames("IVValue");
        }
        this.setOFDEntity("IVValue", (Serializable)((Object)Base64.getEncoder().encodeToString(ivValue)));
        return this;
    }

    public byte[] getIVValue() {
        Element e = this.getOFDElement("IVValue");
        return e == null ? new byte[16] : Base64.getDecoder().decode(e.getTextTrim());
    }
}

