/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.client;

import java.util.Map;
import org.odpi.openmetadata.conformance.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.conformance.ffdc.exception.PropertyServerException;
import org.odpi.openmetadata.conformance.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.conformance.rest.ConformanceServicesAPIResponse;

class RESTExceptionHandler {
    RESTExceptionHandler() {
    }

    void detectAndThrowInvalidParameterException(String methodName, ConformanceServicesAPIResponse restResult) throws InvalidParameterException {
        String exceptionClassName = InvalidParameterException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String paramName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("parameterName")) != null) {
                paramName = (String)nameObject;
            }
            throw new InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), paramName);
        }
    }

    void detectAndThrowPropertyServerException(String methodName, ConformanceServicesAPIResponse restResult) throws PropertyServerException {
        String exceptionClassName = PropertyServerException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new PropertyServerException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        }
    }

    void detectAndThrowUserNotAuthorizedException(String methodName, ConformanceServicesAPIResponse restResult) throws UserNotAuthorizedException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object userIdObject;
            String userId = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (userIdObject = exceptionProperties.get("userId")) != null) {
                userId = (String)userIdObject;
            }
            throw new UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), userId);
        }
    }
}

