/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.client;

import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientFactory;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.exceptions.RESTConfigurationException;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.exceptions.RESTServerException;
import org.odpi.openmetadata.conformance.ffdc.ConformanceSuiteErrorCode;
import org.odpi.openmetadata.conformance.rest.TestLabReportResponse;

class RESTClient {
    private RESTClientConnector clientConnector;

    RESTClient(String serverName, String serverPlatformURLRoot) throws RESTConfigurationException {
        String methodName = "RESTClient(no authentication)";
        RESTClientFactory factory = new RESTClientFactory(serverName, serverPlatformURLRoot);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Throwable error) {
            ConformanceSuiteErrorCode errorCode = ConformanceSuiteErrorCode.NULL_LOCAL_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, error.getMessage()});
            throw new RESTConfigurationException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "RESTClient(no authentication)", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    RESTClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws RESTConfigurationException {
        String methodName = "RESTClient(userId and password)";
        RESTClientFactory factory = new RESTClientFactory(serverName, serverPlatformURLRoot, userId, password);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Throwable error) {
            ConformanceSuiteErrorCode errorCode = ConformanceSuiteErrorCode.NULL_LOCAL_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, error.getMessage()});
            throw new RESTConfigurationException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "RESTClient(userId and password)", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    TestLabReportResponse callReportGetRESTCall(String methodName, String urlTemplate, Object ... params) throws RESTServerException {
        return (TestLabReportResponse)this.clientConnector.callGetRESTCall(methodName, TestLabReportResponse.class, urlTemplate, params);
    }
}

