/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.exceptions.RESTConfigurationException;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.exceptions.RESTServerException;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceTestLabResults;
import org.odpi.openmetadata.conformance.client.RESTClient;
import org.odpi.openmetadata.conformance.client.RESTExceptionHandler;
import org.odpi.openmetadata.conformance.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.conformance.ffdc.exception.PropertyServerException;
import org.odpi.openmetadata.conformance.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.conformance.rest.ConformanceServicesAPIResponse;
import org.odpi.openmetadata.conformance.rest.TestLabReportResponse;

public class OpenMetadataConformanceTestReport {
    private String serverName;
    private String serverURLRoot;
    private String testClientUserId;
    private RESTClient restClient;
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    private OpenMetadataConformanceTestReport(String serverName, String serverURLRoot, String testClientUserId) throws RESTConfigurationException {
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.testClientUserId = testClientUserId;
        this.restClient = new RESTClient(serverName, serverURLRoot);
    }

    private OpenMetadataConformanceTestReport(String serverName, String serverURLRoot, String testClientUserId, String testClientPassword) throws RESTConfigurationException {
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.testClientUserId = testClientUserId;
        this.restClient = new RESTClient(serverName, serverURLRoot, testClientUserId, testClientPassword);
    }

    private OpenMetadataConformanceTestLabResults getConformanceReport() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConformanceReport";
        String urlTemplate = "/servers/{0}/open-metadata/conformance-suite/users/{1}/report";
        try {
            TestLabReportResponse restResult = this.restClient.callReportGetRESTCall("getConformanceReport", this.serverURLRoot + "/servers/{0}/open-metadata/conformance-suite/users/{1}/report", this.serverName, this.testClientUserId);
            this.exceptionHandler.detectAndThrowInvalidParameterException("getConformanceReport", (ConformanceServicesAPIResponse)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getConformanceReport", (ConformanceServicesAPIResponse)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException("getConformanceReport", (ConformanceServicesAPIResponse)restResult);
            return restResult.getTestLabResults();
        }
        catch (RESTServerException error) {
            throw new PropertyServerException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), (Throwable)error);
        }
    }

    public static void main(String[] args) {
        String resultsFileName = "openmetadata.conformance.testlab.results";
        String defaultUserId = "ConformanceSuiteUser";
        if (args == null || args.length < 2) {
            System.out.println("Please specify the conformance suite OMAG server's name in the first parameter and its OMAG server platform's URL root in the second parameter");
            System.out.println("Optionally, the userId and password can be specified in the third and fourth parameter.");
            System.exit(-1);
        }
        String serverName = args[0];
        String serverURLRoot = args[1];
        String userId = "ConformanceSuiteUser";
        String password = null;
        if (args.length > 2) {
            userId = args[2];
        }
        if (args.length > 3) {
            password = args[3];
        }
        System.out.println("=======================================");
        System.out.println(" Open Metadata Conformance Test Report ");
        System.out.println("=======================================");
        System.out.println(" ... contacting conformance suite server: " + serverName + " (" + serverURLRoot + ")");
        System.out.println();
        OpenMetadataConformanceTestLabResults testLabResults = null;
        try {
            OpenMetadataConformanceTestReport testLab = password == null ? new OpenMetadataConformanceTestReport(serverName, serverURLRoot, userId) : new OpenMetadataConformanceTestReport(serverName, serverURLRoot, userId, password);
            testLabResults = testLab.getConformanceReport();
        }
        catch (RESTConfigurationException error) {
            System.out.println("Unable to issue calls to the conformance suite server " + serverName + " at " + serverURLRoot);
            System.out.println("Returned error message is " + error.getErrorMessage() + ".");
            System.out.println();
        }
        catch (InvalidParameterException error) {
            System.out.println("The server " + serverName + " is not a conformance suite server");
            System.out.println("Returned error message is " + error.getErrorMessage() + ".");
            System.out.println();
        }
        catch (PropertyServerException error) {
            System.out.println("The OMAG server platform at " + serverURLRoot + " is not contactable or the conformance suite server " + serverName + " has not been started.");
            System.out.println("Returned error message is " + error.getErrorMessage() + ".");
            System.out.println();
        }
        catch (UserNotAuthorizedException error) {
            System.out.println("The userId " + userId + " is not authorized to call the conformance suite tests.");
            System.out.println("Returned error message is " + error.getErrorMessage() + ".");
            System.out.println();
        }
        if (testLabResults == null) {
            System.out.println("No results are available");
            System.exit(-1);
        }
        try {
            File resultsStoreFile = new File("openmetadata.conformance.testlab.results");
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)testLabResults);
            FileUtils.writeStringToFile((File)resultsStoreFile, (String)jsonString, (String)null, (boolean)false);
        }
        catch (Throwable exc) {
            System.out.println("The OpenMetadataConformanceTestReport failed to process results " + exc.getMessage());
            System.exit(-1);
        }
        System.out.println("Conformance report from server:  " + serverName);
        System.out.println();
        System.out.println("Number of tests: " + testLabResults.getTestCaseCount());
        System.out.println("Number of tests passed: " + testLabResults.getTestPassCount());
        System.out.println("Number of tests failed: " + testLabResults.getTestFailedCount());
        System.out.println("Number of tests skipped: " + testLabResults.getTestSkippedCount());
        System.out.println();
        if (testLabResults.getTestCaseCount() == testLabResults.getTestPassCount()) {
            System.out.println("Congratulations, technology under test is conformant");
            System.exit(0);
        } else {
            System.out.println("Technology under test is not yet conformant");
            System.exit(1);
        }
    }
}

