/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel;

import com.github.jsonldjava.utils.JsonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.Attribute;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.Concept;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.ConceptGroup;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.Link;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.Model;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.Property;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.PropertyDescription;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.PropertyGroup;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.SubjectArea;

class CloudInformationModelParser {
    private static final String SUBJECT_AREA_FOLDER_NAME = "/subjectAreas";
    private static final String PROPERTY_GROUPS_FOLDER_NAME = "/propertyGroups";
    private static final String CONCEPTS_FILE_NAME = "/concepts.jsonld";
    private static final String SCHEMA_FILE_NAME = "/schema.jsonld";
    private static final String SUBJECT_AREA_DESC_FILE_NAME = "about.jsonld";
    private static final String AT_CONTEXT_TAG = "@context";
    private static final String AT_ID_TAG = "@id";
    private static final String AT_TYPE_TAG = "@type";
    private static final String NAME_TAG = "name";
    private static final String SUBJECT_AREAS_TAG = "subjectAreas";
    private static final String ENTITY_GROUPS_TAG = "entityGroups";
    private static final String PROPERTY_GROUPS_TAG = "propertyGroups";
    private static final String DESCRIPTION_TAG = "description";
    private static final String CLASS_CONCEPTS_TAG = "classConcepts";
    private static final String PROPERTY_CONCEPTS_TAG = "propertyConcepts";
    private static final String DOMAIN_TAG = "domain";
    private static final String RANGE_TAG = "range";
    private static final String SCHEMAS_TAG = "schemas";
    private static final String VERSION_TAG = "version";
    private static final String PROPERTIES_TAG = "properties";
    private static final String PATH_TAG = "path";
    private static final String NODE_TAG = "node";
    private static final String AND_TAG = "and";
    private static final String MAX_COUNT_TAG = "maxCount";
    private static final String MIN_COUNT_TAG = "minCount";
    private static final String DATA_TYPE_TAG = "datatype";
    private static final String SUB_CLASS_TAG = "subClassOf";
    private static final String ENTITY_GROUP_TYPE = "EntityGroup";
    private static final String CLASS_TYPE = "Class";
    private static final String MANAGED_PROPERTY_TYPE = "ManagedProperty";
    private static final String DATA_TYPE_RANGE = "DataType";
    private static final String modelName = "Cloud Information Model (CIM)";
    private static final String modelTechnicalName = "CloudInformationModel";
    private static final String modelDescription = "The Cloud Information Model (CIM) is an open source glossary and data model that spans the following subject areas:\n\n\u2022\tParty \u2013 people, their roles and organizations.\n\u2022\tProduct \u2013 product descriptions, structures and packaging.\n\u2022\tSales Order \u2013 customer orders for goods and services.\n\u2022\tPayment Method \u2013 payment methods including cards, coupons and digital wallets.\n\u2022\tPayment \u2013 individual payments for goods and services.\n\u2022\tShipment \u2013 shipment of goods and services to the customer to fulfil an order.\n\nThis means it can provide common data structures for new services spanning customer and employee interaction around typical commercial activities such as buying and selling of goods and services.\n\nThe motivation behind the cloud information model is to support organizations who are transforming their digital services to run on a variety of cloud platforms and with their own data centres.  Often, they are dealing with systems built on many different generations of technology, with data distributed amongst them.  The CIM provides a common language to describe the different types of data.\n\nThe CIM has been created to simplify the growing complexity companies experience when integrating data across different systemsin order to deliver highly intelligent and personalized customer engagements. It standardizes data interoperability by creating a set of guidelines to easily connect systems such as a point of sale system, email marketing platform, customer service center, customer relationship management (CRM) system and more. Developers will no longer need to spend months creating custom code in order to deliver innovative customer experiences. The CIM can be easily adopted and extended within days so that developers can focus on creating new innovations faster that deliver a truly connected, personalized and intelligent customer experience. \n";
    private static final String modelLocation = "http://cloudinformationmodel.org/";
    private static final String modelScope = "People, organizations, accounts and contact details, orders and payments.";
    private static final String modelLanguage = "En_US";
    private Map<String, SubjectArea> subjectAreaMap = new HashMap<String, SubjectArea>();
    private Map<String, PropertyGroup> propertyGroupMap = new HashMap<String, PropertyGroup>();
    private Map<String, Concept> conceptBeadMap = new HashMap<String, Concept>();
    private Map<String, PropertyDescription> propertyDescriptionMap = new HashMap<String, PropertyDescription>();
    private List<String> errorReport = new ArrayList<String>();

    CloudInformationModelParser(String cimLocation) throws IOException {
        try {
            System.out.println("\nModel Name: Cloud Information Model (CIM)");
            File cimContent = new File(cimLocation);
            if (cimContent.isDirectory()) {
                this.parseGitDirectory(cimLocation);
            } else {
                this.parseSingleFile(cimContent);
            }
            this.reviewConcepts();
            if (!this.conceptBeadMap.isEmpty()) {
                for (Concept concept : this.conceptBeadMap.values()) {
                    if (concept == null || concept.getDescription() != null && concept.getDisplayName() != null) continue;
                    this.errorReport.add("Missing bead: " + concept.getId());
                }
            }
            if (!this.errorReport.isEmpty()) {
                System.out.println("Error Report from parsing Source Model");
                System.out.println(this.errorReport);
            }
        }
        catch (Exception error) {
            System.out.println("error is " + error.toString());
        }
    }

    private void parseSingleFile(File cimContentFile) throws IOException {
        System.out.println("\nRetrieving model contents from: " + cimContentFile.getName());
        LinkedHashMap modelJsonLD = (LinkedHashMap)JsonUtils.fromInputStream((InputStream)new FileInputStream(cimContentFile));
        List propertyGroups = (List)modelJsonLD.get(PROPERTY_GROUPS_TAG);
        List subjectAreas = (List)modelJsonLD.get(SUBJECT_AREAS_TAG);
        if (propertyGroups != null) {
            for (Map propertyGroup : propertyGroups) {
                this.getPropertyGroup(propertyGroup);
            }
        }
        if (subjectAreas != null) {
            for (Map subjectAreaJsonLD : subjectAreas) {
                if (subjectAreaJsonLD == null) continue;
                SubjectArea subjectArea = new SubjectArea();
                subjectArea.setId(this.getStringValue(subjectAreaJsonLD.get(AT_ID_TAG)));
                subjectArea.setTechnicalName(this.getTechnicalName(subjectArea.getId(), this.getStringValue(subjectAreaJsonLD.get(AT_TYPE_TAG))));
                subjectArea.setDisplayName(this.getStringValue(subjectAreaJsonLD.get(NAME_TAG)));
                subjectArea.setDescription(this.getStringValue(subjectAreaJsonLD.get(DESCRIPTION_TAG)));
                String subjectAreaName = subjectArea.getDisplayName();
                System.out.println("Subject area name: " + subjectAreaName);
                this.subjectAreaMap.put(subjectAreaName, subjectArea);
                List entityGroupsJsonLD = (List)subjectAreaJsonLD.get(ENTITY_GROUPS_TAG);
                if (entityGroupsJsonLD == null) continue;
                for (Map entityGroupJsonLD : entityGroupsJsonLD) {
                    if (entityGroupJsonLD == null) continue;
                    String versionName = this.getStringValue(entityGroupJsonLD.get(VERSION_TAG));
                    ConceptGroup conceptGroup = new ConceptGroup();
                    conceptGroup.setId(this.getStringValue(entityGroupJsonLD.get(AT_ID_TAG)));
                    conceptGroup.setTechnicalName(this.getTechnicalName(conceptGroup.getId(), ENTITY_GROUP_TYPE));
                    conceptGroup.setDisplayName(this.getStringValue(entityGroupJsonLD.get(NAME_TAG)));
                    conceptGroup.setDescription(this.getStringValue(entityGroupJsonLD.get(DESCRIPTION_TAG)));
                    conceptGroup.setVersion(versionName);
                    String conceptGroupName = conceptGroup.getDisplayName();
                    System.out.println("  ==> Concept Group name: " + conceptGroupName);
                    subjectArea.addConceptGroup(conceptGroup.getId(), conceptGroup);
                    List classConceptsJsonLD = (List)entityGroupJsonLD.get(CLASS_CONCEPTS_TAG);
                    List propertyConceptsJsonLD = (List)entityGroupJsonLD.get(PROPERTY_CONCEPTS_TAG);
                    List schemasJsonLD = (List)entityGroupJsonLD.get(SCHEMAS_TAG);
                    this.getEntityGroup(subjectArea, conceptGroup, classConceptsJsonLD, propertyConceptsJsonLD, schemasJsonLD);
                }
            }
        }
    }

    private void parseGitDirectory(String cimDirectoryName) throws IOException {
        System.out.println("\nRetrieving model contents from: " + cimDirectoryName);
        this.getPropertyGroupsFromDirectory(cimDirectoryName);
        this.getSubjectAreasFromDirectory(cimDirectoryName);
    }

    private Concept getConcept(String conceptId) {
        Concept bead = this.conceptBeadMap.get(conceptId);
        if (bead == null) {
            bead = new Concept(conceptId);
            bead.setId(conceptId);
            this.conceptBeadMap.put(conceptId, bead);
        }
        return bead;
    }

    private String getTechnicalName(String sourceString, String objectType) {
        if (sourceString != null) {
            String[] splitString = sourceString.split(objectType, 2);
            return splitString[0];
        }
        return null;
    }

    private String getStringValue(Object modelElement) {
        if (modelElement == null) {
            return null;
        }
        return modelElement.toString();
    }

    private PropertyDescription getPropertyDescription(String propertyId, String rangeTag) {
        PropertyDescription propertyDescription = this.propertyDescriptionMap.get(propertyId);
        if (propertyDescription == null) {
            propertyDescription = new PropertyDescription();
            if (DATA_TYPE_RANGE.equals(rangeTag)) {
                propertyDescription.setPrimitive(true);
            } else {
                propertyDescription.setPrimitive(false);
                propertyDescription.setDataTypeId(rangeTag);
            }
            propertyDescription.setId(propertyId);
            this.propertyDescriptionMap.put(propertyId, propertyDescription);
        }
        return propertyDescription;
    }

    private PropertyDescription getPropertyDescription(String propertyId) {
        PropertyDescription propertyDescription = this.propertyDescriptionMap.get(propertyId);
        if (propertyDescription == null) {
            System.out.println("ERROR: missing property description: " + propertyId);
            this.errorReport.add("ERROR: missing property description: " + propertyId);
            propertyDescription = new PropertyDescription();
            propertyDescription.setId(propertyId);
            propertyDescription.setDisplayName(propertyId);
            this.propertyDescriptionMap.put(propertyId, propertyDescription);
        }
        return propertyDescription;
    }

    private void getPropertyGroupsFromDirectory(String rootDirectory) throws IOException {
        File[] propertyGroups;
        File propertyGroupsDirectory = new File(rootDirectory + PROPERTY_GROUPS_FOLDER_NAME);
        if (propertyGroupsDirectory.isDirectory() && (propertyGroups = propertyGroupsDirectory.listFiles()) != null) {
            for (File propertyGroup : propertyGroups) {
                this.getPropertyGroupFromDirectory(propertyGroup);
            }
        }
    }

    private void getPropertyGroupFromDirectory(File propertyGroupDirectory) throws IOException {
        if (propertyGroupDirectory.isDirectory()) {
            String propertyGroupDirectoryName = propertyGroupDirectory.toString();
            String propertyGroupName = propertyGroupDirectory.getName();
            System.out.println("Property group name: " + propertyGroupName);
            File conceptsJsonLDFile = new File(propertyGroupDirectoryName + CONCEPTS_FILE_NAME);
            LinkedHashMap conceptsJsonLD = (LinkedHashMap)JsonUtils.fromInputStream((InputStream)new FileInputStream(conceptsJsonLDFile));
            if (modelLocation.equals(this.getStringValue(conceptsJsonLD.get(AT_CONTEXT_TAG)))) {
                this.getPropertyGroup(conceptsJsonLD);
            }
        }
    }

    private void getPropertyGroup(Map<String, Object> conceptsJsonLD) throws IOException {
        String versionName = this.getStringValue(conceptsJsonLD.get(VERSION_TAG));
        PropertyGroup propertyGroup = new PropertyGroup();
        propertyGroup.setId(this.getStringValue(conceptsJsonLD.get(AT_ID_TAG)));
        propertyGroup.setDisplayName(this.getStringValue(conceptsJsonLD.get(NAME_TAG)));
        propertyGroup.setVersion(versionName);
        propertyGroup.setTechnicalName(this.getTechnicalName(propertyGroup.getId(), "PropertyGroup"));
        this.propertyGroupMap.put(propertyGroup.getTechnicalName(), propertyGroup);
        List propertyConcepts = (List)conceptsJsonLD.get(PROPERTY_CONCEPTS_TAG);
        if (propertyConcepts != null) {
            for (Map propertyDefinition : propertyConcepts) {
                if (propertyDefinition == null) continue;
                String propertyId = this.getStringValue(propertyDefinition.get(AT_ID_TAG));
                PropertyDescription propertyDescription = this.getPropertyDescription(propertyId, this.getStringValue(propertyDefinition.get(RANGE_TAG)));
                propertyDescription.setId(propertyId);
                propertyDescription.setTechnicalName(propertyId);
                propertyDescription.setDisplayName(this.getStringValue(propertyDefinition.get(NAME_TAG)));
                propertyDescription.setDescription(this.getStringValue(propertyDefinition.get(DESCRIPTION_TAG)));
                propertyDescription.setVersion(versionName);
                if (propertyDescription.isPrimitive()) {
                    System.out.println("==> Property name: " + propertyId + " is an attribute ");
                } else {
                    System.out.println("==> Property name: " + propertyId + " links to " + propertyDescription.getDataTypeId());
                }
                propertyGroup.addPropertyDescription(propertyId, propertyDescription);
                this.propertyDescriptionMap.put(propertyId, propertyDescription);
            }
        }
    }

    private void getSubjectAreasFromDirectory(String rootDirectory) throws IOException {
        File[] subjectAreas;
        File subjectAreasDirectory = new File(rootDirectory + SUBJECT_AREA_FOLDER_NAME);
        if (subjectAreasDirectory.isDirectory() && (subjectAreas = subjectAreasDirectory.listFiles()) != null) {
            for (File subjectArea : subjectAreas) {
                this.getSubjectAreaFromFile(subjectArea);
            }
        }
    }

    private void getSubjectAreaFromFile(File subjectAreaDirectory) throws IOException {
        if (subjectAreaDirectory.isDirectory()) {
            String subjectAreaName = subjectAreaDirectory.getName();
            System.out.println("Subject area name: " + subjectAreaName);
            SubjectArea subjectArea = new SubjectArea();
            File[] subjectAreaFiles = subjectAreaDirectory.listFiles();
            if (subjectAreaFiles != null) {
                for (File subjectAreaFile : subjectAreaFiles) {
                    if (subjectAreaFile == null) continue;
                    if (subjectAreaFile.isDirectory()) {
                        this.getEntityGroupFromFile(subjectArea, subjectAreaFile);
                        continue;
                    }
                    if (SUBJECT_AREA_DESC_FILE_NAME.equals(subjectAreaFile.getName())) {
                        LinkedHashMap aboutJsonLD = (LinkedHashMap)JsonUtils.fromInputStream((InputStream)new FileInputStream(subjectAreaFile));
                        subjectArea.setId(this.getStringValue(aboutJsonLD.get(AT_ID_TAG)));
                        subjectArea.setTechnicalName(this.getTechnicalName(subjectArea.getId(), this.getStringValue(aboutJsonLD.get(AT_TYPE_TAG))));
                        subjectArea.setDisplayName(this.getStringValue(aboutJsonLD.get(NAME_TAG)));
                        subjectArea.setDescription(this.getStringValue(aboutJsonLD.get(DESCRIPTION_TAG)));
                        this.subjectAreaMap.put(subjectAreaName, subjectArea);
                        continue;
                    }
                    if (subjectAreaFile.getName().endsWith(".png")) continue;
                    System.out.println("WARNING skipping file named: " + subjectAreaFile.getName());
                    this.errorReport.add("WARNING skipping file named: " + subjectAreaFile.getName());
                }
            }
        }
    }

    private void getEntityGroup(SubjectArea subjectArea, ConceptGroup conceptGroup, List<Map<String, Object>> classConcepts, List<Map<String, Object>> propertyConcepts, List<Map<String, Object>> schemas) {
        if (classConcepts != null) {
            for (Map<String, Object> conceptProperties : classConcepts) {
                if (conceptProperties == null) continue;
                this.getConceptsForEntityGroup(subjectArea, conceptGroup, conceptProperties);
            }
        }
        if (propertyConcepts != null) {
            for (Map<String, Object> propertyProperties : propertyConcepts) {
                if (propertyProperties == null) continue;
                this.getPropertiesForEntityGroup(propertyProperties);
            }
        }
        if (schemas != null) {
            for (Map<String, Object> schemaProperties : schemas) {
                if (schemaProperties == null) continue;
                this.getSchemaPropertiesForEntityGroup(schemaProperties);
            }
        }
    }

    private void getConceptsForEntityGroup(SubjectArea subjectArea, ConceptGroup conceptGroup, Map<String, Object> conceptProperties) {
        if (conceptProperties != null) {
            String conceptId = this.getStringValue(conceptProperties.get(AT_ID_TAG));
            if (conceptId != null) {
                Concept concept = this.getConcept(conceptId);
                concept.setId(conceptId);
                concept.setTechnicalName(conceptId);
                concept.setDisplayName(this.getStringValue(conceptProperties.get(NAME_TAG)));
                concept.setDescription(this.getStringValue(conceptProperties.get(DESCRIPTION_TAG)));
                concept.setVersion(subjectArea.getVersion());
                Object conceptPropertiesType = conceptProperties.get(AT_TYPE_TAG);
                if (conceptPropertiesType == null) {
                    concept.setReferenceDataSet(false);
                } else {
                    concept.setReferenceDataSet(this.getStringValue(conceptProperties.get(AT_TYPE_TAG)).contains(MANAGED_PROPERTY_TYPE));
                }
                Object superClassName = conceptProperties.get(SUB_CLASS_TAG);
                if (superClassName != null) {
                    Concept superClass = this.getConcept(superClassName.toString());
                    superClass.addSubClass(conceptId, conceptId);
                    concept.setSuperClassId(superClass.getId());
                    System.out.println("     ==> Concept Bead name: " + conceptId + " is ref data " + concept.isReferenceDataSet() + " and has superclass " + superClassName);
                } else {
                    System.out.println("     ==> Concept Bead name: " + conceptId + " is ref data " + concept.isReferenceDataSet());
                }
                conceptGroup.addConcept(conceptId, concept);
            } else {
                System.out.println("ERROR: no id for concept properties: " + conceptProperties.toString());
                this.errorReport.add("ERROR: no id for concept properties: " + conceptProperties.toString());
            }
        }
    }

    private void getPropertiesForEntityGroup(Map<String, Object> propertyProperties) {
        String propertyId = this.getStringValue(propertyProperties.get(AT_ID_TAG));
        PropertyDescription propertyDescription = this.getPropertyDescription(propertyId);
        Object domainNamesObject = propertyProperties.get(DOMAIN_TAG);
        ArrayList domainNames = new ArrayList((List)domainNamesObject);
        if (!domainNames.isEmpty()) {
            for (String domainName : domainNames) {
                if (domainName == null) continue;
                Concept concept = this.getConcept(domainName);
                if (propertyDescription.isPrimitive()) {
                    concept.setAttribute(propertyId, new Attribute(propertyDescription));
                    System.out.println("       ==> Property name: " + propertyId + " is attribute");
                    continue;
                }
                Link link = new Link(propertyDescription);
                link.setDomainConceptId(concept.getId());
                concept.setDomainOfLink(propertyId, link);
                System.out.println("       ==> Property name: " + propertyId + " is link from " + link.getDomainConceptId() + " to " + link.getRangeConceptId());
                if (propertyDescription.getDataTypeId() != null) {
                    Concept rangeConcept = this.getConcept(propertyDescription.getDataTypeId());
                    rangeConcept.setRangeOfLink(link.getRangeConceptId(), link);
                    continue;
                }
                System.out.println("ERROR: no range for property name: " + propertyId);
                this.errorReport.add("ERROR: no range for property name: " + propertyId);
            }
        } else {
            System.out.println("ERROR: no domains for property name: " + propertyId);
            this.errorReport.add("ERROR: no domains for property name: " + propertyId);
        }
    }

    private void getSchemaPropertiesForEntityGroup(Map<String, Object> schemaProperties) {
        try {
            String conceptId = this.getStringValue(schemaProperties.get(AT_ID_TAG));
            if (conceptId != null) {
                Concept concept = this.getConcept(conceptId);
                List inheritedProperties = (List)schemaProperties.get(AND_TAG);
                if (inheritedProperties == null) {
                    this.getPropertySchemas(concept, null, (List)schemaProperties.get(PROPERTIES_TAG));
                } else {
                    List properties = null;
                    String superClassId = null;
                    for (Map optionValues : inheritedProperties) {
                        if (optionValues.get(PROPERTIES_TAG) != null) {
                            properties = (List)optionValues.get(PROPERTIES_TAG);
                            continue;
                        }
                        if (optionValues.get(AT_ID_TAG) != null) {
                            superClassId = this.getStringValue(optionValues.get(AT_ID_TAG));
                            continue;
                        }
                        System.out.println("ERROR: no recognised options for concept: " + conceptId);
                        this.errorReport.add("ERROR: no recognised options for concept: " + conceptId);
                    }
                    this.getPropertySchemas(concept, superClassId, properties);
                }
            } else {
                System.out.println("ERROR: no id for concept" + schemaProperties.toString());
                this.errorReport.add("ERROR: no id for concept" + schemaProperties.toString());
            }
        }
        catch (Exception error) {
            System.out.println("error is " + error.toString());
        }
    }

    private void getEntityGroupFromFile(SubjectArea subjectArea, File entityGroupDirectory) throws IOException {
        if (entityGroupDirectory.isDirectory()) {
            File schemaJsonLDFile;
            LinkedHashMap schemaJsonLD;
            String entityGroupDirectoryName = entityGroupDirectory.toString();
            String entityGroupName = entityGroupDirectory.getName();
            System.out.println("==> Entity Group name: " + entityGroupName);
            File conceptsJsonLDFile = new File(entityGroupDirectoryName + CONCEPTS_FILE_NAME);
            ConceptGroup conceptGroup = new ConceptGroup();
            List classConcepts = null;
            List propertyConcepts = null;
            List schemas = null;
            LinkedHashMap conceptsJsonLD = (LinkedHashMap)JsonUtils.fromInputStream((InputStream)new FileInputStream(conceptsJsonLDFile));
            if (ENTITY_GROUP_TYPE.equals(this.getStringValue(conceptsJsonLD.get(AT_TYPE_TAG))) && modelLocation.equals(this.getStringValue(conceptsJsonLD.get(AT_CONTEXT_TAG)))) {
                String versionName = this.getStringValue(conceptsJsonLD.get(VERSION_TAG));
                conceptGroup.setId(this.getStringValue(conceptsJsonLD.get(AT_ID_TAG)));
                conceptGroup.setTechnicalName(this.getTechnicalName(conceptGroup.getId(), ENTITY_GROUP_TYPE));
                conceptGroup.setDisplayName(this.getStringValue(conceptsJsonLD.get(NAME_TAG)));
                conceptGroup.setDescription(this.getStringValue(conceptsJsonLD.get(DESCRIPTION_TAG)));
                conceptGroup.setVersion(versionName);
                subjectArea.addConceptGroup(conceptGroup.getId(), conceptGroup);
                classConcepts = (List)conceptsJsonLD.get(CLASS_CONCEPTS_TAG);
                propertyConcepts = (List)conceptsJsonLD.get(PROPERTY_CONCEPTS_TAG);
            }
            if (modelLocation.equals(this.getStringValue((schemaJsonLD = (LinkedHashMap)JsonUtils.fromInputStream((InputStream)new FileInputStream(schemaJsonLDFile = new File(entityGroupDirectoryName + SCHEMA_FILE_NAME)))).get(AT_CONTEXT_TAG))) && ENTITY_GROUP_TYPE.equals(this.getStringValue(schemaJsonLD.get(AT_TYPE_TAG))) && entityGroupName.equals(this.getStringValue(schemaJsonLD.get(AT_ID_TAG)))) {
                schemas = (List)schemaJsonLD.get(SCHEMAS_TAG);
            }
            this.getEntityGroup(subjectArea, conceptGroup, classConcepts, propertyConcepts, schemas);
        }
    }

    private void reviewConcepts() {
        for (Concept concept : this.conceptBeadMap.values()) {
            if (concept == null) continue;
            if (concept.getRangeOfLinks() == null) {
                List<Link> domainOfLinks = concept.getDomainOfLinks();
                if (domainOfLinks != null) {
                    if (domainOfLinks.size() == 2) {
                        concept.setRelationship(true);
                        System.out.println("Concept: " + concept.getId() + " is a relationship linking two concepts: " + domainOfLinks.get(0).getId() + " and " + domainOfLinks.get(1).getId());
                        continue;
                    }
                    System.out.println("Concept: " + concept.getId() + " is a master-detail record");
                    continue;
                }
                System.out.println("Concept: " + concept.getId() + " is isolated - it is not linked to anything");
                continue;
            }
            System.out.println("Concept: " + concept.getId() + " is linked to by other concepts");
        }
    }

    private void getPropertySchemas(Concept concept, String superClassId, List<Map<String, Object>> propertiesSchema) {
        ArrayList<String> superClassPropertyNames = new ArrayList<String>();
        if (superClassId != null) {
            Concept superClass = this.getConcept(superClassId);
            List<String> propertyNames = superClass.getAttributeNames();
            if (propertyNames != null) {
                superClassPropertyNames.addAll(propertyNames);
            }
            if ((propertyNames = superClass.getDomainOfLinkNames()) != null) {
                superClassPropertyNames.addAll(propertyNames);
            }
            if ((propertyNames = superClass.getRangeOfLinkNames()) != null) {
                superClassPropertyNames.addAll(propertyNames);
            }
        }
        if (propertiesSchema != null) {
            for (Map<String, Object> propertyProperties : propertiesSchema) {
                Property property;
                if (propertyProperties == null) continue;
                String propertyId = this.getStringValue(propertyProperties.get(PATH_TAG));
                PropertyDescription propertyDescription = this.getPropertyDescription(propertyId);
                String node = this.getStringValue(propertyProperties.get(NODE_TAG));
                String dataType = this.getStringValue(propertyProperties.get(DATA_TYPE_TAG));
                String minCount = this.getStringValue(propertyProperties.get(MIN_COUNT_TAG));
                String maxCount = this.getStringValue(propertyProperties.get(MAX_COUNT_TAG));
                if (superClassPropertyNames.contains(propertyId)) {
                    System.out.println("WARN: Skipping superclass property: " + propertyId);
                    continue;
                }
                if (propertyDescription.isPrimitive()) {
                    Attribute attribute;
                    if (node != null) {
                        System.out.println("ERROR: Node: " + node + " specified for: " + propertyId + " in concept: " + concept.getId());
                        this.errorReport.add("ERROR: Node: " + node + " specified for: " + propertyId + " in concept: " + concept.getId());
                    }
                    if (dataType == null) {
                        System.out.println("ERROR: No datatype specified for: " + propertyId + " in concept: " + concept.getId());
                        this.errorReport.add("ERROR: No datatype specified for: " + propertyId + " in concept: " + concept.getId());
                    }
                    if ((attribute = concept.getAttribute(propertyId)) == null) {
                        System.out.println("ERROR: Attribute: " + propertyId + " not known to concept: " + concept.getId());
                        this.errorReport.add("ERROR: Attribute: " + propertyId + " not known to concept: " + concept.getId());
                        concept.setAttribute(propertyId, new Attribute(propertyDescription));
                        attribute = concept.getAttribute(propertyId);
                    }
                    attribute.setDataType(this.getStringValue(propertyProperties.get(DATA_TYPE_TAG)));
                    if (attribute.getDataType() == null) {
                        System.out.println("ERROR: No data type for: " + propertyId + " in concept: " + concept.getId());
                        this.errorReport.add("ERROR: No data type for: " + propertyId + " in concept: " + concept.getId());
                    }
                    property = attribute;
                } else {
                    Link link;
                    if (dataType != null) {
                        System.out.println("ERROR: Datatype: " + dataType + " specified for: " + propertyId + " in concept: " + concept.getId());
                        this.errorReport.add("ERROR: Datatype: " + dataType + " specified for: " + propertyId + " in concept: " + concept.getId());
                    }
                    if (node == null) {
                        System.out.println("ERROR: No node specified for: " + propertyId + " in concept: " + concept.getId());
                        this.errorReport.add("ERROR: No node specified for: " + propertyId + " in concept: " + concept.getId());
                    }
                    if ((link = concept.getDomainLink(propertyId)) == null) {
                        System.out.println("WARN: Link: " + propertyId + " not in domain of concept: " + concept.getId());
                        this.errorReport.add("WARN: Link: " + propertyId + " not in domain of concept: " + concept.getId());
                        link = concept.getRangeLink(propertyId);
                        if (link == null) {
                            System.out.println("ERROR: Link: " + propertyId + " not known to concept: " + concept.getId());
                            this.errorReport.add("ERROR: Link: " + propertyId + " not known to concept: " + concept.getId());
                            concept.setDomainOfLink(propertyId, new Link(propertyDescription));
                        }
                    }
                    property = link;
                }
                if (property != null) {
                    if (maxCount == null) {
                        property.setSingleton(true);
                    } else {
                        property.setSingleton(false);
                    }
                    if (minCount == null) {
                        property.setOptional(true);
                        continue;
                    }
                    property.setOptional(false);
                    continue;
                }
                System.out.println("ERROR: Skipping property because content is invalid: " + propertyId);
                this.errorReport.add("ERROR: Skipping property because content is invalid: " + propertyId);
            }
        }
    }

    public Model getModel() {
        Model model = new Model();
        model.setModelName(modelName);
        model.setModelTechnicalName(modelTechnicalName);
        model.setModelDescription(modelDescription);
        model.setModelLocation(modelLocation);
        model.setModelScope(modelScope);
        model.setModelLanguage(modelLanguage);
        model.setSubjectAreaMap(this.subjectAreaMap);
        model.setPropertyGroupMap(this.propertyGroupMap);
        model.setPropertyDescriptionMap(this.propertyDescriptionMap);
        model.setConceptBeadMap(this.conceptBeadMap);
        model.setErrorReport(this.errorReport);
        return model;
    }
}

