/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.archiveutilities.catalogbuilder.CatalogTypesArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.CloudInformationModelParser;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.Concept;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.ConceptGroup;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.Model;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.PropertyDescription;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.PropertyGroup;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.SubjectArea;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;

class CloudInformationModelArchiveBuilder
extends CatalogTypesArchiveBuilder {
    private static final String archiveGUID = "9dc75637-92a7-4926-b47b-a3d407546f89";
    private static final String archiveRootName = "CloudInformationModel";
    private static final String archiveName = "Cloud Information Model (CIM) glossary and concept model";
    private static final String archiveLicense = "Apache 2.0";
    private static final String archiveDescription = "Data types for commerce focused cloud applications.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "The Cloud Information Model";
    private static final Date creationDate = new Date(1570383385107L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private CloudInformationModelParser parser;

    CloudInformationModelArchiveBuilder(CloudInformationModelParser parser) {
        super(archiveGUID, archiveName, archiveDescription, archiveType, archiveRootName, originatorName, archiveLicense, creationDate, 1L, versionName, null);
        this.parser = parser;
    }

    protected OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.parser != null) {
            Model model = this.parser.getModel();
            String glossaryId = super.addGlossary("Glossary-" + model.getModelTechnicalName(), model.getModelName(), model.getModelDescription(), model.getModelLanguage(), archiveDescription, model.getModelLocation(), model.getModelScope());
            String cimModelCategoryId = super.addCategory(glossaryId, "ModelVocabulary-" + model.getModelTechnicalName(), "Model Vocabulary: " + model.getModelName(), model.getModelDescription(), null);
            super.addMoreInformationLink(glossaryId, cimModelCategoryId);
            String modelTermId = super.addTerm(glossaryId, null, "GlossaryDescription-" + model.getModelTechnicalName(), model.getModelName(), model.getModelDescription());
            super.addMoreInformationLink(modelTermId, cimModelCategoryId);
            String propertyGroupsCategoryId = super.addCategory(glossaryId, "PropertyGroups-" + model.getModelTechnicalName(), "Property Groups for the " + model.getModelName(), "Collections of properties found in the CIM Model.", null);
            super.addCategoryToCategory(cimModelCategoryId, propertyGroupsCategoryId);
            Map<String, PropertyGroup> propertyGroupMap = model.getPropertyGroupMap();
            if (propertyGroupMap != null) {
                for (PropertyGroup propertyGroup : propertyGroupMap.values()) {
                    String propertyGroupCategoryId = super.addCategory(glossaryId, propertyGroup.getId(), propertyGroup.getDisplayName(), propertyGroup.getDescription(), null);
                    super.addCategoryToCategory(propertyGroupsCategoryId, propertyGroupCategoryId);
                    ArrayList<String> categoryList = new ArrayList<String>();
                    categoryList.add(propertyGroupCategoryId);
                    List<PropertyDescription> propertyDescriptions = propertyGroup.getPropertyDescriptions();
                    if (propertyDescriptions == null) continue;
                    for (PropertyDescription propertyDescription : propertyDescriptions) {
                        if (propertyDescription == null) continue;
                        String string = super.addTerm(glossaryId, categoryList, propertyGroup.getId() + "-" + propertyDescription.getId(), propertyDescription.getDisplayName(), propertyDescription.getDescription());
                    }
                }
            }
            String subjectAreasCategoryId = super.addCategory(glossaryId, "ModelSubjectAreas-" + model.getModelTechnicalName(), "Subject Areas for the " + model.getModelName() + " model", "Collections of related concepts (entities and relationships) found in the CIM Model that describe an area of interest.", null);
            super.addCategoryToCategory(cimModelCategoryId, subjectAreasCategoryId);
            Map<String, SubjectArea> subjectAreaMap = model.getSubjectAreaMap();
            if (subjectAreaMap != null) {
                for (SubjectArea subjectArea : subjectAreaMap.values()) {
                    String subjectAreaCategoryId = super.addCategory(glossaryId, subjectArea.getId(), subjectArea.getDisplayName(), subjectArea.getDescription(), subjectArea.getDisplayName());
                    super.addCategoryToCategory(subjectAreasCategoryId, subjectAreaCategoryId);
                    String subjectAreaTermId = super.addTerm(glossaryId, null, "ModelSubjectArea-" + model.getModelTechnicalName() + "-" + subjectArea.getId(), subjectArea.getDisplayName(), subjectArea.getDescription());
                    super.addMoreInformationLink(subjectAreaTermId, subjectAreaCategoryId);
                    Map<String, ConceptGroup> conceptGroupMap = subjectArea.getConceptGroups();
                    if (conceptGroupMap == null) continue;
                    for (ConceptGroup conceptGroup : conceptGroupMap.values()) {
                        if (conceptGroup == null) continue;
                        String conceptGroupCategoryId = super.addCategory(glossaryId, conceptGroup.getId(), conceptGroup.getDisplayName(), conceptGroup.getDescription(), conceptGroup.getDisplayName());
                        super.addCategoryToCategory(subjectAreaCategoryId, conceptGroupCategoryId);
                        String conceptGroupTermId = super.addTerm(glossaryId, null, "ModelConceptGroup-" + model.getModelTechnicalName() + "-" + subjectArea.getId() + "-" + conceptGroup.getId(), conceptGroup.getDisplayName(), conceptGroup.getDescription());
                        super.addMoreInformationLink(conceptGroupTermId, conceptGroupCategoryId);
                        ArrayList<String> categoryList = new ArrayList<String>();
                        categoryList.add(conceptGroupCategoryId);
                        List<Concept> concepts = conceptGroup.getConcepts();
                        if (concepts == null) continue;
                        for (Concept concept : concepts) {
                            if (concept == null) continue;
                            String string = super.addTerm(glossaryId, categoryList, subjectArea.getTechnicalName() + "::" + concept.getId(), concept.getDisplayName(), concept.getDescription());
                        }
                    }
                }
            }
            return super.getOpenMetadataArchive();
        }
        super.logBadArchiveContent("getOpenMetadataArchive");
        return null;
    }
}

