/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel;

import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.CloudInformationModelArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.CloudInformationModelParser;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;

public class CloudInformationModelArchiveWriter
extends OMRSArchiveWriter {
    static final String defaultOpenMetadataArchiveFileName = "CloudInformationModel.json";
    private String cimModelLocation;

    CloudInformationModelArchiveWriter(String cimModelLocation) {
        this.cimModelLocation = cimModelLocation;
    }

    void writeOpenMetadataArchive() {
        try {
            CloudInformationModelParser cloudInformationModelParser = new CloudInformationModelParser(this.cimModelLocation);
            CloudInformationModelArchiveBuilder cloudInformationModelArchiveBuilder = new CloudInformationModelArchiveBuilder(cloudInformationModelParser);
            super.writeOpenMetadataArchive(defaultOpenMetadataArchiveFileName, cloudInformationModelArchiveBuilder.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + error.toString());
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("USAGE: filename");
            System.exit(-1);
        }
        try {
            CloudInformationModelArchiveWriter archiveWriter = new CloudInformationModelArchiveWriter(args[0]);
            archiveWriter.writeOpenMetadataArchive();
        }
        catch (Exception error) {
            System.err.println("Exception: " + error.toString());
            System.exit(-1);
        }
    }
}

