/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.Attribute;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.Link;
import org.odpi.openmetadata.archiveutilities.designmodels.cloudinformationmodel.properties.ModelElement;

public class Concept
extends ModelElement {
    private boolean referenceDataSet = false;
    private boolean relationship = false;
    private String superClassId = null;
    private Map<String, String> subClasses = new HashMap<String, String>();
    private Map<String, Link> domainOfLinks = new HashMap<String, Link>();
    private Map<String, Link> rangeOfLinks = new HashMap<String, Link>();
    private Map<String, Attribute> attributes = new HashMap<String, Attribute>();

    public Concept(String id) {
        super.setId(id);
    }

    public boolean isReferenceDataSet() {
        return this.referenceDataSet;
    }

    public void setReferenceDataSet(boolean referenceDataSet) {
        this.referenceDataSet = referenceDataSet;
    }

    public boolean isRelationship() {
        return this.relationship;
    }

    public void setRelationship(boolean relationship) {
        this.relationship = relationship;
    }

    public void addSubClass(String id, String subClassId) {
        this.subClasses.put(id, subClassId);
    }

    public List<String> getSubClasses() {
        if (this.subClasses.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.subClasses.values());
    }

    public String getSuperClassId() {
        return this.superClassId;
    }

    public void setSuperClassId(String superClassId) {
        this.superClassId = superClassId;
    }

    public void setDomainOfLink(String linkId, Link link) {
        this.domainOfLinks.put(linkId, link);
    }

    public Link getDomainLink(String linkId) {
        if (this.domainOfLinks.isEmpty()) {
            return null;
        }
        return this.domainOfLinks.get(linkId);
    }

    public List<Link> getDomainOfLinks() {
        if (this.domainOfLinks.isEmpty()) {
            return null;
        }
        return new ArrayList<Link>(this.domainOfLinks.values());
    }

    public List<String> getDomainOfLinkNames() {
        if (this.domainOfLinks.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.domainOfLinks.keySet());
    }

    public void setRangeOfLink(String linkId, Link link) {
        this.rangeOfLinks.put(linkId, link);
    }

    public List<Link> getRangeOfLinks() {
        if (this.rangeOfLinks.isEmpty()) {
            return null;
        }
        return new ArrayList<Link>(this.rangeOfLinks.values());
    }

    public List<String> getRangeOfLinkNames() {
        if (this.rangeOfLinks.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.rangeOfLinks.keySet());
    }

    public Link getRangeLink(String linkId) {
        if (this.rangeOfLinks.isEmpty()) {
            return null;
        }
        return this.rangeOfLinks.get(linkId);
    }

    public void setAttribute(String attributeId, Attribute attribute) {
        this.attributes.put(attributeId, attribute);
    }

    public Attribute getAttribute(String attributeId) {
        if (this.attributes.isEmpty()) {
            return null;
        }
        return this.attributes.get(attributeId);
    }

    public List<String> getAttributeNames() {
        if (this.attributes.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.attributes.keySet());
    }

    public List<Attribute> getAttributes() {
        if (this.attributes.isEmpty()) {
            return null;
        }
        return new ArrayList<Attribute>(this.attributes.values());
    }
}

