/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfxsltrunner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.odftoolkit.odfxsltrunner.Logger;
import org.odftoolkit.odfxsltrunner.ODFEntityResolver;
import org.odftoolkit.odfxsltrunner.ODFURIResolver;
import org.odftoolkit.odfxsltrunner.SAXErrorHandler;
import org.odftoolkit.odfxsltrunner.TransformerErrorListener;
import org.odftoolkit.odfxsltrunner.XSLTParameter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ODFXSLTRunner {
    public static final int INPUT_MODE_FILE = 0;
    public static final int INPUT_MODE_PACKAGE = 1;
    public static final int OUTPUT_MODE_FILE = 0;
    public static final int OUTPUT_MODE_STDOUT = 1;
    public static final int OUTPUT_MODE_REPLACE_INPUT_PACKAGE = 2;
    public static final int OUTPUT_MODE_COPY_INPUT_PACKAGE = 3;
    public static final int OUTPUT_MODE_TEMPLATE_PACKAGE = 4;
    private static final int FILE_COPY_BUFFER_SIZE = 4096;

    public boolean runXSLT(String aStyleSheet, List<XSLTParameter> aParams, String aInputFile, int aInputMode, String aOutputFile, int aOutputMode, String aPathInPackage, String aTransformerFactoryClassName, List<String> aExtractFileNames, Logger aLogger) {
        return this.runXSLT(new File(aStyleSheet), aParams, new File(aInputFile), aInputMode, aOutputFile != null ? new File(aOutputFile) : null, aOutputMode, aPathInPackage, aTransformerFactoryClassName, aExtractFileNames, aLogger);
    }

    public boolean runXSLT(File aStyleSheetFile, List<XSLTParameter> aParams, File aInputFile, int aInputMode, File aOutputFile, int aOutputMode, String aPathInPackage, String aTransformerFactoryClassName, List<String> aExtractFileNames, Logger aLogger) {
        File aOutputDir;
        boolean bError = false;
        ODFURIResolver aURIResolver = null;
        InputSource aInputSource = null;
        OdfPackage aInputPkg = null;
        String aMediaType = "text/xml";
        aLogger.setName(aInputFile.getAbsolutePath());
        try {
            if (0 == aInputMode) {
                aInputSource = new InputSource(new FileInputStream(aInputFile));
            } else {
                aInputPkg = OdfPackage.loadPackage((File)aInputFile);
                aLogger.setName(aInputFile.getAbsolutePath(), aPathInPackage);
                aInputSource = new InputSource(aInputPkg.getInputStream(aPathInPackage));
                aInputSource.setSystemId(aInputFile.toURI().toString() + "/" + aPathInPackage);
                OdfFileEntry aFileEntry = aInputPkg.getFileEntry(aPathInPackage);
                if (aFileEntry != null) {
                    aMediaType = aFileEntry.getMediaTypeString();
                }
                aURIResolver = new ODFURIResolver(aInputPkg, aInputFile.toURI().toString(), aPathInPackage, aLogger);
            }
        }
        catch (Exception e) {
            aLogger.logFatalError(e.getMessage());
            return true;
        }
        String aInputName = aLogger.getName();
        StreamResult aOutputResult = null;
        OdfPackage aOutputPkg = null;
        OutputStream aOutputStream = null;
        aLogger.setName(aOutputFile != null ? aOutputFile.getAbsolutePath() : "(none)");
        boolean bMkOutputDirs = false;
        try {
            switch (aOutputMode) {
                case 0: {
                    bMkOutputDirs = true;
                    aOutputResult = new StreamResult(aOutputFile);
                    break;
                }
                case 1: {
                    aOutputResult = new StreamResult(System.out);
                    break;
                }
                case 2: {
                    aOutputPkg = aInputPkg;
                    aOutputFile = aInputFile;
                    break;
                }
                case 3: {
                    bMkOutputDirs = true;
                    aOutputPkg = aInputPkg;
                    break;
                }
                case 4: {
                    aOutputPkg = OdfPackage.loadPackage((File)aOutputFile);
                }
            }
            if (aOutputResult == null) {
                aLogger.setName(aOutputFile.getAbsolutePath(), aPathInPackage);
                aOutputStream = aOutputPkg.insertOutputStream(aPathInPackage, aMediaType);
                aOutputResult = new StreamResult(aOutputStream);
            }
        }
        catch (Exception e) {
            aLogger.logFatalError(e.getMessage());
            return true;
        }
        if (bMkOutputDirs && (aOutputDir = aOutputFile.getParentFile()) != null) {
            aOutputDir.mkdirs();
        }
        String aOutputName = aLogger.getName();
        aLogger.setName(aStyleSheetFile.getAbsolutePath());
        aLogger.logInfo("Applying stylesheet to '" + aInputName + "'");
        bError = this.runXSLT(aStyleSheetFile, aParams, aInputSource, aOutputResult, aTransformerFactoryClassName, aURIResolver, aLogger);
        if (bError) {
            return true;
        }
        aLogger.setName(aOutputFile != null ? aOutputFile.getAbsolutePath() : "(none)");
        try {
            aLogger.logInfo("Storing transformation result to '" + aOutputName + "'");
            if (!bError && aOutputStream != null) {
                aOutputStream.close();
            }
            if (!bError && aOutputPkg != null) {
                aOutputPkg.save(aOutputFile);
            }
            if (aOutputMode == 0 && aExtractFileNames != null && aInputPkg != null) {
                File aTargetDir = aOutputFile.getParentFile();
                this.extractFiles(aInputPkg, aTargetDir, aExtractFileNames, aLogger);
            }
        }
        catch (Exception e) {
            aLogger.logFatalError(e.getMessage());
            return true;
        }
        return false;
    }

    private boolean runXSLT(File aStyleSheetFile, List<XSLTParameter> aParams, InputSource aInputInputSource, Result aOutputTarget, String aTransformerFactoryClassName, URIResolver aURIResolver, Logger aLogger) {
        FileInputStream aStyleSheetInputStream = null;
        try {
            aStyleSheetInputStream = new FileInputStream(aStyleSheetFile);
        }
        catch (FileNotFoundException e) {
            aLogger.logFatalError(e.getMessage());
            return true;
        }
        InputSource aStyleSheetInputSource = new InputSource(aStyleSheetInputStream);
        aStyleSheetInputSource.setSystemId(aStyleSheetFile.getAbsolutePath());
        XMLReader aStyleSheetXMLReader = null;
        XMLReader aInputXMLReader = null;
        try {
            aStyleSheetXMLReader = XMLReaderFactory.createXMLReader();
            aInputXMLReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            aLogger.logFatalError(e.getMessage());
            return true;
        }
        aStyleSheetXMLReader.setErrorHandler(new SAXErrorHandler(aLogger));
        aInputXMLReader.setErrorHandler(new SAXErrorHandler(aLogger));
        aInputXMLReader.setEntityResolver(new ODFEntityResolver(aLogger));
        SAXSource aStyleSheetSource = new SAXSource(aStyleSheetXMLReader, aStyleSheetInputSource);
        SAXSource aInputSource = new SAXSource(aInputXMLReader, aInputInputSource);
        if (aTransformerFactoryClassName != null) {
            aLogger.logInfo("Requesting transformer factory class: " + aTransformerFactoryClassName);
        }
        TransformerFactory aFactory = null;
        if (aTransformerFactoryClassName == null) {
            aFactory = TransformerFactory.newInstance();
        } else {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                Class<?> classInstance = cl.loadClass(aTransformerFactoryClassName);
                aFactory = (TransformerFactory)classInstance.newInstance();
            }
            catch (ClassNotFoundException ce) {
                aLogger.logFatalError(ce.getMessage());
                return true;
            }
            catch (InstantiationException ie) {
                aLogger.logFatalError(ie.getMessage());
                return true;
            }
            catch (IllegalAccessException ile) {
                aLogger.logFatalError(ile.getMessage());
                return true;
            }
        }
        TransformerErrorListener aErrorListener = new TransformerErrorListener(aLogger);
        aLogger.logInfo("Using transformer factory class: " + aFactory.getClass().getName());
        aFactory.setErrorListener(aErrorListener);
        try {
            Transformer aTransformer = aFactory.newTransformer(aStyleSheetSource);
            if (aParams != null) {
                for (XSLTParameter aParam : aParams) {
                    aTransformer.setParameter(aParam.getName(), aParam.getValue());
                    aLogger.logInfo("Using parameter: " + aParam.getName() + "=" + aParam.getValue());
                }
            }
            aTransformer.setErrorListener(aErrorListener);
            if (aURIResolver != null) {
                aTransformer.setURIResolver(aURIResolver);
            }
            aTransformer.transform(aInputSource, aOutputTarget);
        }
        catch (TransformerException e) {
            aLogger.logFatalError(e);
            return true;
        }
        return false;
    }

    private boolean extractFiles(OdfPackage aInputPkg, File aTargetDir, List<String> aExtractFileNames, Logger aLogger) {
        Set aInputPkgEntries = aInputPkg.getFilePaths();
        block2: for (String aInputFileName : aInputPkgEntries) {
            for (String aExtractFileName : aExtractFileNames) {
                if (aInputFileName.endsWith("/") || !aInputFileName.equals(aExtractFileName) && !(aExtractFileName.endsWith("/") ? aInputFileName.startsWith(aExtractFileName) : aInputFileName.startsWith(aExtractFileName + "/"))) continue;
                try {
                    File aTargetFile = new File(aTargetDir, aInputFileName);
                    File aTargetFileDir = aTargetFile.getParentFile();
                    if (aTargetFileDir != null) {
                        aTargetFileDir.mkdirs();
                    }
                    aLogger.logInfo("Extracting file " + aInputFileName + " to " + aTargetFile.getAbsolutePath());
                    InputStream aInputStream = aInputPkg.getInputStream(aInputFileName);
                    FileOutputStream aTargetStream = new FileOutputStream(aTargetFile);
                    byte[] aBuffer = new byte[4096];
                    int n = 0;
                    while ((n = aInputStream.read(aBuffer, 0, 4096)) > -1) {
                        ((OutputStream)aTargetStream).write(aBuffer, 0, n);
                    }
                    ((OutputStream)aTargetStream).close();
                    aInputStream.close();
                }
                catch (Exception e) {
                    aLogger.logError(e.getMessage());
                }
                continue block2;
            }
        }
        return false;
    }
}

