/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfxsltrunner;

import javax.xml.transform.TransformerException;
import org.xml.sax.SAXParseException;

public abstract class Logger {
    private static final String ERROR_PREFIX = "Error";
    private static final String FATAL_PREFIX = "Fatal";
    private static final String INFO_PREFIX = "Info";
    private static final String WARNING_PREFIX = "Warning";
    private String m_aEntryName;
    private String m_aFileName = "(none)";
    private boolean m_bError = false;
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;

    protected Logger() {
    }

    void setName(String aFileName) {
        this.setName(aFileName, null);
    }

    void setName(String aFileName, String aEntryName) {
        this.m_aFileName = aFileName;
        this.m_aEntryName = aEntryName;
    }

    protected String getName() {
        StringBuilder aName = new StringBuilder(this.m_aFileName);
        if (this.m_aEntryName != null && !this.m_aEntryName.isEmpty()) {
            aName.append('/');
            aName.append(this.m_aEntryName);
        }
        return aName.toString();
    }

    public boolean hasError() {
        return this.m_bError;
    }

    void logError(String aMsg) {
        this.logMessage(ERROR_PREFIX, aMsg, 0);
        this.m_bError = true;
    }

    void logError(TransformerException e) {
        this.logMessage(ERROR_PREFIX, e, 0);
        this.m_bError = true;
    }

    void logError(SAXParseException e) {
        this.logMessage(ERROR_PREFIX, e, 0);
        this.m_bError = true;
    }

    void logFatalError(String aMsg) {
        this.logMessage(FATAL_PREFIX, aMsg, 0);
        this.m_bError = true;
    }

    void logFatalError(TransformerException e) {
        this.logMessage(FATAL_PREFIX, e, 0);
        this.m_bError = true;
    }

    void logFatalError(SAXParseException e) {
        this.logMessage(FATAL_PREFIX, e, 0);
        this.m_bError = true;
    }

    void logInfo(String aMsg) {
        this.logMessage(INFO_PREFIX, aMsg, 2);
    }

    void logWarning(String aMsg) {
        this.logMessage(WARNING_PREFIX, aMsg, 1);
    }

    void logWarning(TransformerException e) {
        this.logMessage(WARNING_PREFIX, e, 1);
    }

    void logWarning(SAXParseException e) {
        this.logMessage(WARNING_PREFIX, e, 1);
    }

    private void logMessage(String aPrefix, TransformerException e, int nLevel) {
        this.logMessageWithLocation(aPrefix, e.getMessageAndLocation(), nLevel);
    }

    private void logMessage(String aPrefix, SAXParseException e, int nLevel) {
        StringBuilder aLocation = new StringBuilder(e.getSystemId());
        aLocation.append(':');
        aLocation.append(e.getLineNumber());
        aLocation.append(": ");
        aLocation.append(e.getColumnNumber());
        this.logMessage(aPrefix, e.getMessage(), aLocation.toString(), nLevel);
    }

    private void logMessage(String aPrefix, String aMsg, int nLevel) {
        this.logMessage(aPrefix, aMsg, null, nLevel);
    }

    protected abstract void logMessage(String var1, String var2, String var3, int var4);

    protected abstract void logMessageWithLocation(String var1, String var2, int var3);
}

