/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfxsltrunner;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfxsltrunner.Logger;

class ODFURIResolver
implements URIResolver {
    private Logger m_aLogger;
    private String m_aPackageBase;
    private String m_aFileEntryPath;
    private OdfPackage m_aPackage;

    public ODFURIResolver(OdfPackage aPackage, String aPackageBase, String aFileEntryPath, Logger aLogger) {
        this.m_aPackage = aPackage;
        this.m_aPackageBase = aPackageBase;
        this.m_aFileEntryPath = aFileEntryPath;
        this.m_aLogger = aLogger;
    }

    @Override
    public Source resolve(String aHRef, String aBase) throws TransformerException {
        if (aBase.startsWith(this.m_aPackageBase) && !aHRef.contains(":") && !aHRef.startsWith("/")) {
            if (aHRef.length() == 0) {
                try {
                    return new StreamSource(this.m_aPackage.getInputStream(this.m_aFileEntryPath), this.m_aPackageBase + "/" + this.m_aFileEntryPath);
                }
                catch (Exception ex) {
                    this.m_aLogger.logError(ex.getMessage());
                    return null;
                }
            }
            StringBuffer aHRefBuffer = new StringBuffer(aHRef);
            StringBuffer aFileEntryBuffer = new StringBuffer();
            if (this.m_aFileEntryPath.contains("/")) {
                aFileEntryBuffer.append(this.m_aFileEntryPath.substring(0, this.m_aFileEntryPath.lastIndexOf(47) + 1));
            }
            while (true) {
                if (aHRefBuffer.substring(0, 2).equals("./")) {
                    aHRefBuffer.delete(0, 2);
                    continue;
                }
                if (aHRefBuffer.toString().equals(".") || aHRefBuffer.toString().equals("..")) {
                    this.m_aLogger.logError("URIs resolving to directories cannot be resolved: " + aHRef);
                    return null;
                }
                if (!aHRefBuffer.substring(0, 3).equals("../")) break;
                aFileEntryBuffer.delete(0, 3);
                if (aFileEntryBuffer.length() == 0) {
                    aHRefBuffer.insert(0, "./");
                    try {
                        URI aURI = new URI(aBase);
                        aURI.resolve(aHRefBuffer.toString());
                        this.m_aLogger.logInfo("Resolving " + aHRef + " to " + aURI.toString());
                        return new StreamSource(aURI.toString());
                    }
                    catch (URISyntaxException ex) {
                        this.m_aLogger.logError(ex.getMessage());
                        return null;
                    }
                }
                aFileEntryBuffer.delete(0, aFileEntryBuffer.indexOf("/1"));
            }
            aHRefBuffer.insert(0, aFileEntryBuffer.toString());
            try {
                String aFileEntryPath = aHRefBuffer.toString();
                this.m_aLogger.logInfo("Resolving " + aHRef + " to package file entry " + aFileEntryPath);
                return new StreamSource(this.m_aPackage.getInputStream(aFileEntryPath), this.m_aPackageBase + "/" + aFileEntryPath);
            }
            catch (Exception ex) {
                this.m_aLogger.logError(ex.getMessage());
                return null;
            }
        }
        return null;
    }
}

