/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.util.Iterator;
import java.util.List;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.PresentationDocument;
import org.odftoolkit.simple.draw.AbstractTextboxContainer;
import org.odftoolkit.simple.draw.FrameRectangle;
import org.odftoolkit.simple.draw.Textbox;
import org.odftoolkit.simple.draw.TextboxContainer;
import org.odftoolkit.simple.style.DefaultStyleHandler;
import org.odftoolkit.simple.text.ParagraphContainer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paragraph
extends Component
implements TextboxContainer {
    private TextPElement mParagraphElement;
    private Document mOwnerDocument;
    private ParagraphContainer mContainer;
    private DefaultStyleHandler mStyleHandler;
    private TextboxContainerImpl mTextboxContainerImpl;

    private Paragraph(TextPElement pElement) {
        this.mParagraphElement = pElement;
        this.mOwnerDocument = (Document)((OdfFileDom)pElement.getOwnerDocument()).getDocument();
        this.mStyleHandler = new DefaultStyleHandler((OdfStylableElement)pElement);
        this.mContainer = null;
    }

    public static Paragraph getInstanceof(TextPElement pElement) {
        if (pElement == null) {
            return null;
        }
        Paragraph para = null;
        para = (Paragraph)Component.getComponentByElement((OdfElement)pElement);
        if (para != null) {
            return para;
        }
        para = new Paragraph(pElement);
        Component.registerComponent(para, (OdfElement)pElement);
        return para;
    }

    public static Paragraph newParagraph(ParagraphContainer container) {
        Paragraph para = null;
        OdfElement parent = container.getParagraphContainerElement();
        OdfFileDom ownerDom = (OdfFileDom)parent.getOwnerDocument();
        TextPElement pEle = (TextPElement)ownerDom.newOdfElement(TextPElement.class);
        parent.appendChild((Node)pEle);
        para = new Paragraph(pEle);
        para.mContainer = container;
        Component.registerComponent(para, (OdfElement)pEle);
        return para;
    }

    public void setTextContent(String content) {
        this.removeTextContent();
        if (content != null && !content.equals("")) {
            this.appendTextElements(content, true);
        }
    }

    public void removeTextContent() {
        NodeList nodeList = this.mParagraphElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodename;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                this.mParagraphElement.removeChild(node);
                --i;
                continue;
            }
            if (node.getNodeType() != 1 || !(nodename = node.getNodeName()).equals("text:s") && !nodename.equals("text:tab") && !nodename.equals("text:line-break")) continue;
            this.mParagraphElement.removeChild(node);
            --i;
        }
    }

    public String getTextContent() {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = this.mParagraphElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                buffer.append(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("text:s")) {
                int count = ((TextSElement)node).getTextCAttribute();
                for (int j = 0; j < count; ++j) {
                    buffer.append(' ');
                }
                continue;
            }
            if (node.getNodeName().equals("text:tab")) {
                buffer.append('\t');
                continue;
            }
            if (!node.getNodeName().equals("text:line-break")) continue;
            String lineseperator = System.getProperty("line.separator");
            buffer.append(lineseperator);
        }
        return buffer.toString();
    }

    public void setTextContentNotCollapsed(String content) {
        this.removeTextContent();
        if (content != null && !content.equals("")) {
            this.appendTextElements(content, false);
        }
    }

    private void appendTextElements(String content, boolean isWhitespaceCollapsed) {
        if (isWhitespaceCollapsed) {
            int i = 0;
            int length = content.length();
            String str = "";
            while (i < length) {
                char ch = content.charAt(i);
                if (ch == ' ') {
                    int j = 1;
                    ++i;
                    while (i < length && content.charAt(i) == ' ') {
                        ++j;
                        ++i;
                    }
                    if (j == 1) {
                        str = str + ' ';
                        continue;
                    }
                    str = str + ' ';
                    Text textnode = this.mParagraphElement.getOwnerDocument().createTextNode(str);
                    this.mParagraphElement.appendChild((Node)textnode);
                    str = "";
                    TextSElement spaceElement = this.mParagraphElement.newTextSElement();
                    spaceElement.setTextCAttribute(Integer.valueOf(j - 1));
                    continue;
                }
                if (ch == '\n') {
                    if (str.length() > 0) {
                        Text textnode = this.mParagraphElement.getOwnerDocument().createTextNode(str);
                        this.mParagraphElement.appendChild((Node)textnode);
                        str = "";
                    }
                    this.mParagraphElement.newTextLineBreakElement();
                    ++i;
                    continue;
                }
                if (ch == '\t') {
                    if (str.length() > 0) {
                        Text textnode = this.mParagraphElement.getOwnerDocument().createTextNode(str);
                        this.mParagraphElement.appendChild((Node)textnode);
                        str = "";
                    }
                    this.mParagraphElement.newTextTabElement();
                    ++i;
                    continue;
                }
                if (ch == '\r') {
                    ++i;
                    continue;
                }
                str = str + ch;
                ++i;
            }
            if (str.length() > 0) {
                Text textnode = this.mParagraphElement.getOwnerDocument().createTextNode(str);
                this.mParagraphElement.appendChild((Node)textnode);
            }
        } else {
            Text textnode = this.mParagraphElement.getOwnerDocument().createTextNode(content);
            this.mParagraphElement.appendChild((Node)textnode);
        }
    }

    public void appendTextContent(String content) {
        if (content != null && !content.equals("")) {
            this.appendTextElements(content, true);
        }
    }

    public void appendTextContentNotCollapsed(String content) {
        if (content != null && !content.equals("")) {
            this.appendTextElements(content, false);
        }
    }

    public void setStyleName(String styleName) {
        this.mStyleHandler.getStyleElementForWrite().setStyleNameAttribute(styleName);
    }

    public String getStyleName() {
        OdfStyleBase style = this.getStyleHandler().getStyleElementForRead();
        if (style == null) {
            return "";
        }
        if (style instanceof OdfStyle) {
            return ((OdfStyle)style).getStyleNameAttribute();
        }
        return "";
    }

    @Override
    public Document getOwnerDocument() {
        return this.mOwnerDocument;
    }

    public DefaultStyleHandler getStyleHandler() {
        if (this.mStyleHandler != null) {
            return this.mStyleHandler;
        }
        this.mStyleHandler = new DefaultStyleHandler((OdfStylableElement)this.mParagraphElement);
        return this.mStyleHandler;
    }

    public TextPElement getOdfElement() {
        return this.mParagraphElement;
    }

    @Override
    public Textbox addTextbox() {
        return this.getTextboxContainerImpl().addTextbox();
    }

    @Override
    public Iterator<Textbox> getTextboxIterator() {
        return this.getTextboxContainerImpl().getTextboxIterator();
    }

    @Override
    public boolean removeTextbox(Textbox box) {
        return this.getTextboxContainerImpl().removeTextbox(box);
    }

    @Override
    public OdfElement getFrameContainerElement() {
        return this.getTextboxContainerImpl().getFrameContainerElement();
    }

    @Override
    public Textbox addTextbox(FrameRectangle position) {
        return this.getTextboxContainerImpl().addTextbox(position);
    }

    @Override
    public Textbox getTextboxByName(String name) {
        return this.getTextboxContainerImpl().getTextboxByName(name);
    }

    @Override
    public List<Textbox> getTextboxByUsage(PresentationDocument.PresentationClass usage) {
        throw new UnsupportedOperationException("this method is not supported by paragraph.");
    }

    private TextboxContainerImpl getTextboxContainerImpl() {
        if (this.mTextboxContainerImpl == null) {
            this.mTextboxContainerImpl = new TextboxContainerImpl();
        }
        return this.mTextboxContainerImpl;
    }

    private class TextboxContainerImpl
    extends AbstractTextboxContainer {
        private TextboxContainerImpl() {
        }

        public OdfElement getFrameContainerElement() {
            return Paragraph.this.mParagraphElement;
        }
    }
}

