/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.draw;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawImageElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.odftoolkit.odfdom.type.AnyURI;
import org.odftoolkit.odfdom.type.Length;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.draw.Frame;
import org.odftoolkit.simple.draw.FrameContainer;
import org.odftoolkit.simple.draw.FrameRectangle;
import org.odftoolkit.simple.draw.FrameStyleHandler;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.text.AbstractParagraphContainer;
import org.odftoolkit.simple.text.Paragraph;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image
extends Component {
    private static final String SLASH = "/";
    DrawImageElement mImageElement;
    Frame mFrame;
    URI mImageURI = null;
    DrawFrameElement mElement;
    Document mOwnerDocument;
    FrameStyleHandler mStyleHandler;

    private Image(DrawImageElement drawElement) {
        this.mOwnerDocument = (Document)((OdfFileDom)drawElement.getOwnerDocument()).getDocument();
        this.mElement = (DrawFrameElement)drawElement.getParentNode();
        if (this.mElement == null) {
            Logger.getLogger(Image.class.getName()).log(Level.WARNING, "The image has no parent frame. A new frame will be created as its parent");
            OdfFileDom ownerDom = (OdfFileDom)drawElement.getOwnerDocument();
            this.mElement = (DrawFrameElement)ownerDom.newOdfElement(DrawFrameElement.class);
            this.mElement.appendChild((Node)drawElement);
        }
        this.mFrame = Frame.getInstanceof(this.mElement);
        this.mImageElement = drawElement;
    }

    public static Image getInstanceof(DrawImageElement imageElement) {
        if (imageElement == null) {
            return null;
        }
        Image image = null;
        image = (Image)Component.getComponentByElement((OdfElement)imageElement);
        if (image != null) {
            return image;
        }
        Image myImage = new Image(imageElement);
        Component.registerComponent(myImage, (OdfElement)imageElement);
        return myImage;
    }

    @Override
    public Document getOwnerDocument() {
        return this.mOwnerDocument;
    }

    public FrameStyleHandler getStyleHandler() {
        if (this.mStyleHandler == null) {
            this.mStyleHandler = new FrameStyleHandler(this.mFrame);
        }
        return this.mStyleHandler;
    }

    public DrawImageElement getOdfElement() {
        return this.mImageElement;
    }

    public Frame getFrame() {
        return this.mFrame;
    }

    public static Image newImage(FrameContainer container, URI uri) {
        try {
            OdfElement parent = container.getFrameContainerElement();
            OdfFileDom ownerDom = (OdfFileDom)parent.getOwnerDocument();
            DrawFrameElement fElement = (DrawFrameElement)ownerDom.newOdfElement(DrawFrameElement.class);
            parent.appendChild((Node)fElement);
            DrawImageElement imageElement = fElement.newDrawImageElement();
            String packagePath = Image.insertImageResourceIntoPackage((OdfSchemaDocument)ownerDom.getDocument(), uri);
            packagePath = packagePath.replaceFirst(ownerDom.getDocument().getDocumentPath(), "");
            URI newURI = Image.configureInsertedImage((OdfSchemaDocument)ownerDom.getDocument(), imageElement, packagePath, false);
            Image mImage = new Image(imageElement);
            mImage.mImageURI = newURI;
            Component.registerComponent(mImage, (OdfElement)imageElement);
            if (container instanceof Paragraph) {
                mImage.getStyleHandler().setAchorType(StyleTypeDefinitions.AnchorType.TO_PARAGRAPH);
            }
            return mImage;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Image newImage(Frame frame, URI uri) {
        try {
            DrawFrameElement fElement = frame.getDrawFrameElement();
            OdfFileDom ownerDom = (OdfFileDom)fElement.getOwnerDocument();
            DrawImageElement imageElement = fElement.newDrawImageElement();
            String packagePath = Image.insertImageResourceIntoPackage((OdfSchemaDocument)ownerDom.getDocument(), uri);
            packagePath = packagePath.replaceFirst(ownerDom.getDocument().getDocumentPath(), "");
            URI newURI = Image.configureInsertedImage((OdfSchemaDocument)ownerDom.getDocument(), imageElement, packagePath, true);
            Image mImage = new Image(imageElement);
            mImage.mImageURI = newURI;
            Component.registerComponent(mImage, (OdfElement)imageElement);
            FrameContainer container = frame.mFrameContainer;
            if (container instanceof Paragraph) {
                mImage.getStyleHandler().setAchorType(StyleTypeDefinitions.AnchorType.TO_PARAGRAPH);
            }
            return mImage;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String insertImageResourceIntoPackage(OdfSchemaDocument mOdfSchemaDoc, URI imageUri) throws Exception {
        String imageRef = imageUri.toString();
        String mediaType = OdfFileEntry.getMediaTypeString((String)imageRef);
        String packagePath = Image.getPackagePath(mOdfSchemaDoc, imageRef);
        mOdfSchemaDoc.getPackage().insert(imageUri, packagePath, mediaType);
        return packagePath;
    }

    private static String getPackagePath(OdfSchemaDocument mOdfSchemaDoc, String imageRef) {
        if (imageRef.contains(SLASH)) {
            imageRef = imageRef.substring(imageRef.lastIndexOf(SLASH) + 1, imageRef.length());
        }
        String packagePath = OdfPackage.OdfFile.IMAGE_DIRECTORY.getPath() + SLASH + imageRef;
        packagePath = mOdfSchemaDoc.getDocumentPath() + packagePath;
        return packagePath;
    }

    private static URI configureInsertedImage(OdfSchemaDocument mOdfSchemaDoc, DrawImageElement imageElement, String packagePath, boolean isResetSize) throws Exception {
        URI uri = new URI(AnyURI.encodePath((String)packagePath).toString());
        imageElement.setXlinkHrefAttribute(AnyURI.decodePath((String)uri.toString()));
        imageElement.setXlinkTypeAttribute("simple");
        InputStream is = mOdfSchemaDoc.getPackage().getInputStream(packagePath);
        DrawFrameElement odfFrame = (DrawFrameElement)imageElement.getParentNode();
        Frame aFrame = Frame.getInstanceof(odfFrame);
        FrameRectangle oldRect = aFrame.getRectangle();
        if (oldRect.getLinearMeasure() != StyleTypeDefinitions.SupportedLinearMeasure.CM) {
            oldRect.setLinearMeasure(StyleTypeDefinitions.SupportedLinearMeasure.CM);
        }
        if (odfFrame != null) {
            BufferedImage image = ImageIO.read(is);
            int height = image.getHeight(null);
            int width = image.getWidth(null);
            odfFrame.setSvgHeightAttribute(Length.mapToUnit((String)(String.valueOf(height) + "px"), (Length.Unit)Length.Unit.CENTIMETER));
            odfFrame.setSvgWidthAttribute(Length.mapToUnit((String)(String.valueOf(width) + "px"), (Length.Unit)Length.Unit.CENTIMETER));
            if (isResetSize) {
                FrameRectangle newRect = aFrame.getRectangle();
                newRect.setX(oldRect.getX() + (oldRect.getWidth() - newRect.getWidth()) / 2.0);
                newRect.setY(oldRect.getY() + (oldRect.getHeight() - newRect.getHeight()) / 2.0);
                aFrame.setRectangle(newRect);
            }
        }
        return uri;
    }

    public static Iterator<Image> imageIterator(FrameContainer container) {
        return new SimpleImageIterator(container);
    }

    public boolean remove() {
        OdfElement containerElement = (OdfElement)this.mElement.getParentNode();
        try {
            this.mElement.removeChild((Node)this.getOdfElement());
            if (!this.mElement.hasChildNodes()) {
                containerElement.removeChild((Node)this.mElement);
            }
            this.mOwnerDocument.removeElementLinkedResource((OdfElement)this.getOdfElement());
        }
        catch (DOMException exception) {
            Logger.getLogger(AbstractParagraphContainer.class.getName()).log(Level.WARNING, exception.getMessage());
            return false;
        }
        return true;
    }

    public void updateImage(URI imageUri) {
        try {
            String packagePath = this.mImageURI.toString();
            this.mOwnerDocument.getPackage().remove(packagePath);
            String imageRef = imageUri.toString();
            String mediaType = OdfFileEntry.getMediaTypeString((String)imageRef);
            this.mOwnerDocument.getPackage().insert(imageUri, packagePath, mediaType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InputStream getImageInputStream() {
        return this.mOwnerDocument.getPackage().getInputStream(this.getInternalPath());
    }

    public String getInternalPath() {
        try {
            if (this.mImageURI == null) {
                this.mImageURI = new URI(this.mImageElement.getXlinkHrefAttribute());
            }
            return this.mImageURI.toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getMediaTypeString() {
        return this.mOwnerDocument.getPackage().getMediaTypeString(this.getInternalPath());
    }

    public void setName(String name) {
        this.mFrame.setName(name);
    }

    public String getName() {
        return this.mFrame.getName();
    }

    public void setRectangle(FrameRectangle rectangle) {
        this.mFrame.setRectangle(rectangle);
    }

    public FrameRectangle getRectangle() {
        return this.mFrame.getRectangle();
    }

    public void setTitle(String title) {
        this.mFrame.setTitle(title);
    }

    public String getTitle() {
        return this.mFrame.getTitle();
    }

    public String getDesciption() {
        return this.mFrame.getDesciption();
    }

    public void setDescription(String description) {
        this.mFrame.setDescription(description);
    }

    public void setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition horizontalPos) {
        this.getStyleHandler().setHorizontalPosition(horizontalPos);
    }

    public void setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition verticalPos) {
        this.getStyleHandler().setVerticalPosition(verticalPos);
    }

    public StyleTypeDefinitions.FrameHorizontalPosition getHorizontalPosition() {
        return this.getStyleHandler().getHorizontalPosition();
    }

    public StyleTypeDefinitions.FrameVerticalPosition getVerticalPosition() {
        return this.getStyleHandler().getVerticalPosition();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleImageIterator
    implements Iterator<Image> {
        private OdfElement containerElement;
        private Image nextElement = null;
        private Image tempElement = null;

        private SimpleImageIterator(FrameContainer container) {
            this.containerElement = container.getFrameContainerElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public Image next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.containerElement.removeChild((Node)this.nextElement.getOdfElement());
        }

        private Image findNext(Image thisImage) {
            DrawImageElement nextFrame = null;
            nextFrame = thisImage == null ? (DrawImageElement)OdfElement.findFirstChildNode(DrawImageElement.class, (Node)this.containerElement) : (DrawImageElement)OdfElement.findNextChildNode(DrawImageElement.class, (Node)thisImage.getOdfElement());
            if (nextFrame != null) {
                return Image.getInstanceof(nextFrame);
            }
            return null;
        }
    }
}

