/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple;

import java.awt.Rectangle;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnchorTypeAttribute;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSectionElement;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStylePageLayout;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.type.CellRangeAddressList;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.chart.AbstractChartContainer;
import org.odftoolkit.simple.chart.Chart;
import org.odftoolkit.simple.chart.ChartContainer;
import org.odftoolkit.simple.chart.DataSet;
import org.odftoolkit.simple.common.field.AbstractVariableContainer;
import org.odftoolkit.simple.common.field.VariableContainer;
import org.odftoolkit.simple.common.field.VariableField;
import org.odftoolkit.simple.text.AbstractParagraphContainer;
import org.odftoolkit.simple.text.Footer;
import org.odftoolkit.simple.text.Header;
import org.odftoolkit.simple.text.Paragraph;
import org.odftoolkit.simple.text.ParagraphContainer;
import org.odftoolkit.simple.text.Section;
import org.odftoolkit.simple.text.list.AbstractListContainer;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDocument
extends Document
implements ListContainer,
ParagraphContainer,
VariableContainer,
ChartContainer {
    private static final String EMPTY_TEXT_DOCUMENT_PATH = "/OdfTextDocument.odt";
    static final OdfPackageDocument.Resource EMPTY_TEXT_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfTextDocument.odt");
    private ListContainerImpl listContainerImpl;
    private ParagraphContainerImpl paragraphContainerImpl;
    private VariableContainerImpl variableContainerImpl;
    private ChartContainerImpl chartContainerImpl;
    private Header firstPageHeader;
    private Header standardHeader;
    private Footer firstPageFooter;
    private Footer standardFooter;

    public static TextDocument newTextDocument() throws Exception {
        return (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT);
    }

    public static TextDocument newTextDocument(OdfMediaType mimeType) throws Exception {
        return (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT);
    }

    public static TextDocument newTextTemplateDocument() throws Exception {
        return (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT_TEMPLATE);
    }

    public static TextDocument newTextMasterDocument() throws Exception {
        TextDocument doc = (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT_MASTER);
        doc.changeMode(OdfMediaType.TEXT_MASTER);
        return doc;
    }

    public static TextDocument newTextWebDocument() throws Exception {
        TextDocument doc = (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT_WEB);
        doc.changeMode(OdfMediaType.TEXT_WEB);
        return doc;
    }

    public static TextDocument loadDocument(InputStream inputStream) throws Exception {
        return (TextDocument)Document.loadDocument(inputStream);
    }

    public static TextDocument loadDocument(String documentPath) throws Exception {
        return (TextDocument)Document.loadDocument(documentPath);
    }

    public static TextDocument loadDocument(File file) throws Exception {
        return (TextDocument)Document.loadDocument(file);
    }

    protected TextDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    public OfficeTextElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeTextElement.class);
    }

    public OdfTextParagraph newParagraph(String text) throws Exception {
        OdfTextParagraph para = this.newParagraph();
        para.addContent(text);
        return para;
    }

    public OdfTextParagraph newParagraph() throws Exception {
        OfficeTextElement odfText = this.getContentRoot();
        return (OdfTextParagraph)odfText.newTextPElement();
    }

    public OdfTextParagraph addText(String text) throws Exception {
        OfficeTextElement odfText = this.getContentRoot();
        Node n = odfText.getLastChild();
        OdfTextParagraph para = OdfTextParagraph.class.isInstance(n) ? (OdfTextParagraph)n : this.newParagraph();
        para.addContent(text);
        return para;
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    public Section appendSection(Section section, boolean isResourceCopied) {
        boolean isForeignNode = false;
        try {
            if (section.getOdfElement().getOwnerDocument() != this.getContentDom()) {
                isForeignNode = true;
            }
            TextSectionElement oldSectionEle = section.getOdfElement();
            TextSectionElement newSectionEle = (TextSectionElement)oldSectionEle.cloneNode(true);
            if (isResourceCopied || isForeignNode) {
                this.copyLinkedRefInBatch((OdfElement)newSectionEle, section.getOwnerDocument());
            }
            if (isForeignNode) {
                this.copyForeignStyleRef((OdfElement)newSectionEle, section.getOwnerDocument());
            }
            if (isForeignNode) {
                newSectionEle = (TextSectionElement)this.cloneForeignElement((Node)newSectionEle, (OdfFileDom)this.getContentDom(), true);
            }
            this.updateNames((OdfElement)newSectionEle);
            this.updateXMLIds((OdfElement)newSectionEle);
            OfficeTextElement contentRoot = this.getContentRoot();
            contentRoot.appendChild((Node)newSectionEle);
            return Section.getInstance(newSectionEle);
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public Header getHeader() {
        return this.getHeader(false);
    }

    public Header getHeader(boolean isFirstPage) {
        Header tmpHeader;
        Header header = tmpHeader = isFirstPage ? this.firstPageHeader : this.standardHeader;
        if (tmpHeader == null) {
            try {
                StyleMasterPageElement masterPageElement = this.getMasterPage(isFirstPage);
                StyleHeaderElement headerElement = (StyleHeaderElement)OdfElement.findFirstChildNode(StyleHeaderElement.class, (Node)masterPageElement);
                if (headerElement == null) {
                    headerElement = masterPageElement.newStyleHeaderElement();
                }
                tmpHeader = new Header(headerElement);
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            }
            if (isFirstPage) {
                this.firstPageHeader = tmpHeader;
            } else {
                this.standardHeader = tmpHeader;
            }
        }
        return tmpHeader;
    }

    public Footer getFooter() {
        return this.getFooter(false);
    }

    public Footer getFooter(boolean isFirstPage) {
        Footer tmpFooter;
        Footer footer = tmpFooter = isFirstPage ? this.firstPageFooter : this.standardFooter;
        if (tmpFooter == null) {
            try {
                StyleMasterPageElement masterPageElement = this.getMasterPage(isFirstPage);
                StyleFooterElement footerElement = (StyleFooterElement)OdfElement.findFirstChildNode(StyleFooterElement.class, (Node)masterPageElement);
                if (footerElement == null) {
                    footerElement = masterPageElement.newStyleFooterElement();
                }
                tmpFooter = new Footer(footerElement);
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            }
            if (isFirstPage) {
                this.firstPageFooter = tmpFooter;
            } else {
                this.standardFooter = tmpFooter;
            }
        }
        return tmpFooter;
    }

    @Override
    public OdfElement getTableContainerElement() {
        return this.getTableContainerImpl().getTableContainerElement();
    }

    @Override
    public OdfElement getListContainerElement() {
        return this.getListContainerImpl().getListContainerElement();
    }

    @Override
    public List addList() {
        return this.getListContainerImpl().addList();
    }

    @Override
    public List addList(ListDecorator decorator) {
        return this.getListContainerImpl().addList(decorator);
    }

    @Override
    public void clearList() {
        this.getListContainerImpl().clearList();
    }

    @Override
    public Iterator<List> getListIterator() {
        return this.getListContainerImpl().getListIterator();
    }

    @Override
    public boolean removeList(List list) {
        return this.getListContainerImpl().removeList(list);
    }

    @Override
    public Paragraph addParagraph(String text) {
        Paragraph para = this.getParagraphContainerImpl().addParagraph(text);
        return para;
    }

    @Override
    public boolean removeParagraph(Paragraph para) {
        return this.getParagraphContainerImpl().removeParagraph(para);
    }

    @Override
    public OdfElement getParagraphContainerElement() {
        return this.getParagraphContainerImpl().getParagraphContainerElement();
    }

    @Override
    public Paragraph getParagraphByIndex(int index, boolean isEmptyParagraphSkipped) {
        return this.getParagraphContainerImpl().getParagraphByIndex(index, isEmptyParagraphSkipped);
    }

    @Override
    public Paragraph getParagraphByReverseIndex(int reverseIndex, boolean isEmptyParagraphSkipped) {
        return this.getParagraphContainerImpl().getParagraphByReverseIndex(reverseIndex, isEmptyParagraphSkipped);
    }

    @Override
    public Iterator<Paragraph> getParagraphIterator() {
        return this.getParagraphContainerImpl().getParagraphIterator();
    }

    @Override
    public VariableField declareVariable(String name, VariableField.VariableType type) {
        return this.getVariableContainerImpl().declareVariable(name, type);
    }

    @Override
    public VariableField getVariableFieldByName(String name) {
        return this.getVariableContainerImpl().getVariableFieldByName(name);
    }

    @Override
    public OdfElement getVariableContainerElement() {
        return this.getVariableContainerImpl().getVariableContainerElement();
    }

    @Override
    public Chart createChart(String title, DataSet dataset, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, dataset, rect);
    }

    @Override
    public Chart createChart(String title, SpreadsheetDocument document, CellRangeAddressList cellRangeAddr, boolean firstRowAsLabel, boolean firstColumnAsLabel, boolean rowAsDataSeries, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, document, cellRangeAddr, firstRowAsLabel, firstColumnAsLabel, rowAsDataSeries, rect);
    }

    @Override
    public Chart createChart(String title, String[] labels, String[] legends, double[][] data, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, labels, legends, data, rect);
    }

    @Override
    public void deleteChartById(String chartId) {
        this.getChartContainerImpl().deleteChartById(chartId);
    }

    @Override
    public void deleteChartByTitle(String title) {
        this.getChartContainerImpl().deleteChartByTitle(title);
    }

    @Override
    public Chart getChartById(String chartId) {
        return this.getChartContainerImpl().getChartById(chartId);
    }

    @Override
    public java.util.List<Chart> getChartByTitle(String title) {
        return this.getChartContainerImpl().getChartByTitle(title);
    }

    @Override
    public int getChartCount() {
        return this.getChartContainerImpl().getChartCount();
    }

    private ListContainerImpl getListContainerImpl() {
        if (this.listContainerImpl == null) {
            this.listContainerImpl = new ListContainerImpl();
        }
        return this.listContainerImpl;
    }

    private StyleMasterPageElement getMasterPage(boolean pFirstPage) throws Exception {
        String pageStyleName = pFirstPage ? "First_20_Page" : "Standard";
        OfficeDocumentStylesElement rootElement = this.getStylesDom().getRootElement();
        OfficeMasterStylesElement masterStyles = (OfficeMasterStylesElement)OdfElement.findFirstChildNode(OfficeMasterStylesElement.class, (Node)rootElement);
        if (masterStyles == null) {
            masterStyles = rootElement.newOfficeMasterStylesElement();
        }
        StyleMasterPageElement masterPageEle = null;
        NodeList lastMasterPages = masterStyles.getElementsByTagNameNS(OdfDocumentNamespace.STYLE.getUri(), "master-page");
        if (lastMasterPages != null && lastMasterPages.getLength() > 0) {
            for (int i = 0; i < lastMasterPages.getLength(); ++i) {
                StyleMasterPageElement masterPage = (StyleMasterPageElement)lastMasterPages.item(i);
                String styleName = masterPage.getStyleNameAttribute();
                if (!pageStyleName.equals(styleName)) continue;
                masterPageEle = masterPage;
                break;
            }
        }
        if (masterPageEle == null) {
            OdfStylePageLayout layout = (OdfStylePageLayout)OdfElement.findFirstChildNode(OdfStylePageLayout.class, (Node)this.getStylesDom().getAutomaticStyles());
            masterPageEle = masterStyles.newStyleMasterPageElement(pageStyleName, layout.getStyleNameAttribute());
        }
        return masterPageEle;
    }

    private ParagraphContainerImpl getParagraphContainerImpl() {
        if (this.paragraphContainerImpl == null) {
            this.paragraphContainerImpl = new ParagraphContainerImpl();
        }
        return this.paragraphContainerImpl;
    }

    private VariableContainer getVariableContainerImpl() {
        if (this.variableContainerImpl == null) {
            this.variableContainerImpl = new VariableContainerImpl();
        }
        return this.variableContainerImpl;
    }

    private ChartContainerImpl getChartContainerImpl() {
        if (this.chartContainerImpl == null) {
            this.chartContainerImpl = new ChartContainerImpl(this);
        }
        return this.chartContainerImpl;
    }

    private class ChartContainerImpl
    extends AbstractChartContainer {
        TextDocument sdoc;

        protected ChartContainerImpl(Document doc) {
            super(doc);
            this.sdoc = (TextDocument)doc;
        }

        protected DrawFrameElement getChartFrame() throws Exception {
            OdfContentDom contentDom2 = this.sdoc.getContentDom();
            DrawFrameElement drawFrame = (DrawFrameElement)contentDom2.newOdfElement(DrawFrameElement.class);
            TextPElement lastPara = this.sdoc.getContentRoot().newTextPElement();
            lastPara.appendChild((Node)drawFrame);
            drawFrame.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PARAGRAPH.toString());
            return drawFrame;
        }
    }

    private class VariableContainerImpl
    extends AbstractVariableContainer {
        private VariableContainerImpl() {
        }

        public OdfElement getVariableContainerElement() {
            try {
                return TextDocument.this.getContentRoot();
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
                return null;
            }
        }
    }

    private class ParagraphContainerImpl
    extends AbstractParagraphContainer {
        private ParagraphContainerImpl() {
        }

        public OdfElement getParagraphContainerElement() {
            OfficeTextElement containerElement = null;
            try {
                containerElement = TextDocument.this.getContentRoot();
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            }
            return containerElement;
        }
    }

    private class ListContainerImpl
    extends AbstractListContainer {
        private ListContainerImpl() {
        }

        public OdfElement getListContainerElement() {
            OfficeTextElement containerElement = null;
            try {
                containerElement = TextDocument.this.getContentRoot();
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            }
            return containerElement;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        TEXT(Document.OdfMediaType.TEXT),
        TEXT_TEMPLATE(Document.OdfMediaType.TEXT_TEMPLATE),
        TEXT_MASTER(Document.OdfMediaType.TEXT_MASTER),
        TEXT_WEB(Document.OdfMediaType.TEXT_WEB);

        private final Document.OdfMediaType mMediaType;

        private OdfMediaType(Document.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static Document.OdfMediaType getOdfMediaType(String mediaType) {
            return Document.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

