/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.simple.text.Paragraph;
import org.odftoolkit.simple.text.ParagraphContainer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParagraphContainer
implements ParagraphContainer {
    @Override
    public abstract OdfElement getParagraphContainerElement();

    @Override
    public Paragraph addParagraph(String textContent) {
        Paragraph para = Paragraph.newParagraph(this);
        para.setTextContent(textContent);
        return para;
    }

    @Override
    public boolean removeParagraph(Paragraph para) {
        OdfElement containerElement = this.getParagraphContainerElement();
        try {
            containerElement.removeChild((Node)para.getOdfElement());
        }
        catch (DOMException exception) {
            Logger.getLogger(AbstractParagraphContainer.class.getName()).log(Level.WARNING, exception.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Paragraph> getParagraphIterator() {
        return new SimpleParagraphIterator(this);
    }

    @Override
    public Paragraph getParagraphByIndex(int index, boolean isEmptyParagraphSkipped) {
        Iterator<Paragraph> iterator = this.getParagraphIterator();
        while (iterator.hasNext() && index >= 0) {
            String content;
            Paragraph current = iterator.next();
            if (isEmptyParagraphSkipped && ((content = current.getTextContent()) == null || content.length() == 0)) continue;
            if (index == 0) {
                return current;
            }
            --index;
        }
        return null;
    }

    @Override
    public Paragraph getParagraphByReverseIndex(int reverseIndex, boolean isEmptyParagraphSkipped) {
        OdfElement containerElement = this.getParagraphContainerElement();
        Node node = containerElement.getLastChild();
        while (node != null && reverseIndex >= 0) {
            if (node.getNodeType() != 1) {
                node = node.getPreviousSibling();
                continue;
            }
            if (node instanceof TextParagraphElementBase) {
                if (isEmptyParagraphSkipped && (!node.hasChildNodes() || node.getTextContent() == null || node.getTextContent().length() == 0)) {
                    node = node.getPreviousSibling();
                    continue;
                }
                if (reverseIndex == 0) {
                    return Paragraph.getInstanceof((TextParagraphElementBase)node);
                }
                --reverseIndex;
            }
            node = node.getPreviousSibling();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleParagraphIterator
    implements Iterator<Paragraph> {
        private OdfElement containerElement;
        private Paragraph nextElement = null;
        private Paragraph tempElement = null;

        private SimpleParagraphIterator(ParagraphContainer container) {
            this.containerElement = container.getParagraphContainerElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public Paragraph next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.containerElement.removeChild((Node)this.nextElement.getOdfElement());
        }

        private Paragraph findNext(Paragraph thisBox) {
            TextParagraphElementBase nextParagraph = null;
            nextParagraph = thisBox == null ? (TextParagraphElementBase)OdfElement.findFirstChildNode(TextParagraphElementBase.class, (Node)this.containerElement) : (TextParagraphElementBase)OdfElement.findNextChildNode(TextParagraphElementBase.class, (Node)thisBox.getOdfElement());
            if (nextParagraph != null) {
                return Paragraph.getInstanceof(nextParagraph);
            }
            return null;
        }
    }
}

