/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.draw;

import java.util.Iterator;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.common.TextExtractor;
import org.odftoolkit.simple.draw.Frame;
import org.odftoolkit.simple.draw.TextboxContainer;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.text.AbstractParagraphContainer;
import org.odftoolkit.simple.text.Paragraph;
import org.odftoolkit.simple.text.ParagraphContainer;
import org.odftoolkit.simple.text.list.AbstractListContainer;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Textbox
extends Frame
implements ListContainer,
ParagraphContainer {
    DrawTextBoxElement mTextboxElement;
    private ParagraphContainerImpl paragraphContainerImpl;
    private ListContainerImpl listContainerImpl;

    private Textbox(DrawTextBoxElement textbox) {
        super((DrawFrameElement)textbox.getParentNode());
        this.mTextboxElement = textbox;
    }

    public static Textbox getInstanceof(DrawTextBoxElement element) {
        if (element == null) {
            return null;
        }
        Textbox textbox = null;
        textbox = (Textbox)Component.getComponentByElement((OdfElement)element);
        if (textbox != null) {
            return textbox;
        }
        textbox = new Textbox(element);
        Component.registerComponent(textbox, (OdfElement)element);
        return textbox;
    }

    public static Textbox newTextbox(TextboxContainer container) {
        Textbox textbox = null;
        OdfElement parent = container.getFrameContainerElement();
        OdfFileDom ownerDom = (OdfFileDom)parent.getOwnerDocument();
        DrawFrameElement fElement = (DrawFrameElement)ownerDom.newOdfElement(DrawFrameElement.class);
        parent.appendChild((Node)fElement);
        DrawTextBoxElement boxElement = fElement.newDrawTextBoxElement();
        textbox = new Textbox(boxElement);
        textbox.mFrameContainer = container;
        Component.registerComponent(textbox, (OdfElement)boxElement);
        textbox.getStyleHandler().setBorders(null, StyleTypeDefinitions.CellBordersType.NONE);
        textbox.getStyleHandler().setStroke(StyleTypeDefinitions.OdfDrawStroke.NONE, null, null, null);
        textbox.getStyleHandler().setBackgroundColor(null);
        return textbox;
    }

    public void setTextContent(String content) {
        this.clearContent();
        this.addParagraph(content);
    }

    public void clearContent() {
        NodeList nodeList = this.mTextboxElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) {
                if (node.getNodeType() != 3) continue;
            }
            this.mTextboxElement.removeChild(nodeList.item(i));
        }
    }

    public String getTextContent() {
        return TextExtractor.getText((OdfElement)this.mTextboxElement);
    }

    public DrawTextBoxElement getOdfElement() {
        return this.mTextboxElement;
    }

    @Override
    public List addList() {
        return this.getListContainerImpl().addList();
    }

    @Override
    public List addList(ListDecorator decorator) {
        return this.getListContainerImpl().addList(decorator);
    }

    @Override
    public void clearList() {
        this.getListContainerImpl().clearList();
    }

    @Override
    public OdfElement getListContainerElement() {
        return this.getListContainerImpl().getListContainerElement();
    }

    @Override
    public Iterator<List> getListIterator() {
        return this.getListContainerImpl().getListIterator();
    }

    @Override
    public boolean removeList(List list) {
        return this.getListContainerImpl().removeList(list);
    }

    private ListContainerImpl getListContainerImpl() {
        if (this.listContainerImpl == null) {
            this.listContainerImpl = new ListContainerImpl();
        }
        return this.listContainerImpl;
    }

    @Override
    public Paragraph addParagraph(String textContent) {
        return this.getParagraphContainerImpl().addParagraph(textContent);
    }

    @Override
    public OdfElement getParagraphContainerElement() {
        return this.getParagraphContainerImpl().getParagraphContainerElement();
    }

    @Override
    public boolean removeParagraph(Paragraph para) {
        return this.getParagraphContainerImpl().removeParagraph(para);
    }

    private ParagraphContainerImpl getParagraphContainerImpl() {
        if (this.paragraphContainerImpl == null) {
            this.paragraphContainerImpl = new ParagraphContainerImpl();
        }
        return this.paragraphContainerImpl;
    }

    @Override
    public Paragraph getParagraphByIndex(int index, boolean isEmptyParagraphSkipped) {
        return this.getParagraphContainerImpl().getParagraphByIndex(index, isEmptyParagraphSkipped);
    }

    @Override
    public Paragraph getParagraphByReverseIndex(int reverseIndex, boolean isEmptyParagraphSkipped) {
        return this.getParagraphContainerImpl().getParagraphByReverseIndex(reverseIndex, isEmptyParagraphSkipped);
    }

    @Override
    public Iterator<Paragraph> getParagraphIterator() {
        return this.getParagraphContainerImpl().getParagraphIterator();
    }

    private class ParagraphContainerImpl
    extends AbstractParagraphContainer {
        private ParagraphContainerImpl() {
        }

        public OdfElement getParagraphContainerElement() {
            return Textbox.this.mTextboxElement;
        }
    }

    private class ListContainerImpl
    extends AbstractListContainer {
        private ListContainerImpl() {
        }

        public OdfElement getListContainerElement() {
            return Textbox.this.mTextboxElement;
        }
    }
}

