/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.util.List;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.table.AbstractTableContainer;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.table.TableContainer;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Header
implements TableContainer {
    private StyleHeaderElement headerEle;
    private TableContainerImpl tableContainerImpl;

    public Header(StyleHeaderElement element) {
        this.headerEle = element;
    }

    public StyleHeaderElement getOdfElement() {
        return this.headerEle;
    }

    @Override
    public Table addTable() {
        Table table = this.getTableContainerImpl().addTable();
        this.updateTableToNone(table);
        return table;
    }

    @Override
    public Table addTable(int numRows, int numCols) {
        Table table = this.getTableContainerImpl().addTable(numRows, numCols);
        this.updateTableToNone(table);
        return table;
    }

    @Override
    public Table getTableByName(String name) {
        return this.getTableContainerImpl().getTableByName(name);
    }

    @Override
    public List<Table> getTableList() {
        return this.getTableContainerImpl().getTableList();
    }

    @Override
    public Table.TableBuilder getTableBuilder() {
        return this.getTableContainerImpl().getTableBuilder();
    }

    @Override
    public OdfElement getTableContainerElement() {
        return this.getTableContainerImpl().getTableContainerElement();
    }

    private TableContainer getTableContainerImpl() {
        if (this.tableContainerImpl == null) {
            this.tableContainerImpl = new TableContainerImpl();
        }
        return this.tableContainerImpl;
    }

    private void updateTableToNone(Table table) {
        OdfFileDom dom = (OdfFileDom)this.getTableContainerElement().getOwnerDocument();
        TableTableElement tableEle = table.getOdfElement();
        String stylename = tableEle.getStyleName();
        OdfOfficeAutomaticStyles styles = dom.getAutomaticStyles();
        OdfStyle tableStyle = styles.getStyle(stylename, OdfStyleFamily.Table);
        tableStyle.setProperty(StyleTablePropertiesElement.Shadow, "none");
        NodeList cells = tableEle.getElementsByTagNameNS(OdfDocumentNamespace.TABLE.getUri(), "table-cell");
        if (cells != null && cells.getLength() > 0) {
            OdfStyle cellStyleWithoutBorder = styles.newStyle(OdfStyleFamily.TableCell);
            cellStyleWithoutBorder.setProperty(StyleTableCellPropertiesElement.Border, "none");
            cellStyleWithoutBorder.setProperty(StyleTableCellPropertiesElement.Padding, "0.0382in");
            String cellStyleName = cellStyleWithoutBorder.getStyleNameAttribute();
            for (int i = 0; i < cells.getLength(); ++i) {
                TableTableCellElement cell = (TableTableCellElement)cells.item(i);
                cell.setStyleName(cellStyleName);
            }
        }
    }

    private class TableContainerImpl
    extends AbstractTableContainer {
        private TableContainerImpl() {
        }

        public OdfElement getTableContainerElement() {
            return Header.this.headerEle;
        }
    }
}

