/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.presentation;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationNotesElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.PresentationDocument;
import org.odftoolkit.simple.presentation.Notes;
import org.odftoolkit.simple.table.AbstractTableContainer;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.table.TableContainer;
import org.odftoolkit.simple.text.list.AbstractListContainer;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slide
implements ListContainer,
TableContainer {
    DrawPageElement maSlideElement;
    private ListContainerImpl listContainerImpl;
    private TableContainerImpl tableContainerImpl;

    private Slide(DrawPageElement pageElement) {
        this.maSlideElement = pageElement;
    }

    public static Slide getInstance(DrawPageElement pageElement) {
        PresentationDocument ownerDocument = (PresentationDocument)((OdfFileDom)pageElement.getOwnerDocument()).getDocument();
        return ownerDocument.getSlideBuilder().getSlideInstance(pageElement);
    }

    public DrawPageElement getOdfElement() {
        return this.maSlideElement;
    }

    public int getSlideIndex() {
        OdfFileDom contentDom = (OdfFileDom)this.maSlideElement.getOwnerDocument();
        NodeList slideNodes = contentDom.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideEle = (DrawPageElement)slideNodes.item(i);
            if (slideEle != this.maSlideElement) continue;
            return i;
        }
        return -1;
    }

    public String getSlideName() {
        String slideName = this.maSlideElement.getDrawNameAttribute();
        if (slideName == null) {
            slideName = this.makeUniqueSlideName();
            this.maSlideElement.setDrawNameAttribute(slideName);
        }
        return slideName;
    }

    public void setSlideName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("slide name is null is not accepted in the presentation document");
        }
        OdfFileDom contentDom = (OdfFileDom)this.maSlideElement.getOwnerDocument();
        NodeList slideNodes = contentDom.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideEle = (DrawPageElement)slideNodes.item(i);
            Slide slide = Slide.getInstance(slideEle);
            String slideName = slide.getSlideName();
            if (!slideName.equals(name)) continue;
            throw new IllegalArgumentException("the given slide name is already exist in the current presentation document");
        }
        this.maSlideElement.setDrawNameAttribute(name);
    }

    public Notes getNotesPage() {
        NodeList notesList = this.maSlideElement.getElementsByTagNameNS(OdfDocumentNamespace.PRESENTATION.getUri(), "notes");
        if (notesList.getLength() > 0) {
            PresentationNotesElement noteEle = (PresentationNotesElement)notesList.item(0);
            return Notes.getInstance(noteEle);
        }
        return null;
    }

    private String makeUniqueSlideName() {
        int index = this.getSlideIndex();
        String slideName = "page" + (index + 1) + "-" + String.format("a%06x", (int)(Math.random() * 1.6777215E7));
        return slideName;
    }

    @Override
    public OdfElement getListContainerElement() {
        return this.getListContainerImpl().getListContainerElement();
    }

    @Override
    public org.odftoolkit.simple.text.list.List addList() {
        return this.getListContainerImpl().addList();
    }

    @Override
    public org.odftoolkit.simple.text.list.List addList(ListDecorator decorator) {
        return this.getListContainerImpl().addList(decorator);
    }

    @Override
    public void clearList() {
        this.getListContainerImpl().clearList();
    }

    @Override
    public Iterator<org.odftoolkit.simple.text.list.List> getListIterator() {
        return this.getListContainerImpl().getListIterator();
    }

    @Override
    public boolean removeList(org.odftoolkit.simple.text.list.List list) {
        return this.getListContainerImpl().removeList(list);
    }

    private ListContainerImpl getListContainerImpl() {
        if (this.listContainerImpl == null) {
            this.listContainerImpl = new ListContainerImpl();
        }
        return this.listContainerImpl;
    }

    @Override
    public Table addTable() {
        return this.getTableContainerImpl().addTable();
    }

    @Override
    public Table addTable(int numRows, int numCols) {
        return this.getTableContainerImpl().addTable(numRows, numCols);
    }

    @Override
    public Table getTableByName(String name) {
        return this.getTableContainerImpl().getTableByName(name);
    }

    @Override
    public List<Table> getTableList() {
        return this.getTableContainerImpl().getTableList();
    }

    @Override
    public Table.TableBuilder getTableBuilder() {
        return this.getTableContainerImpl().getTableBuilder();
    }

    @Override
    public OdfElement getTableContainerElement() {
        return this.getTableContainerImpl().getTableContainerElement();
    }

    protected TableContainer getTableContainerImpl() {
        if (this.tableContainerImpl == null) {
            this.tableContainerImpl = new TableContainerImpl();
        }
        return this.tableContainerImpl;
    }

    private class TableContainerImpl
    extends AbstractTableContainer {
        private TableContainerImpl() {
        }

        public OdfElement getTableContainerElement() {
            DrawFrameElement frame = null;
            NodeList frameList = Slide.this.maSlideElement.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "frame");
            if (frameList.getLength() > 0) {
                String presentationClass;
                for (int index = frameList.getLength() - 1; index >= 0 && (presentationClass = (frame = (DrawFrameElement)frameList.item(index)).getPresentationClassAttribute()) != null && !"table".equals(presentationClass); --index) {
                    frame = null;
                }
            }
            if (frame == null) {
                frame = Slide.this.maSlideElement.newDrawFrameElement();
                frame.setPresentationClassAttribute("table");
                frame.setDrawLayerAttribute("layout");
                frame.setStyleName("standard");
                frame.setSvgHeightAttribute("1.945cm");
                frame.setSvgWidthAttribute("14.098cm");
                frame.setSvgXAttribute("6.922cm");
                frame.setSvgYAttribute("10.386cm");
            }
            return frame;
        }
    }

    private class ListContainerImpl
    extends AbstractListContainer {
        private ListContainerImpl() {
        }

        public OdfElement getListContainerElement() {
            DrawFrameElement frame = null;
            DrawTextBoxElement textBox = null;
            NodeList frameList = Slide.this.maSlideElement.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "frame");
            if (frameList.getLength() > 0) {
                String presentationClass;
                for (int index = frameList.getLength() - 1; !(index < 0 || (presentationClass = (frame = (DrawFrameElement)frameList.item(index)).getPresentationClassAttribute()) == null || "outline".equals(presentationClass) || "text".equals(presentationClass) || "subtitle".equals(presentationClass)); --index) {
                    frame = null;
                }
            }
            if (frame == null) {
                throw new UnsupportedOperationException("There is no list container in this slide, please chose a proper slide layout.");
            }
            NodeList textBoxList = frame.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "text-box");
            textBox = textBoxList.getLength() <= 0 ? frame.newDrawTextBoxElement() : (DrawTextBoxElement)textBoxList.item(textBoxList.getLength() - 1);
            return textBox;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SlideLayout {
        BLANK("blank"),
        TITLE_ONLY("title_only"),
        TITLE_OUTLINE("title_outline"),
        TITLE_PLUS_TEXT("title_text"),
        TITLE_PLUS_2_TEXT_BLOCK("title_two_text_block");

        private String mValue;

        private SlideLayout(String aValue) {
            this.mValue = aValue;
        }

        public String toString() {
            return this.mValue;
        }

        public static String toString(SlideLayout aEnum) {
            return aEnum.toString();
        }

        public static SlideLayout enumValueOf(String aString) {
            for (SlideLayout aIter : SlideLayout.values()) {
                if (!aString.equals(aIter.toString())) continue;
                return aIter;
            }
            return null;
        }
    }

    public static class SlideBuilder {
        private final IdentityHashMap<DrawPageElement, Slide> maSlideRepository = new IdentityHashMap();

        public SlideBuilder(PresentationDocument doc) {
            if (doc.getSlideBuilder() != null) {
                throw new IllegalStateException("SlideBuilder only can be created in owner PresentationDocument constructor.");
            }
        }

        public synchronized Slide getSlideInstance(DrawPageElement pageElement) {
            if (this.maSlideRepository.containsKey(pageElement)) {
                return this.maSlideRepository.get(pageElement);
            }
            Slide newSlide = new Slide(pageElement);
            this.maSlideRepository.put(pageElement, newSlide);
            return newSlide;
        }
    }
}

