/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationClassAttribute;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageThumbnailElement;
import org.odftoolkit.odfdom.dom.element.office.OfficePresentationElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationNotesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StylePresentationPageLayoutElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.presentation.Notes;
import org.odftoolkit.simple.presentation.Slide;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationDocument
extends Document {
    private static final String EMPTY_PRESENTATION_DOCUMENT_PATH = "/OdfPresentationDocument.odp";
    static final OdfPackageDocument.Resource EMPTY_PRESENTATION_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfPresentationDocument.odp");
    private final Slide.SlideBuilder slideBuilder = new Slide.SlideBuilder(this);
    private final Notes.NotesBuilder notesBuilder = new Notes.NotesBuilder(this);
    private boolean hasCheckSlideName = false;

    public static PresentationDocument newPresentationDocument() throws Exception {
        return (PresentationDocument)Document.loadTemplate(EMPTY_PRESENTATION_DOCUMENT_RESOURCE, Document.OdfMediaType.PRESENTATION);
    }

    public static PresentationDocument newPresentationTemplateDocument() throws Exception {
        PresentationDocument doc = (PresentationDocument)Document.loadTemplate(EMPTY_PRESENTATION_DOCUMENT_RESOURCE, Document.OdfMediaType.PRESENTATION_TEMPLATE);
        doc.changeMode(OdfMediaType.PRESENTATION_TEMPLATE);
        return doc;
    }

    protected PresentationDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    public static PresentationDocument loadDocument(InputStream inputStream) throws Exception {
        return (PresentationDocument)Document.loadDocument(inputStream);
    }

    public static PresentationDocument loadDocument(String documentPath) throws Exception {
        return (PresentationDocument)Document.loadDocument(documentPath);
    }

    public static PresentationDocument loadDocument(File file) throws Exception {
        return (PresentationDocument)Document.loadDocument(file);
    }

    public OfficePresentationElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficePresentationElement.class);
    }

    public void changeMode(OdfMediaType type) {
        this.setOdfMediaType(type.mMediaType);
    }

    public Slide.SlideBuilder getSlideBuilder() {
        return this.slideBuilder;
    }

    public Notes.NotesBuilder getNotesBuilder() {
        return this.notesBuilder;
    }

    public Slide getSlideByIndex(int index) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        if (index >= slideNodes.getLength() || index < 0) {
            return null;
        }
        DrawPageElement slideElement = (DrawPageElement)slideNodes.item(index);
        return Slide.getInstance(slideElement);
    }

    public int getSlideCount() {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return 0;
        }
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        return slideNodes.getLength();
    }

    public Slide getSlideByName(String name) {
        this.checkAllSlideName();
        if (name == null) {
            return null;
        }
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideElement = (DrawPageElement)slideNodes.item(i);
            Slide slide = Slide.getInstance(slideElement);
            String slideName = slide.getSlideName();
            if (!slideName.equals(name)) continue;
            return slide;
        }
        return null;
    }

    private void checkAllSlideName() {
        if (this.hasCheckSlideName) {
            return;
        }
        ArrayList<String> slideNameList = new ArrayList<String>();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return;
        }
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideElement = (DrawPageElement)slideNodes.item(i);
            String slideName = slideElement.getDrawNameAttribute();
            if (slideName == null || slideNameList.contains(slideName)) {
                slideName = "page" + (i + 1) + "-" + this.makeUniqueName();
                slideElement.setDrawNameAttribute(slideName);
            }
            slideNameList.add(slideName);
        }
        this.hasCheckSlideName = true;
    }

    public Iterator<Slide> getSlides() {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        ArrayList<Slide> slideList = new ArrayList<Slide>();
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideElement = (DrawPageElement)slideNodes.item(i);
            slideList.add(Slide.getInstance(slideElement));
        }
        return slideList.iterator();
    }

    public boolean deleteSlideByIndex(int index) {
        boolean success = true;
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            success = false;
            return success;
        }
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        if (index >= slideNodes.getLength() || index < 0) {
            throw new IndexOutOfBoundsException("the specified Index is out of slide count when call deleteSlideByIndex method.");
        }
        DrawPageElement slideElement = (DrawPageElement)slideNodes.item(index);
        contentRoot.removeChild((Node)slideElement);
        this.adjustNotePageNumber(index);
        return success &= this.removeElementLinkedResource((OdfElement)slideElement);
    }

    public boolean deleteSlideByName(String name) {
        boolean success = true;
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            success = false;
            return success;
        }
        Slide slide = this.getSlideByName(name);
        DrawPageElement slideElement = slide.getOdfElement();
        success &= this.deleteLinkedRef((OdfElement)slideElement);
        contentRoot.removeChild((Node)slideElement);
        this.adjustNotePageNumber(0);
        return success &= this.deleteStyleRef((OdfElement)slideElement);
    }

    public Slide copySlide(int source, int dest, String newName) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        NodeList slideList = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        int slideCount = slideList.getLength();
        if (source < 0 || source >= slideCount || dest < 0 || dest > slideCount) {
            throw new IndexOutOfBoundsException("the specified Index is out of slide count when call copySlide method.");
        }
        DrawPageElement sourceSlideElement = (DrawPageElement)slideList.item(source);
        DrawPageElement cloneSlideElement = (DrawPageElement)sourceSlideElement.cloneNode(true);
        cloneSlideElement.setDrawNameAttribute(newName);
        if (dest == slideCount) {
            contentRoot.appendChild((Node)cloneSlideElement);
        } else {
            DrawPageElement refSlide = (DrawPageElement)slideList.item(dest);
            contentRoot.insertBefore((Node)cloneSlideElement, (Node)refSlide);
        }
        this.adjustNotePageNumber(Math.min(source, dest));
        this.hasCheckSlideName = false;
        this.checkAllSlideName();
        return Slide.getInstance(cloneSlideElement);
    }

    public void moveSlide(int source, int dest) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return;
        }
        NodeList slideList = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        int slideCount = slideList.getLength();
        if (source < 0 || source >= slideCount || dest < 0 || dest > slideCount) {
            throw new IndexOutOfBoundsException("the specified Index is out of slide count when call moveSlide method.");
        }
        DrawPageElement sourceSlide = (DrawPageElement)slideList.item(source);
        if (dest == slideCount) {
            contentRoot.appendChild((Node)sourceSlide);
        } else {
            DrawPageElement refSlide = (DrawPageElement)slideList.item(dest);
            contentRoot.insertBefore((Node)sourceSlide, (Node)refSlide);
        }
        this.adjustNotePageNumber(Math.min(source, dest));
    }

    private Node cloneForeignElement_(Node element, OdfFileDom dom, boolean deep) {
        this.checkAllSlideName();
        return this.cloneForeignElement(element, dom, deep);
    }

    public void appendPresentation(PresentationDocument srcDoc) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        OdfContentDom contentDom = null;
        OfficePresentationElement srcContentRoot = null;
        try {
            contentRoot = this.getContentRoot();
            contentDom = this.getContentDom();
            srcContentRoot = srcDoc.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
        }
        NodeList slideList = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        int slideNum = slideList.getLength();
        OfficePresentationElement srcCloneContentRoot = (OfficePresentationElement)srcContentRoot.cloneNode(true);
        this.copyLinkedRefInBatch((OdfElement)srcCloneContentRoot, srcDoc);
        this.copyForeignStyleRef((OdfElement)srcCloneContentRoot, srcDoc);
        for (Node child = srcCloneContentRoot.getFirstChild(); child != null; child = child.getNextSibling()) {
            Node cloneElement = this.cloneForeignElement_(child, (OdfFileDom)contentDom, true);
            contentRoot.appendChild(cloneElement);
        }
        this.adjustNotePageNumber(slideNum - 1);
        this.hasCheckSlideName = false;
        this.checkAllSlideName();
    }

    public Slide copyForeignSlide(int destIndex, PresentationDocument srcDoc, int srcIndex) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        OdfContentDom contentDom = null;
        try {
            contentRoot = this.getContentRoot();
            contentDom = this.getContentDom();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        NodeList slideList = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        int slideCount = slideList.getLength();
        if (destIndex < 0 || destIndex > slideCount) {
            throw new IndexOutOfBoundsException("the specified Index is out of slide count when call copyForeignSlide method.");
        }
        Slide sourceSlide = srcDoc.getSlideByIndex(srcIndex);
        DrawPageElement sourceSlideElement = sourceSlide.getOdfElement();
        DrawPageElement sourceCloneSlideElement = (DrawPageElement)sourceSlideElement.cloneNode(true);
        this.copyLinkedRefInBatch((OdfElement)sourceCloneSlideElement, srcDoc);
        this.copyForeignStyleRef((OdfElement)sourceCloneSlideElement, srcDoc);
        DrawPageElement cloneSlideElement = (DrawPageElement)this.cloneForeignElement_((Node)sourceCloneSlideElement, (OdfFileDom)contentDom, true);
        if (destIndex == slideCount) {
            contentRoot.appendChild((Node)cloneSlideElement);
        } else {
            DrawPageElement refSlide = (DrawPageElement)slideList.item(destIndex);
            contentRoot.insertBefore((Node)cloneSlideElement, (Node)refSlide);
        }
        this.adjustNotePageNumber(destIndex);
        this.hasCheckSlideName = false;
        this.checkAllSlideName();
        return Slide.getInstance(cloneSlideElement);
    }

    public Slide newSlide(int index, String name, Slide.SlideLayout slideLayout) {
        String pageLayoutName;
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        NodeList slideList = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        int slideCount = slideList.getLength();
        if (index < 0 || index > slideCount) {
            throw new IndexOutOfBoundsException("the specified Index is out of slide count when call newSlide method.");
        }
        DrawPageElement refStyleSlide = null;
        int refSlideIndex = 0;
        if (index > 0) {
            refSlideIndex = index - 1;
        }
        refStyleSlide = (DrawPageElement)slideList.item(refSlideIndex);
        String masterPageStyleName = "Default";
        String masterName = refStyleSlide.getDrawMasterPageNameAttribute();
        if (masterName != null) {
            masterPageStyleName = masterName;
        }
        DrawPageElement newSlideElement = contentRoot.newDrawPageElement(masterPageStyleName);
        newSlideElement.setDrawNameAttribute(name);
        String drawStyleName = refStyleSlide.getDrawStyleNameAttribute();
        if (drawStyleName != null) {
            newSlideElement.setDrawStyleNameAttribute(drawStyleName);
        }
        if ((pageLayoutName = refStyleSlide.getPresentationPresentationPageLayoutNameAttribute()) != null) {
            newSlideElement.setPresentationPresentationPageLayoutNameAttribute(pageLayoutName);
        }
        this.setSlideLayout(newSlideElement, slideLayout);
        NodeList noteNodes = refStyleSlide.getElementsByTagNameNS(OdfDocumentNamespace.PRESENTATION.getUri(), "notes");
        if (noteNodes.getLength() > 0) {
            PresentationNotesElement notePage = (PresentationNotesElement)noteNodes.item(0);
            PresentationNotesElement cloneNotePage = (PresentationNotesElement)notePage.cloneNode(true);
            newSlideElement.appendChild((Node)cloneNotePage);
        }
        if (index < slideCount) {
            DrawPageElement refSlide = (DrawPageElement)slideList.item(index);
            contentRoot.insertBefore((Node)newSlideElement, (Node)refSlide);
        }
        this.adjustNotePageNumber(index);
        this.hasCheckSlideName = false;
        this.checkAllSlideName();
        return Slide.getInstance(newSlideElement);
    }

    private void adjustNotePageNumber(int startIndex) {
        try {
            OfficePresentationElement contentRoot = this.getContentRoot();
            NodeList slideList = contentRoot.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
            for (int i = startIndex; i < this.getSlideCount(); ++i) {
                PresentationNotesElement notePage;
                NodeList thumbnailList;
                DrawPageElement page = (DrawPageElement)slideList.item(i);
                NodeList noteNodes = page.getElementsByTagNameNS(OdfDocumentNamespace.PRESENTATION.getUri(), "notes");
                if (noteNodes.getLength() <= 0 || (thumbnailList = (notePage = (PresentationNotesElement)noteNodes.item(0)).getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page-thumbnail")).getLength() <= 0) continue;
                DrawPageThumbnailElement thumbnail = (DrawPageThumbnailElement)thumbnailList.item(0);
                thumbnail.setDrawPageNumberAttribute(Integer.valueOf(i + 1));
            }
        }
        catch (Exception e) {
            Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void setSlideLayout(DrawPageElement page, Slide.SlideLayout slideLayout) {
        if (slideLayout == null) {
            slideLayout = Slide.SlideLayout.BLANK;
        }
        OdfOfficeStyles styles = this.getOrCreateDocumentStyles();
        if (slideLayout.toString().equals(Slide.SlideLayout.TITLE_ONLY.toString())) {
            String layoutName = "AL1T" + this.makeUniqueName();
            try {
                StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                layout.newPresentationPlaceholderElement("title", "2.058cm", "1.743cm", "23.91cm", "3.507cm");
            }
            catch (Exception e1) {
                Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e1);
            }
            page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
            DrawFrameElement frame1 = page.newDrawFrameElement();
            frame1.setProperty(StyleGraphicPropertiesElement.StyleShadow, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
            frame1.setDrawLayerAttribute("layout");
            frame1.setSvgHeightAttribute("3.006cm");
            frame1.setSvgWidthAttribute("24.299cm");
            frame1.setSvgXAttribute("1.35cm");
            frame1.setSvgYAttribute("0.717cm");
            frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
            frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
            frame1.newDrawTextBoxElement();
        } else if (slideLayout.toString().equals(Slide.SlideLayout.TITLE_OUTLINE.toString())) {
            String layoutName = this.makeUniqueName();
            try {
                styles = super.getStylesDom().getOfficeStyles();
                if (styles == null) {
                    styles = (OdfOfficeStyles)super.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                }
                StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                layout.newPresentationPlaceholderElement("title", "2.058cm", "1.743cm", "23.91cm", "3.507cm");
                layout.newPresentationPlaceholderElement("outline", "2.058cm", "1.743cm", "23.91cm", "3.507cm");
            }
            catch (Exception e1) {
                Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e1);
            }
            page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
            DrawFrameElement frame1 = page.newDrawFrameElement();
            frame1.setProperty(StyleGraphicPropertiesElement.StyleShadow, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
            frame1.setDrawLayerAttribute("layout");
            frame1.setSvgHeightAttribute("3.006cm");
            frame1.setSvgWidthAttribute("24.299cm");
            frame1.setSvgXAttribute("1.35cm");
            frame1.setSvgYAttribute("0.717cm");
            frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
            frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
            frame1.newDrawTextBoxElement();
            DrawFrameElement frame2 = page.newDrawFrameElement();
            frame2.setProperty(StyleGraphicPropertiesElement.FillColor, "#ffffff");
            frame2.setProperty(StyleGraphicPropertiesElement.MinHeight, "13.114");
            frame2.setPresentationStyleNameAttribute(frame2.getStyleName());
            frame2.setDrawLayerAttribute("layout");
            frame2.setSvgHeightAttribute("11.629cm");
            frame2.setSvgWidthAttribute("24.199cm");
            frame2.setSvgXAttribute("1.35cm");
            frame2.setSvgYAttribute("4.337cm");
            frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
            frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
            frame2.newDrawTextBoxElement();
        } else if (slideLayout.toString().equals(Slide.SlideLayout.TITLE_PLUS_TEXT.toString())) {
            String layoutName = this.makeUniqueName();
            try {
                styles = super.getStylesDom().getOfficeStyles();
                if (styles == null) {
                    styles = (OdfOfficeStyles)super.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                }
                StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                layout.newPresentationPlaceholderElement("title", "2.058cm", "1.743cm", "23.91cm", "1.743cm");
                layout.newPresentationPlaceholderElement("subtitle", "2.058cm", "5.838cm", "23.91cm", "13.23cm");
            }
            catch (Exception e1) {
                Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e1);
            }
            page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
            DrawFrameElement frame1 = page.newDrawFrameElement();
            frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
            frame1.setDrawLayerAttribute("layout");
            frame1.setSvgHeightAttribute("3.006cm");
            frame1.setSvgWidthAttribute("24.299cm");
            frame1.setSvgXAttribute("1.35cm");
            frame1.setSvgYAttribute("0.717cm");
            frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
            frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
            frame1.newDrawTextBoxElement();
            DrawFrameElement frame2 = page.newDrawFrameElement();
            frame2.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame2.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame2.setPresentationStyleNameAttribute(frame2.getStyleName());
            frame2.setDrawLayerAttribute("layout");
            frame2.setSvgHeightAttribute("11.88cm");
            frame2.setSvgWidthAttribute("24.299cm");
            frame2.setSvgXAttribute("1.35cm");
            frame2.setSvgYAttribute("4.712cm");
            frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.SUBTITLE.toString());
            frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
            frame2.newDrawTextBoxElement();
        } else if (slideLayout.toString().equals(Slide.SlideLayout.TITLE_PLUS_2_TEXT_BLOCK.toString())) {
            String layoutName = this.makeUniqueName();
            try {
                styles = super.getStylesDom().getOfficeStyles();
                if (styles == null) {
                    styles = (OdfOfficeStyles)super.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                }
                StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                layout.newPresentationPlaceholderElement("outline", "2.058cm", "1.743cm", "23.91cm", "1.743cm");
                layout.newPresentationPlaceholderElement("outline", "1.35cm", "4.212cm", "11.857cm", "11.629cm");
                layout.newPresentationPlaceholderElement("outline", "4.212cm", "13.8cm", "11.857cm", "11.629cm");
            }
            catch (Exception e1) {
                Logger.getLogger(PresentationDocument.class.getName()).log(Level.SEVERE, null, e1);
            }
            DrawFrameElement frame1 = page.newDrawFrameElement();
            frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
            frame1.setDrawLayerAttribute("layout");
            frame1.setSvgHeightAttribute("3.006cm");
            frame1.setSvgWidthAttribute("24.299cm");
            frame1.setSvgXAttribute("1.35cm");
            frame1.setSvgYAttribute("0.717cm");
            frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
            frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
            frame1.newDrawTextBoxElement();
            DrawFrameElement frame2 = page.newDrawFrameElement();
            frame2.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame2.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame2.setPresentationStyleNameAttribute(frame2.getStyleName());
            frame2.setDrawLayerAttribute("layout");
            frame2.setSvgHeightAttribute("11.629cm");
            frame2.setSvgWidthAttribute("11.857cm");
            frame2.setSvgXAttribute("1.35cm");
            frame2.setSvgYAttribute("4.212cm");
            frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
            frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
            frame2.newDrawTextBoxElement();
            DrawFrameElement frame3 = page.newDrawFrameElement();
            frame3.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame3.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame3.setPresentationStyleNameAttribute(frame3.getStyleName());
            frame3.setDrawLayerAttribute("layout");
            frame3.setSvgHeightAttribute("11.62cm");
            frame3.setSvgWidthAttribute("11.857cm");
            frame3.setSvgXAttribute("13.8cm");
            frame3.setSvgYAttribute("4.212cm");
            frame3.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
            frame3.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
            frame3.newDrawTextBoxElement();
            page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
        }
    }

    @Override
    public OdfElement getTableContainerElement() {
        throw new UnsupportedOperationException("Presentation document is not supported to hold table directly.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        PRESENTATION(Document.OdfMediaType.PRESENTATION),
        PRESENTATION_TEMPLATE(Document.OdfMediaType.PRESENTATION_TEMPLATE);

        private final Document.OdfMediaType mMediaType;

        private OdfMediaType(Document.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        public Document.OdfMediaType getOdfMediaType() {
            return this.mMediaType;
        }

        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static Document.OdfMediaType getOdfMediaType(String mediaType) {
            return Document.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

