/*
 * Decompiled with CFR 0.152.
 */
package schema2template.example.odf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import schema2template.model.QNameValue;
import schema2template.model.QNamed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfModel {
    Map<String, List<String>> mNameToFamiliesMap;
    Map<String, AttributeDefaults> mNameToDefaultsMap;

    public OdfModel(Map<String, List<String>> nameToFamiliesMap, Map<String, AttributeDefaults> attributeDefaults) {
        this.mNameToFamiliesMap = nameToFamiliesMap;
        this.mNameToDefaultsMap = attributeDefaults;
    }

    public boolean isStylable(QNamed element) {
        return this.mNameToFamiliesMap.containsKey(element.getQName());
    }

    public List<QNamed> getStyleFamilies(QNamed element) {
        ArrayList<QNamed> retval = new ArrayList<QNamed>();
        for (String family : this.mNameToFamiliesMap.get(element.getQName())) {
            retval.add(new QNameValue(family));
        }
        return retval;
    }

    public SortedSet<QNamed> getStyleFamilies() {
        Iterator<List<String>> iter = this.mNameToFamiliesMap.values().iterator();
        ArrayList<QNameValue> families = new ArrayList<QNameValue>();
        while (iter.hasNext()) {
            for (String family : iter.next()) {
                families.add(new QNameValue(family));
            }
        }
        return new TreeSet<QNamed>(families);
    }

    public String getDefaultAttributeValue(QNamed attribute, QNamed parentelement) {
        AttributeDefaults defaults = this.mNameToDefaultsMap.get(attribute.getQName());
        if (defaults == null) {
            return null;
        }
        return defaults.getDefault(parentelement.getQName());
    }

    public Set<String> getDefaultAttributeValues(QNamed attribute) {
        AttributeDefaults defaults = this.mNameToDefaultsMap.get(attribute.getQName());
        if (defaults == null) {
            return null;
        }
        return defaults.getDefaults();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttributeDefaults {
        private Map<String, String> elementDefault = new HashMap<String, String>();

        AttributeDefaults() {
        }

        public void addDefault(String defaultvalue) {
            this.addDefault(null, defaultvalue);
        }

        public void addDefault(String elementname, String defaultvalue) {
            this.elementDefault.put(elementname, defaultvalue);
        }

        public String getDefault() {
            return this.getDefault(null);
        }

        public String getDefault(String elementname) {
            String retval = this.elementDefault.get(elementname);
            if (retval == null && elementname != null) {
                retval = this.elementDefault.get(null);
            }
            return retval;
        }

        public Set<String> getDefaults() {
            HashSet<String> defaults = new HashSet<String>();
            for (String elementname : this.elementDefault.keySet()) {
                String retval = this.elementDefault.get(elementname);
                if (retval == null) continue;
                defaults.add(retval);
            }
            return defaults;
        }
    }
}

