/*
 * Decompiled with CFR 0.152.
 */
package schema2template.example.odf;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import schema2template.example.odf.OdfModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OdfConfigFileHandler
extends DefaultHandler {
    private boolean inConfig = false;
    private boolean inElements = false;
    private boolean inElement = false;
    private boolean inDatatypes = false;
    private boolean inData = false;
    private boolean inAttributes = false;
    private boolean inAttribute = false;
    private Locator mLocator;
    private Map<String, String> mElementBaseNames;
    private Map<String, List<String>> mElementStyleFamilies;
    private Set<String> mProcessedElements;
    private Map<String, String[]> mDatatypeValueConversion;
    private Map<String, OdfModel.AttributeDefaults> mAttributeDefaultMap;
    private Set<String> mProcessedDatatypes;

    public OdfConfigFileHandler(Map<String, String> elementBaseNames, Map<String, OdfModel.AttributeDefaults> attributeDefaultMap, Map<String, List<String>> elementStyleFamilies, Map<String, String[]> datatypeValueConversion) {
        this.mElementBaseNames = elementBaseNames;
        this.mAttributeDefaultMap = attributeDefaultMap;
        this.mDatatypeValueConversion = datatypeValueConversion;
        this.mElementStyleFamilies = elementStyleFamilies;
        this.mProcessedElements = new HashSet<String>();
        this.mProcessedDatatypes = new HashSet<String>();
    }

    private void createElementConfig(Attributes attrs) throws SAXException {
        String commaSeparatedStyleFamilies;
        String name = attrs.getValue("name");
        if (name == null) {
            throw new SAXException("Invalid element line " + this.mLocator.getLineNumber());
        }
        if (this.mProcessedElements.contains(name)) {
            throw new SAXException("Multiple definition of element in line " + this.mLocator.getLineNumber());
        }
        this.mProcessedElements.add(name);
        String base = attrs.getValue("base");
        if (base != null && base.length() > 0) {
            this.mElementBaseNames.put(name, base);
        }
        if ((commaSeparatedStyleFamilies = attrs.getValue("family")) != null) {
            StringTokenizer tok = new StringTokenizer(commaSeparatedStyleFamilies, ",");
            ArrayList<String> families = new ArrayList<String>();
            while (tok.hasMoreElements()) {
                String family = tok.nextToken();
                if (family.length() <= 0) continue;
                families.add(family);
            }
            if (families.size() > 0) {
                this.mElementStyleFamilies.put(name, families);
            }
        }
    }

    private void createDatatypeConfig(Attributes attrs) throws SAXException {
        String name = attrs.getValue("name");
        if (name == null) {
            throw new SAXException("Invalid datatype line " + this.mLocator.getLineNumber());
        }
        if (this.mProcessedDatatypes.contains(name)) {
            throw new SAXException("Multiple definition of datatype in line " + this.mLocator.getLineNumber());
        }
        this.mProcessedDatatypes.add(name);
        String[] tuple = new String[]{attrs.getValue("value-type"), attrs.getValue("conversion-type")};
        this.mDatatypeValueConversion.put(name, tuple);
    }

    private void createAttributeConfig(Attributes attrs) throws SAXException {
        String name = attrs.getValue("name");
        if (name == null) {
            throw new SAXException("Invalid attribute line " + this.mLocator.getLineNumber());
        }
        String elementname = attrs.getValue("element");
        String defaultvalue = attrs.getValue("defaultValue");
        OdfModel.AttributeDefaults defaults = this.mAttributeDefaultMap.get(name);
        if (defaults == null) {
            defaults = new OdfModel.AttributeDefaults();
            this.mAttributeDefaultMap.put(name, defaults);
        }
        defaults.addDefault(elementname, defaultvalue);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("config") && !this.inConfig) {
            this.inConfig = true;
            return;
        }
        if (qName.equals("elements") && this.inConfig && !this.inElements) {
            this.inElements = true;
            return;
        }
        if (qName.equals("element") && this.inElements && !this.inElement) {
            this.inElement = true;
            this.createElementConfig(attributes);
            return;
        }
        if (qName.equals("attributes") && this.inConfig && !this.inAttributes) {
            this.inAttributes = true;
            return;
        }
        if (qName.equals("attribute") && this.inAttributes && !this.inAttribute) {
            this.inAttribute = true;
            this.createAttributeConfig(attributes);
            return;
        }
        if (qName.equals("data-types") && this.inConfig && !this.inDatatypes) {
            this.inDatatypes = true;
            return;
        }
        if (qName.equals("data") && this.inDatatypes && !this.inData) {
            this.inData = true;
            this.createDatatypeConfig(attributes);
            return;
        }
        throw new SAXException("Malformed config.xml in line " + this.mLocator.getLineNumber());
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("config") && this.inConfig) {
            this.inConfig = false;
            return;
        }
        if (qName.equals("elements") && this.inElements) {
            this.inElements = false;
            return;
        }
        if (qName.equals("element") && this.inElement) {
            this.inElement = false;
            return;
        }
        if (qName.equals("attributes") && this.inAttributes) {
            this.inAttributes = false;
            return;
        }
        if (qName.equals("attribute") && this.inAttribute) {
            this.inAttribute = false;
            return;
        }
        if (qName.equals("data-types") && this.inDatatypes) {
            this.inDatatypes = false;
            return;
        }
        if (qName.equals("data") && this.inData) {
            this.inData = false;
            return;
        }
        throw new SAXException("Malformed config.xml in line " + this.mLocator.getLineNumber());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
    }

    public static void readConfigFile(File cf, Map<String, String> elementBaseNames, Map<String, OdfModel.AttributeDefaults> attributeDefaults, Map<String, List<String>> elementStyleFamilies, Map<String, String[]> datatypeValueConversion) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(cf, (DefaultHandler)new OdfConfigFileHandler(elementBaseNames, attributeDefaults, elementStyleFamilies, datatypeValueConversion));
    }
}

