/*
 * Decompiled with CFR 0.152.
 */
package schema2template.template;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import schema2template.grammar.PuzzleComponent;
import schema2template.grammar.PuzzlePiece;
import schema2template.grammar.PuzzlePieceSet;
import schema2template.grammar.XMLModel;
import schema2template.template.SourceCodeBaseClass;

public class SourceCodeModel {
    Map<String, String> mElementSuperClassNameMap;
    Map<String, String> mElementNameBaseNameMap;
    Map<String, String> mBaseNameElementNameMap;
    Map<String, SourceCodeBaseClass> mElementBaseMap;
    SortedSet<SourceCodeBaseClass> mBaseClasses;
    Map<String, SourceCodeBaseClass> mBaseNameToBaseClass;
    Map<String, String[]> mDataTypeValueAndConversionMap;

    public SourceCodeModel(XMLModel schemaModel, Map<String, String> elementNameBaseNameMap, Map<String, String> elementSuperClassNameMap, Map<String, String[]> datatypeValueAndConversionMap) {
        this.mDataTypeValueAndConversionMap = datatypeValueAndConversionMap;
        this.mElementSuperClassNameMap = elementSuperClassNameMap;
        this.mElementNameBaseNameMap = elementNameBaseNameMap;
        this.mBaseNameElementNameMap = SourceCodeModel.invertMap(elementNameBaseNameMap);
        TreeSet<String> baseNames = new TreeSet<String>(elementNameBaseNameMap.values());
        HashMap<String, SortedSet> baseNameElementsMap = new HashMap<String, SortedSet>(baseNames.size());
        for (Map.Entry<String, String> entry : elementNameBaseNameMap.entrySet()) {
            String elementName = entry.getKey();
            String baseName = entry.getValue();
            SortedSet elements = baseNameElementsMap.computeIfAbsent(baseName, k -> new TreeSet());
            PuzzleComponent childElement = schemaModel.getElement(elementName);
            if (childElement != null) {
                if (childElement instanceof PuzzlePieceSet) {
                    elements.addAll((PuzzlePieceSet)childElement);
                    continue;
                }
                elements.add((PuzzlePiece)childElement);
                continue;
            }
            System.err.println("Warning: BaseClass definition for unknown element " + elementName);
        }
        this.mBaseNameToBaseClass = new HashMap<String, SourceCodeBaseClass>(baseNames.size());
        this.mBaseClasses = new TreeSet<SourceCodeBaseClass>();
        for (String baseName : baseNames) {
            SourceCodeBaseClass javabaseclass = new SourceCodeBaseClass(baseName, (SortedSet)baseNameElementsMap.get(baseName));
            this.mBaseClasses.add(javabaseclass);
            this.mBaseNameToBaseClass.put(baseName, javabaseclass);
        }
        this.mElementBaseMap = new HashMap<String, SourceCodeBaseClass>(elementNameBaseNameMap.size());
        for (Map.Entry<String, String> entry : elementNameBaseNameMap.entrySet()) {
            String baseName = entry.getValue();
            SourceCodeBaseClass baseclass = this.mBaseNameToBaseClass.get(baseName);
            this.mElementBaseMap.put(entry.getKey(), baseclass);
        }
    }

    public String getBaseName(String elementName) {
        String b = null;
        if (this.mElementNameBaseNameMap != null) {
            b = this.mElementNameBaseNameMap.get(elementName);
        }
        return b;
    }

    public String getBaseChild(String childName) {
        String b = null;
        if (this.mBaseNameElementNameMap != null) {
            b = this.mBaseNameElementNameMap.get(childName);
        }
        return b;
    }

    private static <V, K> Map<V, K> invertMap(Map<K, V> map) {
        HashMap<V, K> inversedMap = null;
        if (map != null && !map.isEmpty()) {
            inversedMap = new HashMap<V, K>();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (inversedMap.containsKey(entry.getKey())) continue;
                inversedMap.put(entry.getValue(), entry.getKey());
            }
        }
        return inversedMap;
    }

    public SourceCodeBaseClass getBaseClassOf(PuzzleComponent childElement) {
        SourceCodeBaseClass c = null;
        if (childElement != null && this.mElementBaseMap.containsKey(childElement.getQName())) {
            c = this.mElementBaseMap.get(childElement.getQName());
        }
        return c;
    }

    public SortedSet<SourceCodeBaseClass> getBaseClasses() {
        return this.mBaseClasses;
    }

    public SourceCodeBaseClass getBaseClass(String baseName) {
        return this.mBaseNameToBaseClass.get(baseName);
    }

    public SourceCodeBaseClass getBaseClass(PuzzleComponent base) {
        return this.getBaseClass(base.getQName());
    }

    public String getValuetype(PuzzleComponent datatype) {
        String datatypename = datatype.getQName();
        String[] tuple = this.mDataTypeValueAndConversionMap.get(datatypename);
        if (tuple == null) {
            return "";
        }
        String retval = tuple[0];
        return retval == null ? "" : retval;
    }

    public boolean hasSuperClass(String childName) {
        boolean hasSuperClassName = false;
        if (this.mElementSuperClassNameMap != null && childName != null) {
            hasSuperClassName = this.mElementSuperClassNameMap.containsKey(childName);
        }
        return hasSuperClassName;
    }

    public String getSuperClass(String childName) {
        String superClassName = null;
        if (this.mElementSuperClassNameMap != null && childName != null) {
            superClassName = this.mElementSuperClassNameMap.get(childName);
        }
        return superClassName;
    }

    public String getSuperClassName(String childName) {
        String superClassName = null;
        if (this.mElementSuperClassNameMap != null && childName != null && (superClassName = this.mElementSuperClassNameMap.get(childName)) != null && superClassName.contains(".")) {
            superClassName = superClassName.substring(superClassName.lastIndexOf(".") + 1, superClassName.length());
        }
        return superClassName;
    }

    public String getSuperClassPackageName(String childName) {
        String superClassName = null;
        if (this.mElementSuperClassNameMap != null && childName != null && (superClassName = this.mElementSuperClassNameMap.get(childName)) != null && superClassName.contains(".")) {
            superClassName = superClassName.substring(0, superClassName.lastIndexOf("."));
        }
        return superClassName;
    }

    public SortedSet<String> getValuetypes(PuzzleComponent datatypes) {
        if (datatypes == null) {
            return null;
        }
        TreeSet<String> retval = new TreeSet<String>();
        for (PuzzlePiece datatype : datatypes.getCollection()) {
            String valuetype;
            String datatypename = datatype.getQName();
            String[] tuple = this.mDataTypeValueAndConversionMap.get(datatypename);
            if (tuple == null || (valuetype = tuple[0]) == null) continue;
            retval.add(valuetype);
        }
        return retval;
    }

    public String getPrimitiveType(String objectType) {
        if (objectType.equals("Boolean")) {
            return "boolean";
        }
        if (objectType.equals("Integer")) {
            return "int";
        }
        if (objectType.equals("Double")) {
            return "double";
        }
        return null;
    }

    public String getConversiontype(PuzzleComponent datatype) {
        String datatypename = datatype.getQName();
        String[] tuple = this.mDataTypeValueAndConversionMap.get(datatypename);
        if (tuple == null) {
            return "";
        }
        String retval = tuple[1];
        return retval == null ? "" : retval;
    }

    public String getConversiontype(String datatypename) {
        String[] tuple = this.mDataTypeValueAndConversionMap.get(datatypename);
        if (tuple == null) {
            return "";
        }
        String retval = tuple[1];
        return retval == null ? "" : retval;
    }
}

