/*
 * Decompiled with CFR 0.152.
 */
package schema2template.example.odf;

import com.sun.msv.grammar.Expression;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import schema2template.OutputFileListEntry;
import schema2template.OutputFileListHandler;
import schema2template.example.odf.OdfConfigFileHandler;
import schema2template.example.odf.OdfModel;
import schema2template.example.odf.SourceCodeModel;
import schema2template.model.XMLModel;

public class OdfHelper {
    private static final Logger LOG = Logger.getLogger(OdfHelper.class.getName());
    public static final Boolean DEBUG = Boolean.FALSE;
    public static final int ODF11_ELEMENT_NUMBER = 525;
    public static final int ODF12_ELEMENT_NUMBER = 598;
    public static final int ODF11_ATTRIBUTE_NUMBER = 1162;
    public static final int ODF12_ATTRIBUTE_NUMBER = 1300;
    public static final String TEST_INPUT_ROOT_ODF = "target" + File.separator + "classes" + File.separator + "examples" + File.separator + "odf";
    public static final String ODF10_RNG_FILE = TEST_INPUT_ROOT_ODF + File.separator + "odf-schemas" + File.separator + "OpenDocument-strict-schema-v1.0-os.rng";
    public static String odf11RngFile = TEST_INPUT_ROOT_ODF + File.separator + "odf-schemas" + File.separator + "OpenDocument-strict-schema-v1.1.rng";
    public static String odf12RngFile = TEST_INPUT_ROOT_ODF + File.separator + "odf-schemas" + File.separator + "OpenDocument-v1.2-os-schema.rng";
    public static String odf12SignatureRngFile = TEST_INPUT_ROOT_ODF + File.separator + "odf-schemas" + File.separator + "OpenDocument-v1.2-os-dsig-schema.rng";
    public static String odf12ManifestRngFile = TEST_INPUT_ROOT_ODF + File.separator + "odf-schemas" + File.separator + "OpenDocument-v1.2-os-manifest-schema.rng";
    public static String mConfigFile = TEST_INPUT_ROOT_ODF + File.separator + "config.xml";
    public static final String TEST_REFERENCE_DIR = "target" + File.separator + "test-classes" + File.separator + "examples" + File.separator + "odf";
    private static final String REFERENCE_OUTPUT_FILES_TEMPLATE = "ref-output-file.vm";
    private static final String REFERENCE_OUTPUT_FILES = TEST_INPUT_ROOT_ODF + File.separator + "odf-reference" + File.separator + "reference-output-files.xml";
    private static String odfDomResourceDir = TEST_INPUT_ROOT_ODF + File.separator + "odfdom-java" + File.separator + "dom";
    private static String odfPkgResourceDir = TEST_INPUT_ROOT_ODF + File.separator + "odfdom-java" + File.separator + "pkg";
    private static final String ODF_PYTHON_RESOURCE_DIR = TEST_INPUT_ROOT_ODF + File.separator + "odfdom-python";
    private static final String DOM_OUTPUT_FILES_TEMPLATE = "dom-output-files.vm";
    private static final String PKG_OUTPUT_FILES_TEMPLATE = "pkg-output-files.vm";
    private static final String PYTHON_OUTPUT_FILES_TEMPLATE = "dom-output-files.vm";
    private static final String DOM_OUTPUT_FILES = "target" + File.separator + "dom-output-files.xml";
    private static final String PKG_OUTPUT_FILES = "target" + File.separator + "pkg-output-files.xml";
    private static final String PYTHON_OUTPUT_FILES = "target" + File.separator + "python-output-files.xml";
    private static String outputRoot = "target";
    private static final String ODF_REFERENCE_RESOURCE_DIR = TEST_INPUT_ROOT_ODF + File.separator + "odf-reference";
    private static XMLModel mOdf12SignatureSchemaModel;
    private static XMLModel mOdf12ManifestSchemaModel;
    private static XMLModel mOdf12SchemaModel;
    private static XMLModel mOdf11SchemaModel;
    private static OdfModel mOdfModel;
    private static SourceCodeModel mJavaModelOdf;

    public OdfHelper() {
    }

    public OdfHelper(String domResourceRoot, String odf12SchemaFile, String odf11SchemaFile, String pkgResourceRoot, String odf12SignatureSchemaFile, String odf12ManifestSchemaFile, String targetRoot, String configFile) {
        odfDomResourceDir = domResourceRoot;
        odfPkgResourceDir = pkgResourceRoot;
        odf11RngFile = odf11SchemaFile;
        odf12RngFile = odf12SchemaFile;
        odf12SignatureRngFile = odf12SignatureSchemaFile;
        odf12ManifestRngFile = odf12ManifestSchemaFile;
        outputRoot = targetRoot;
        mConfigFile = configFile;
    }

    public static void main(String[] args) throws Exception {
        LOG.info("Starting code generation:");
        LOG.info("Starting initialization..");
        HashMap<String, String> elementToBaseNameMap = new HashMap<String, String>();
        HashMap<String, List<String>> elementStyleFamiliesMap = new HashMap<String, List<String>>();
        HashMap<String, String[]> datatypeValueAndConversionMap = new HashMap<String, String[]>();
        HashMap<String, OdfModel.AttributeDefaults> attributeDefaultMap = new HashMap<String, OdfModel.AttributeDefaults>();
        OdfConfigFileHandler.readConfigFile(new File(mConfigFile), elementToBaseNameMap, attributeDefaultMap, elementStyleFamiliesMap, datatypeValueAndConversionMap);
        mOdf12ManifestSchemaModel = new XMLModel(new File(odf12ManifestRngFile));
        mOdf12SchemaModel = new XMLModel(new File(odf12RngFile));
        mOdfModel = new OdfModel(elementStyleFamiliesMap, attributeDefaultMap);
        mJavaModelOdf = new SourceCodeModel(mOdf12SchemaModel, mOdf12SignatureSchemaModel, mOdf12ManifestSchemaModel, mOdfModel, elementToBaseNameMap, datatypeValueAndConversionMap);
        LOG.info("Finished initialization..");
        OdfHelper.fillTemplates(ODF_REFERENCE_RESOURCE_DIR, OdfHelper.mOdf12SchemaModel.mRootExpression, REFERENCE_OUTPUT_FILES_TEMPLATE, REFERENCE_OUTPUT_FILES);
        OdfHelper.fillTemplates(ODF_PYTHON_RESOURCE_DIR, OdfHelper.mOdf12SchemaModel.mRootExpression, "dom-output-files.vm", PYTHON_OUTPUT_FILES);
    }

    private static void fillTemplates(String sourceDir, Expression root, String outputRuleTemplate, String outputRuleFile) throws Exception {
        Properties props = new Properties();
        props.setProperty("file.resource.loader.path", sourceDir);
        VelocityEngine ve = new VelocityEngine(props);
        ve.init();
        OdfHelper.createOutputFileList(ve, outputRuleTemplate, outputRuleFile);
        LOG.info("output-files.xml created done.");
        LOG.fine("Processing output files... ");
        OdfHelper.processFileList(ve, root, outputRuleFile);
        LOG.fine("DONE.\n");
    }

    private static void createOutputFileList(VelocityEngine ve, String template, String output) throws Exception {
        VelocityContext context = OdfHelper.getOdfContext(null, null);
        File parentPatch = new File(output).getParentFile();
        if (!parentPatch.exists()) {
            parentPatch.mkdirs();
        }
        FileWriter listout = new FileWriter(new File(output));
        String encoding = "utf-8";
        ve.mergeTemplate(template, encoding, (Context)context, (Writer)listout);
        listout.close();
    }

    public static void processFileList(VelocityEngine ve, Expression root, String outputRuleFile) throws Exception {
        File outputFiles = new File(outputRuleFile);
        List<OutputFileListEntry> fl = OutputFileListHandler.readFileListFile(outputFiles);
        for (OutputFileListEntry f : fl) {
            switch (f.getType()) {
                case PATH: {
                    break;
                }
                case FILE: {
                    LOG.log(Level.INFO, "Processing line{0}: Generating file {1}\n", new Object[]{f.getLineNumber(), OdfHelper.generateFilename(f.getAttribute("path"))});
                    String odfContextStr = f.getAttribute("context");
                    String param = f.getAttribute("param");
                    VelocityContext context = OdfHelper.getOdfContext(odfContextStr, param);
                    if (context == null) {
                        throw new RuntimeException("Error in output-files.xml, line " + f.getLineNumber() + ": no or invalid odf-scope");
                    }
                    File out = new File(outputRoot + File.separator + OdfHelper.generateFilename(f.getAttribute("path"))).getCanonicalFile();
                    OdfHelper.ensureParentFolders(out);
                    FileWriter fileout = new FileWriter(out);
                    String encoding = "utf-8";
                    ve.mergeTemplate(f.getAttribute("template"), encoding, (Context)context, (Writer)fileout);
                    fileout.close();
                }
            }
        }
    }

    private static VelocityContext getOdfContext(String contextStr, String param) {
        VelocityContext context = new VelocityContext();
        context.put("signaturemodel", (Object)mOdf12SignatureSchemaModel);
        context.put("manifestmodel", (Object)mOdf12ManifestSchemaModel);
        context.put("model", (Object)mOdf12SchemaModel);
        context.put("oldmodel", (Object)mOdf11SchemaModel);
        context.put("odfmodel", (Object)mOdfModel);
        context.put("javamodel", (Object)mJavaModelOdf);
        context.put("context", (Object)contextStr);
        context.put("param", (Object)param);
        return context;
    }

    public static Expression loadSchemaODF10() throws Exception {
        return XMLModel.loadSchema(new File(ODF10_RNG_FILE));
    }

    public static Expression loadSchemaODF11() throws Exception {
        return XMLModel.loadSchema(new File(odf11RngFile));
    }

    public static Expression loadSchemaODF12() throws Exception {
        return XMLModel.loadSchema(new File(odf12RngFile));
    }

    private static String generateFilename(String rawName) {
        String retFilePath = null;
        StringTokenizer toktok = new StringTokenizer(rawName.replaceAll(":", "_"), "/");
        if (toktok.hasMoreTokens()) {
            File retfile = null;
            retfile = new File(toktok.nextToken());
            while (toktok.hasMoreTokens()) {
                retfile = new File(retfile, toktok.nextToken());
            }
            retFilePath = retfile.getPath();
        }
        return retFilePath;
    }

    private static void ensureParentFolders(File newFile) {
        File parent = newFile.getParentFile();
        if (parent != null && !parent.exists()) {
            try {
                parent.mkdirs();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not create parent directory {0}", parent.getAbsolutePath());
            }
        }
    }
}

