/*
 * Decompiled with CFR 0.152.
 */
package schema2template;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import schema2template.OutputFileListEntry;

public class OutputFileListHandler
extends DefaultHandler {
    List<OutputFileListEntry> mFilelist;
    boolean mOpenFlTag = false;
    boolean mOpenFileTag = false;
    boolean mOpenPathTag = false;
    Locator mLocator;

    OutputFileListHandler(List<OutputFileListEntry> fl) {
        this.mFilelist = fl;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("filelist") && !this.mOpenFlTag) {
            this.mOpenFlTag = true;
            return;
        }
        if (qName.equals("file") && this.mOpenFlTag && !this.mOpenFileTag && !this.mOpenPathTag) {
            this.mOpenFileTag = true;
            OutputFileListEntry entry = new OutputFileListEntry(OutputFileListEntry.EntryType.FILE, this.mLocator.getLineNumber());
            String mandatoryPath = attributes.getValue("path");
            if (mandatoryPath == null) {
                throw new SAXException("Mandatory attribute path is missing for file element in line " + this.mLocator.getLineNumber() + ".");
            }
            entry.setAttribute("path", mandatoryPath);
            entry.setAttribute("context", attributes.getValue("context"));
            entry.setAttribute("param", attributes.getValue("param"));
            entry.setAttribute("template", attributes.getValue("template"));
            this.mFilelist.add(entry);
            return;
        }
        if (qName.equals("path") && this.mOpenFlTag && !this.mOpenFileTag && !this.mOpenPathTag) {
            this.mOpenPathTag = true;
            OutputFileListEntry entry = new OutputFileListEntry(OutputFileListEntry.EntryType.PATH, this.mLocator.getLineNumber());
            String mandatoryPath = attributes.getValue("path");
            if (mandatoryPath == null) {
                throw new SAXException("Mandatory attribute path is missing for path element in line " + this.mLocator.getLineNumber() + ".");
            }
            entry.setAttribute("path", mandatoryPath);
            entry.setAttribute("path", mandatoryPath);
            this.mFilelist.add(entry);
            return;
        }
        throw new SAXException("Malformed filelist");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("filelist") && this.mOpenFlTag && !this.mOpenFileTag && !this.mOpenPathTag) {
            this.mOpenFlTag = false;
            return;
        }
        if (qName.equals("file") && this.mOpenFlTag && this.mOpenFileTag && !this.mOpenPathTag) {
            this.mOpenFileTag = false;
            return;
        }
        if (qName.equals("path") && this.mOpenFlTag && this.mOpenPathTag && !this.mOpenFileTag) {
            this.mOpenPathTag = false;
            return;
        }
        throw new SAXException("Malformed filelist");
    }

    public static List<OutputFileListEntry> readFileListFile(File flf) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        ArrayList<OutputFileListEntry> retval = new ArrayList<OutputFileListEntry>();
        parser.parse(flf, (DefaultHandler)new OutputFileListHandler(retval));
        return retval;
    }
}

