/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.schema2template_maven_plugin;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import schema2template.example.odf.OdfCodegen;

public class CodegenMojo
extends AbstractMojo {
    File resourceRoot;
    String odf12SchemaFile;
    String odf11SchemaFile;
    String configFile;
    File targetRoot;
    MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)"Schema2template code generation.");
            if (this.configFile == null) {
                this.getLog().error((CharSequence)"Please set configure file patch.");
                throw new MojoFailureException("Please set configure file patch.");
            }
            if (this.odf12SchemaFile == null) {
                this.getLog().error((CharSequence)"Please set odf1.2 schema file patch.");
                throw new MojoFailureException("Please set schema file patch.");
            }
            if (this.odf11SchemaFile == null) {
                this.getLog().error((CharSequence)"Please set odf1.1 schema file patch.");
                throw new MojoFailureException("Please set schema file patch.");
            }
            String targetRootPath = this.targetRoot.getAbsolutePath();
            if (targetRootPath == null) {
                this.getLog().error((CharSequence)"Please set generation code root patch.");
                throw new MojoFailureException("Please set generation code root patch.");
            }
            String resourceRootPath = this.resourceRoot.getAbsolutePath();
            if (resourceRootPath == null) {
                this.getLog().error((CharSequence)"Please set templates root patch.");
                throw new MojoFailureException("Please set templates root patch.");
            }
            this.getLog().debug((CharSequence)("Template Files Directory " + resourceRootPath));
            this.getLog().debug((CharSequence)("Generation Code Files Root Directory " + targetRootPath));
            this.getLog().debug((CharSequence)("ODF1.2 Schema File " + this.odf12SchemaFile));
            this.getLog().debug((CharSequence)("ODF1.1 Schema File " + this.odf11SchemaFile));
            this.getLog().debug((CharSequence)("Config File " + this.configFile));
            OdfCodegen codeGen = new OdfCodegen(resourceRootPath, targetRootPath, this.odf12SchemaFile, this.odf11SchemaFile, this.configFile);
            codeGen.start();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Failed to parse template.");
            this.getLog().error((Throwable)ex);
            String msg = "Failed to execute ODF schema2template example";
            throw new MojoFailureException((Object)ex, msg, msg);
        }
    }
}

