/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.text.TextTrackChangesAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element text:tracked-changes}.
 *
 */
public class TextTrackedChangesElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TEXT, "tracked-changes" );


	/**
	 * Create the instance of <code>TextTrackedChangesElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TextTrackedChangesElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element text:tracked-changes}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}



	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextTrackChangesAttribute</code> , See {@odf.attribute text:track-changes}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextTrackChangesAttribute()
	{
		TextTrackChangesAttribute attr = (TextTrackChangesAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "track-changes" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return Boolean.valueOf( TextTrackChangesAttribute.DEFAULT_VALUE );
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextTrackChangesAttribute</code> , See {@odf.attribute text:track-changes}
	 *
	 * @param textTrackChangesValue   The type is <code>Boolean</code>
	 */
	public void setTextTrackChangesAttribute( Boolean textTrackChangesValue )
	{
		TextTrackChangesAttribute attr =  new TextTrackChangesAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( textTrackChangesValue.booleanValue() );
	}

	/**
	 * Create child element {@odf.element text:changed-region}.
	 *
	 * @return   return  the element {@odf.element text:changed-region}
	 * DifferentQName 
	 */
	public TextChangedRegionElement newTextChangedRegionElement()
	{
		TextChangedRegionElement  textChangedRegion = ((OdfFileDom)this.ownerDocument).newOdfElement(TextChangedRegionElement.class);
		this.appendChild( textChangedRegion);
		return  textChangedRegion;
	}                   
               
}
