/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfContainerElementBase;

import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHandoutMasterElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawLayerSetElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableTemplateElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element office:master-styles}.
 *
 */
public class OfficeMasterStylesElement extends OdfContainerElementBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.OFFICE, "master-styles" );


	/**
	 * Create the instance of <code>OfficeMasterStylesElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public OfficeMasterStylesElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element office:master-styles}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}


	/**
	 * Create child element {@odf.element style:master-page}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @param stylePageLayoutNameAttributeValue  the <code>String</code> value of <code>StylePageLayoutNameAttribute</code>, see {@odf.attribute  style:page-layout-name} at specification
	 * @return   return  the element {@odf.element style:master-page}
	 * DifferentQName 
	 */
    
	public StyleMasterPageElement newStyleMasterPageElement(String styleNameAttributeValue, String stylePageLayoutNameAttributeValue)
	{
		StyleMasterPageElement  styleMasterPage = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleMasterPageElement.class);
		styleMasterPage.setStyleNameAttribute( styleNameAttributeValue );
		styleMasterPage.setStylePageLayoutNameAttribute( stylePageLayoutNameAttributeValue );
		this.appendChild( styleMasterPage);
		return  styleMasterPage;      
	}
    
	/**
	 * Create child element {@odf.element style:handout-master}.
	 *
     * @param stylePageLayoutNameAttributeValue  the <code>String</code> value of <code>StylePageLayoutNameAttribute</code>, see {@odf.attribute  style:page-layout-name} at specification
	 * @return   return  the element {@odf.element style:handout-master}
	 * DifferentQName 
	 */
    
	public StyleHandoutMasterElement newStyleHandoutMasterElement(String stylePageLayoutNameAttributeValue)
	{
		StyleHandoutMasterElement  styleHandoutMaster = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleHandoutMasterElement.class);
		styleHandoutMaster.setStylePageLayoutNameAttribute( stylePageLayoutNameAttributeValue );
		this.appendChild( styleHandoutMaster);
		return  styleHandoutMaster;      
	}
    
	/**
	 * Create child element {@odf.element draw:layer-set}.
	 *
	 * @return   return  the element {@odf.element draw:layer-set}
	 * DifferentQName 
	 */
	public DrawLayerSetElement newDrawLayerSetElement()
	{
		DrawLayerSetElement  drawLayerSet = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawLayerSetElement.class);
		this.appendChild( drawLayerSet);
		return  drawLayerSet;
	}                   
               
	/**
	 * Create child element {@odf.element table:table-template}.
	 *
     * @param tableFirstRowEndColumnAttributeValue  the <code>String</code> value of <code>TableFirstRowEndColumnAttribute</code>, see {@odf.attribute  table:first-row-end-column} at specification
	 * @param tableFirstRowStartColumnAttributeValue  the <code>String</code> value of <code>TableFirstRowStartColumnAttribute</code>, see {@odf.attribute  table:first-row-start-column} at specification
	 * @param tableLastRowEndColumnAttributeValue  the <code>String</code> value of <code>TableLastRowEndColumnAttribute</code>, see {@odf.attribute  table:last-row-end-column} at specification
	 * @param tableLastRowStartColumnAttributeValue  the <code>String</code> value of <code>TableLastRowStartColumnAttribute</code>, see {@odf.attribute  table:last-row-start-column} at specification
	 * @param tableNameAttributeValue  the <code>String</code> value of <code>TableNameAttribute</code>, see {@odf.attribute  table:name} at specification
	 * @return   return  the element {@odf.element table:table-template}
	 * DifferentQName 
	 */
    
	public TableTableTemplateElement newTableTableTemplateElement(String tableFirstRowEndColumnAttributeValue, String tableFirstRowStartColumnAttributeValue, String tableLastRowEndColumnAttributeValue, String tableLastRowStartColumnAttributeValue, String tableNameAttributeValue)
	{
		TableTableTemplateElement  tableTableTemplate = ((OdfFileDom)this.ownerDocument).newOdfElement(TableTableTemplateElement.class);
		tableTableTemplate.setTableFirstRowEndColumnAttribute( tableFirstRowEndColumnAttributeValue );
		tableTableTemplate.setTableFirstRowStartColumnAttribute( tableFirstRowStartColumnAttributeValue );
		tableTableTemplate.setTableLastRowEndColumnAttribute( tableLastRowEndColumnAttributeValue );
		tableTableTemplate.setTableLastRowStartColumnAttribute( tableLastRowStartColumnAttributeValue );
		tableTableTemplate.setTableNameAttribute( tableNameAttributeValue );
		this.appendChild( tableTableTemplate);
		return  tableTableTemplate;      
	}
    
}
