/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 * Copyright 2009 IBM. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.w3c.dom.DOMException;

/** This factory determines what elements are being used in the DOC layer
 * (ie. the convenient layer).
 *
 *  The mapping of ODF element to convenient class can be changed from the user
 *  during run time.
 *
 *  For example, a user might want to create a table always with a certain style or default data and
 *  might want to overwrite the mapping for <code>{odf.element table:table}</code>, that a different
 *  class instead of <code>OdfTable</code> is being used.
 * 
 */
public class OdfXMLFactory {

	private static Map<OdfName, Class> mElementTypes = new HashMap<OdfName, Class>();
	private static Map<OdfName, Class> mAttributeTypes = new HashMap<OdfName, Class>();
	private static Map<String, String> mElementRenames = new HashMap<String, String>();
	private static final String LOCAL_NAME_DELIMITER = "-";
	private static final String ELEMENT_PACKAGE_NAME = "element";
	private static final String ATTRIBUTE_PACKAGE_NAME = "attribute";

	static {
		mElementRenames.put("draw:a", "draw:hyperlink");
		mElementRenames.put("draw:g", "draw:group");
		mElementRenames.put("text:h", "text:heading");
		mElementRenames.put("text:p", "text:paragraph");
		mElementRenames.put("text:s", "text:space");
		mElementRenames.put("text:a", "text:hyperlink");
	}

	/** Mapping an ODF element to a new Java DOM element class.
	 *  Note: There is a default class for each element being generated from the latest ODF schema 
	 */
	public static void setOdfElementClass(OdfName odfName, Class className) {
		mElementTypes.put(odfName, className);
	}

	/** Mapping an ODF attribute to a new Java DOM attribute class.
	 *  Note: There is a default class for each element being generated from the latest ODF schema. */
	public static void setOdfAttributeClass(OdfName odfName, Class className) {
		mAttributeTypes.put(odfName, className);
	}

	/**
	 * @param odfName the name of the ODF attribute the desired DOM class should represent.
	 * @return the Java DOM attribute class to be mapped to a certain ODF attribute. */
	public static Class getOdfAttributeClass(OdfName odfName) {
		return getOdfNodeClass(odfName, ATTRIBUTE_PACKAGE_NAME, mAttributeTypes);
	}

	/**
	 * @param odfName the name of the ODF element the desired DOM class should represent.
	 * @return the Java DOM element class to be mapped to a certain ODF element. */
	public static Class getOdfElementClass(OdfName odfName) {
		return getOdfNodeClass(odfName, ELEMENT_PACKAGE_NAME, mElementTypes);
	}

	private static Class getOdfNodeClass(OdfName odfName, String nodeName, Map<OdfName, Class> classCache) {
		Class c = null;
		String className = "";
		c = classCache.get(odfName);
		if (c == null) {
			String prefix = odfName.getPrefix();
			if (prefix != null && !(nodeName.equals("attribute") && prefix.equals("xmlns"))) {
				String qName = odfName.getQName();
				String localName = odfName.getLocalName();
				if ((nodeName == ATTRIBUTE_PACKAGE_NAME)
						|| (prefix.equals("meta") || prefix.equals("table") || qName.equals("office:meta") || qName.equals("draw:page")
						|| qName.equals("office:presentation") || qName.equals("presentation:notes"))) {
					className = getOdfDOMNodeClassName(odfName.getPrefix(), odfName.getLocalName(), nodeName);
				} else {
					if (mElementRenames.containsKey(qName)) {
						String renameName = mElementRenames.get(qName);
						StringTokenizer stok = new StringTokenizer(renameName, ":");
						className = getOdfDOCNodeClassName(stok.nextToken(), stok.nextToken());
					} else {
						className = getOdfDOCNodeClassName(prefix, localName);
					}
				}
				try {
					c = Class.forName(className);
					classCache.put(odfName, c);
				} catch (ClassNotFoundException ex) {
					//Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.SEVERE, null, ex);
					Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.INFO, "ClassNotFoundException - not a problem for none ODF 1.2 XML node: " + className, ex.getMessage());
				} catch (NoClassDefFoundError dex) {
					Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.INFO, "NoClassDefFoundError: " + className, dex.getMessage());
				}
			}
		}
		return c;
	}

	private static String getOdfDOCNodeClassName(String prefix, String localName) {
		boolean contains = false;
		StringBuilder className = new StringBuilder();

		if (localName.indexOf(LOCAL_NAME_DELIMITER) != -1) {
			StringTokenizer stok = new StringTokenizer(localName, LOCAL_NAME_DELIMITER);
			while (stok.hasMoreElements()) {
				String substr = stok.nextToken();
				if (substr.equals(prefix)) {
					contains = true;
				}
				className = className.append(toUpperCaseFirstCharacter(substr));
			}
		} else {
			className = className.append(toUpperCaseFirstCharacter(localName));
		}
		if (!((contains && !localName.endsWith("table"))
				|| (localName.equals(prefix))
				|| (localName.startsWith(prefix) && prefix.equals("anim")))) {
			className = className.insert(0, toUpperCaseFirstCharacter(prefix));
		}
		className = className.insert(0, "org.odftoolkit.odfdom.doc." + prefix + "." + "Odf");

		return className.toString();
	}

	private static String getOdfDOMNodeClassName(String prefix, String localName, String nodeName) {
		StringBuilder className = new StringBuilder("org.odftoolkit.odfdom.dom." + nodeName + "." + prefix + ".");
		className = className.append(toUpperCaseFirstCharacter(prefix));
		if (localName.indexOf(LOCAL_NAME_DELIMITER) != -1) {
			StringTokenizer stok = new StringTokenizer(localName, LOCAL_NAME_DELIMITER);
			while (stok.hasMoreElements()) {
				className = className.append(toUpperCaseFirstCharacter(stok.nextToken()));
			}
		} else {
			className = className.append(toUpperCaseFirstCharacter(localName));
		}
		className.append(toUpperCaseFirstCharacter(nodeName));
		return className.toString();
	}

	private static String toUpperCaseFirstCharacter(String token) {
		return token.substring(0, 1).toUpperCase() + token.substring(1);
	}

	public static OdfElement newOdfElement(OdfFileDom ownerDocument, OdfName name) throws DOMException {
		OdfElement element = null;

		// lookup registered element class for qname
		Class elementClass = getOdfElementClass(name);

		// if a class was registered create an instance of that class
		if (elementClass != null) {
			element = (OdfElement) getNodeFromClass(ownerDocument, elementClass);
		} else {
			// otherwise create the default class for odf
			element = (OdfElement) new OdfAlienElement(ownerDocument, name);
		}
		return element;
	}

	public static OdfAttribute newOdfAttribute(OdfFileDom ownerDocument, OdfName name) throws DOMException {
		OdfAttribute attr = null;

		// lookup registered attribute class for qname
		Class attributeClass = getOdfAttributeClass(name);

		// if a class was registered create an instance of that class
		if (attributeClass != null) {
			attr = (OdfAttribute) getNodeFromClass(ownerDocument, attributeClass);
		} else {
			// otherwise create the default class for odf
			attr = (OdfAttribute) new OdfAlienAttribute(ownerDocument, name);
		}
		return attr;
	}

	/**
	 * @param ownerDocument the XML DOM file where the node should be created on.
	 * @param nodeClass being an XMLNode the Java class of the instance to be created.
	 * @returns an object instance of the XML node class being provided (usally an attribute or element). */
	static Object getNodeFromClass(OdfFileDom ownerDocument, Class nodeClass) {
		Object o = null;
		try {
			Constructor ctor = nodeClass.getConstructor(new Class[]{OdfFileDom.class});
			o = ctor.newInstance(new Object[]{ownerDocument});
		} catch (Exception cause) {
			// an exception at this point is a bug. Throw an Error
			throw new Error("OdfDOM error in attribute factory", cause);
		}
		return o;
	}
}
