/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import org.odftoolkit.odfdom.type.OdfDataType;

public class NonNegativeInteger
implements OdfDataType {
    private int mN;

    public NonNegativeInteger(int n) throws NumberFormatException {
        if (n < 0) {
            throw new NumberFormatException("parameter is invalid for datatype NonNegativeInteger");
        }
        this.mN = n;
    }

    public String toString() {
        return Integer.toString(this.mN);
    }

    public static NonNegativeInteger valueOf(String stringValue) throws NumberFormatException {
        String aTmp = stringValue.trim();
        int n = Integer.parseInt(aTmp);
        return new NonNegativeInteger(n);
    }

    public int intValue() {
        return this.mN;
    }

    public static boolean isValid(Integer integerValue) {
        if (integerValue == null) {
            return false;
        }
        return integerValue >= 0;
    }
}

