/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.rdfa;

import java.util.ArrayList;
import java.util.Arrays;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class MultiContentHandler
implements ContentHandler {
    ArrayList<ContentHandler> subContentHandlers;

    public MultiContentHandler(ContentHandler ... subs) {
        this.subContentHandlers = new ArrayList<ContentHandler>(Arrays.asList(subs));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        for (ContentHandler sub : this.subContentHandlers) {
            sub.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        for (ContentHandler sub : this.subContentHandlers) {
            sub.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        for (ContentHandler sub : this.subContentHandlers) {
            sub.endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        for (ContentHandler sub : this.subContentHandlers) {
            sub.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        for (ContentHandler sub : this.subContentHandlers) {
            sub.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        for (ContentHandler sub : this.subContentHandlers) {
            sub.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        for (ContentHandler sub : this.subContentHandlers) {
            sub.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        for (ContentHandler sub : this.subContentHandlers) {
            sub.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        for (ContentHandler sub : this.subContentHandlers) {
            sub.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        for (ContentHandler sub : this.subContentHandlers) {
            sub.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        for (ContentHandler sub : this.subContentHandlers) {
            sub.skippedEntity(name);
        }
    }
}

