/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class Resolver
implements EntityResolver,
URIResolver {
    private static final Logger LOG = Logger.getLogger(Resolver.class.getName());
    private final OdfPackage mPackage;

    public Resolver(OdfPackage pkg) {
        this.mPackage = pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (publicId != null && publicId.startsWith("-//OpenOffice.org//DTD Modified W3C MathML")) {
            return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
        }
        if (systemId != null) {
            if (this.mPackage.getBaseURI() != null && systemId.startsWith(this.mPackage.getBaseURI())) {
                if (systemId.equals(this.mPackage.getBaseURI())) {
                    InputStream in = null;
                    try {
                        in = this.mPackage.getInputStream();
                    }
                    catch (Exception e) {
                        throw new SAXException(e);
                    }
                    InputSource ins = new InputSource(in);
                    if (ins == null) {
                        return null;
                    }
                    ins.setSystemId(systemId);
                    return ins;
                }
                if (systemId.length() > this.mPackage.getBaseURI().length() + 1) {
                    InputStream in = null;
                    try {
                        String path = systemId.substring(this.mPackage.getBaseURI().length() + 1);
                        in = this.mPackage.getInputStream(path);
                        InputSource ins = new InputSource(in);
                        ins.setSystemId(systemId);
                        InputSource inputSource = ins;
                        return inputSource;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            LOG.log(Level.SEVERE, null, ex);
                        }
                    }
                }
                return null;
            }
            if (systemId.startsWith("resource:/")) {
                int i = systemId.indexOf(47);
                if (i > 0 && systemId.length() > i + 1) {
                    String res = systemId.substring(i + 1);
                    ClassLoader cl = OdfPackage.class.getClassLoader();
                    InputStream in = cl.getResourceAsStream(res);
                    if (in != null) {
                        InputSource ins = new InputSource(in);
                        ins.setSystemId(systemId);
                        return ins;
                    }
                }
                return null;
            }
            if (systemId.startsWith("jar:")) {
                try {
                    URL url = new URL(systemId);
                    JarURLConnection jarConn = (JarURLConnection)url.openConnection();
                    InputSource ins = new InputSource(jarConn.getInputStream());
                    ins.setSystemId(systemId);
                    return ins;
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
        return null;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        try {
            URI uri = null;
            if (base != null) {
                URI baseuri = new URI(base);
                uri = baseuri.resolve(href);
            } else {
                uri = new URI(href);
            }
            InputSource ins = null;
            try {
                ins = this.resolveEntity(null, uri.toString());
            }
            catch (Exception e) {
                throw new TransformerException(e);
            }
            if (ins == null) {
                return null;
            }
            InputStream in = ins.getByteStream();
            StreamSource src = new StreamSource(in);
            src.setSystemId(uri.toString());
            return src;
        }
        catch (URISyntaxException use) {
            return null;
        }
    }
}

