/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.xerces.dom.DOMXSImplementationSourceImpl;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.pkg.DefaultErrorHandler;
import org.odftoolkit.odfdom.pkg.OdfDecryptedException;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfPackageConstraint;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.Resolver;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.odftoolkit.odfdom.pkg.ZipHelper;
import org.odftoolkit.odfdom.pkg.manifest.AlgorithmElement;
import org.odftoolkit.odfdom.pkg.manifest.EncryptionDataElement;
import org.odftoolkit.odfdom.pkg.manifest.FileEntryElement;
import org.odftoolkit.odfdom.pkg.manifest.KeyDerivationElement;
import org.odftoolkit.odfdom.pkg.manifest.ManifestElement;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.odftoolkit.odfdom.pkg.manifest.OdfManifestDom;
import org.odftoolkit.odfdom.pkg.manifest.StartKeyGenerationElement;
import org.odftoolkit.odfdom.pkg.rdfa.Util;
import org.odftoolkit.odfdom.type.Base64Binary;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class OdfPackage
implements Closeable {
    private static final Logger LOG = Logger.getLogger(OdfPackage.class.getName());
    private static final String DOUBLE_DOT = "..";
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String ENCODED_APOSTROPHE = "&apos;";
    private static final String ENCODED_QUOTATION = "&quot;";
    private static final String EMPTY_STRING = "";
    private static final String XML_MEDIA_TYPE = "text/xml";
    private static final Pattern BACK_SLASH_PATTERN = Pattern.compile("\\\\");
    private static final Pattern DOUBLE_SLASH_PATTERN = Pattern.compile("//");
    private static final Pattern QUOTATION_PATTERN = Pattern.compile("\"");
    private static final Pattern APOSTROPHE_PATTERN = Pattern.compile("'");
    private static final Pattern CONTROL_CHAR_PATTERN = Pattern.compile("\\p{Cntrl}");
    private static final Set<String> COMPRESSED_FILETYPES = Set.of("jpg", "gif", "png", "zip", "rar", "jpeg", "mpe", "mpg", "mpeg", "mpeg4", "mp4", "7z", "ari", "arj", "jar", "gz", "tar", "war", "mov", "avi");
    private static final byte[] HREF_PATTERN = new byte[]{120, 108, 105, 110, 107, 58, 104, 114, 101, 102, 61, 34};
    private String mMediaType = null;
    private String mBaseURI;
    private ZipHelper mZipFile;
    private Resolver mResolver = null;
    private Map<String, ZipArchiveEntry> mZipEntries;
    private Map<String, ZipArchiveEntry> mOriginalZipEntries;
    private Map<String, OdfFileEntry> mManifestEntries;
    private Map<String, OdfPackageDocument> mPkgDocuments;
    private int mTransientMarkupId = 0;
    private Map<String, Document> mPkgDoms;
    private Map<String, byte[]> mMemoryFileCache;
    private Map<String, Object> mConfiguration = new HashMap<String, Object>();
    private ErrorHandler mErrorHandler;
    private String mManifestVersion;
    private OdfManifestDom mManifestDom;
    private String mOldPwd;
    private String mNewPwd;
    private boolean isAES = true;

    private OdfPackage() {
        String errorHandlerProperty;
        this.mPkgDocuments = new HashMap<String, OdfPackageDocument>();
        this.mPkgDoms = new HashMap<String, Document>();
        this.mMemoryFileCache = new HashMap<String, byte[]>();
        this.mManifestEntries = new HashMap<String, OdfFileEntry>();
        if (this.mErrorHandler == null && (errorHandlerProperty = System.getProperty("org.odftoolkit.odfdom.validation")) != null) {
            if (errorHandlerProperty.equalsIgnoreCase("true")) {
                this.mErrorHandler = new DefaultErrorHandler();
                LOG.config("Activated validation with default ErrorHandler!");
            } else if (!errorHandlerProperty.equalsIgnoreCase("false")) {
                try {
                    Class<?> cl = Class.forName(errorHandlerProperty);
                    Constructor<?> ctor = cl.getDeclaredConstructor(new Class[0]);
                    this.mErrorHandler = (ErrorHandler)ctor.newInstance(new Object[0]);
                    LOG.log(Level.CONFIG, "Activated validation with ErrorHandler:''{0}''!", errorHandlerProperty);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Could not initiate validation with the given ErrorHandler: '" + errorHandlerProperty + "'", ex);
                }
            }
        }
    }

    public void freeMemory() {
        this.mZipFile = null;
        this.mResolver = null;
        this.mZipEntries = null;
        this.mOriginalZipEntries = null;
        this.mManifestEntries = null;
        this.mPkgDocuments = null;
        this.mPkgDoms = null;
        this.mMemoryFileCache = null;
        this.mConfiguration = null;
        this.mErrorHandler = null;
    }

    private OdfPackage(File pkgFile) throws SAXException, IOException {
        this(pkgFile, OdfPackage.getBaseURLFromFile(pkgFile), null, null);
    }

    private OdfPackage(File pkgFile, String baseURI, String password, ErrorHandler errorHandler) throws SAXException, IOException {
        this();
        this.mBaseURI = OdfPackage.getBaseURLFromFile(pkgFile);
        this.mErrorHandler = errorHandler;
        this.mNewPwd = this.mOldPwd = password;
        this.mBaseURI = baseURI;
        try (FileInputStream packageStream = new FileInputStream(pkgFile);){
            this.initializeZip(packageStream);
        }
        catch (IOException ioe) {
            this.handleIOException(ioe, true);
        }
    }

    private OdfPackage(InputStream packageStream, String baseURI, String password, ErrorHandler errorHandler, Map<String, Object> configuration) throws SAXException, IOException {
        this();
        this.mErrorHandler = errorHandler;
        this.mBaseURI = baseURI;
        this.mNewPwd = this.mOldPwd = password;
        this.mConfiguration = configuration;
        this.initializeZip(packageStream);
    }

    private OdfPackage(InputStream packageStream, String baseURI, ErrorHandler errorHandler) throws SAXException, IOException {
        this();
        if (errorHandler != null) {
            this.mErrorHandler = errorHandler;
        }
        this.mBaseURI = baseURI;
        this.initializeZip(packageStream);
    }

    public static OdfPackage loadPackage(String path) throws SAXException, IOException {
        File pkgFile = new File(path);
        return new OdfPackage(pkgFile, OdfPackage.getBaseURLFromFile(pkgFile), null, null);
    }

    public static OdfPackage loadPackage(File pkgFile) throws SAXException, IOException {
        return new OdfPackage(pkgFile, OdfPackage.getBaseURLFromFile(pkgFile), null, null);
    }

    public static OdfPackage loadPackage(Path pkgFile) throws SAXException, IOException {
        return OdfPackage.loadPackage(pkgFile.toFile());
    }

    public static OdfPackage loadPackage(InputStream packageStream) throws SAXException, IOException {
        return new OdfPackage(packageStream, null, null, null, null);
    }

    public static OdfPackage loadPackage(InputStream packageStream, Map<String, Object> configuration) throws Exception {
        return new OdfPackage(packageStream, null, null, null, configuration);
    }

    public static OdfPackage loadPackage(InputStream packageStream, String baseURI, ErrorHandler errorHandler) throws SAXException, IOException {
        return new OdfPackage(packageStream, baseURI, null, errorHandler, null);
    }

    public static OdfPackage loadPackage(File pkgFile, ErrorHandler errorHandler) throws SAXException, IOException {
        return new OdfPackage(pkgFile, OdfPackage.getBaseURLFromFile(pkgFile), null, errorHandler);
    }

    public static OdfPackage loadPackage(Path pkgFile, ErrorHandler errorHandler) throws SAXException, IOException {
        return OdfPackage.loadPackage(pkgFile.toFile(), errorHandler);
    }

    public Map<String, Object> getRunTimeConfiguration() {
        return this.mConfiguration;
    }

    public static OdfPackage loadPackage(File pkgFile, String password) throws SAXException, IOException {
        return OdfPackage.loadPackage(pkgFile, password, null);
    }

    public static OdfPackage loadPackage(Path pkgFile, String password) throws SAXException, IOException {
        return OdfPackage.loadPackage(pkgFile.toFile(), password);
    }

    public static OdfPackage loadPackage(File pkgFile, String password, ErrorHandler errorHandler) throws SAXException, IOException {
        return new OdfPackage(pkgFile, OdfPackage.getBaseURLFromFile(pkgFile), password, errorHandler);
    }

    public static OdfPackage loadPackage(Path pkgFile, String password, ErrorHandler errorHandler) throws SAXException, IOException {
        return OdfPackage.loadPackage(pkgFile.toFile(), password, errorHandler);
    }

    private void initializeZip(InputStream odfStream) throws SAXException, IOException {
        byte[] mTempByteBuf;
        try (ByteArrayOutputStream tempBuf = new ByteArrayOutputStream();){
            odfStream.transferTo(tempBuf);
            mTempByteBuf = tempBuf.toByteArray();
        }
        if (mTempByteBuf.length < 4 || mTempByteBuf[0] != 80 || mTempByteBuf[1] != 75 || mTempByteBuf[2] != 3 || mTempByteBuf[3] != 4) {
            OdfValidationException ve = new OdfValidationException((ValidationConstraint)OdfPackageConstraint.PACKAGE_IS_NO_ZIP, this.getBaseURI(), new Object[0]);
            if (this.mErrorHandler != null) {
                this.mErrorHandler.fatalError(ve);
            }
            throw new IllegalArgumentException(ve);
        }
        this.mZipFile = new ZipHelper(this, mTempByteBuf);
        this.readZip();
    }

    private void readZip() throws SAXException, IOException {
        this.mZipEntries = new HashMap<String, ZipArchiveEntry>();
        String firstEntryName = this.mZipFile.entriesToMap(this.mZipEntries);
        if (this.mZipEntries.isEmpty()) {
            OdfValidationException ve = new OdfValidationException((ValidationConstraint)OdfPackageConstraint.PACKAGE_IS_NO_ZIP, this.getBaseURI(), new Object[0]);
            if (this.mErrorHandler != null) {
                this.mErrorHandler.fatalError(ve);
            }
            throw new IllegalArgumentException(ve);
        }
        this.parseManifest();
        this.initializeMediaType(firstEntryName);
        this.mOriginalZipEntries = new HashMap<String, ZipArchiveEntry>();
        this.mOriginalZipEntries.putAll(this.mZipEntries);
        this.mZipEntries.remove(OdfFile.MEDIA_TYPE.getPath());
        this.mZipEntries.remove(OdfFile.MANIFEST.getPath());
        this.mZipEntries.remove("META-INF/");
        if (this.mErrorHandler != null) {
            this.validateManifest();
        }
        for (String internalPath : this.mZipEntries.keySet()) {
            if (internalPath.equals(OdfFile.MANIFEST.getPath()) || internalPath.equals("META-INF/") || internalPath.equals(OdfFile.MEDIA_TYPE.getPath())) continue;
            this.ensureFileEntryExistence(internalPath);
        }
    }

    private void validateManifest() throws SAXException {
        Set<String> zipPaths = this.mZipEntries.keySet();
        Set<String> manifestPaths = this.mManifestEntries.keySet();
        HashSet<String> sharedPaths = new HashSet<String>(zipPaths);
        sharedPaths.retainAll(manifestPaths);
        if (sharedPaths.size() < zipPaths.size()) {
            HashSet<String> zipPathSuperset = new HashSet<String>(this.mZipEntries.keySet());
            zipPathSuperset.removeAll(sharedPaths);
            TreeSet<String> sortedSet = new TreeSet<String>(zipPathSuperset);
            Iterator iter = sortedSet.iterator();
            String documentURL = this.getBaseURI();
            while (iter.hasNext()) {
                String internalPath = (String)iter.next();
                if (internalPath.endsWith(SLASH) || internalPath.startsWith("META-INF/")) continue;
                this.logValidationError(OdfPackageConstraint.MANIFEST_DOES_NOT_LIST_FILE, documentURL, internalPath);
            }
        }
        if (sharedPaths.size() < manifestPaths.size()) {
            HashSet<String> zipPathSubset = new HashSet<String>(this.mManifestEntries.keySet());
            zipPathSubset.removeAll(sharedPaths);
            zipPathSubset.remove(SLASH);
            for (String manifestOnlyPath : zipPathSubset) {
                if (manifestOnlyPath.endsWith(SLASH)) {
                    this.removeDirectory(manifestOnlyPath);
                    continue;
                }
                this.logValidationError(OdfPackageConstraint.MANIFEST_LISTS_NONEXISTENT_FILE, this.getBaseURI(), manifestOnlyPath);
                OdfFileEntry manifestEntry = this.mManifestEntries.remove(manifestOnlyPath);
                FileEntryElement manifestEle = manifestEntry.getOdfElement();
                manifestEle.getParentNode().removeChild((Node)((Object)manifestEle));
            }
        }
        for (String sharedPath : sharedPaths) {
            if (!sharedPath.endsWith(SLASH)) continue;
            this.removeDirectory(sharedPath);
        }
    }

    private void removeDirectory(String path) throws SAXException {
        String dirMimeType;
        if (path.endsWith(SLASH) && ((dirMimeType = this.mManifestEntries.get(path).getMediaTypeString()) == null || EMPTY_STRING.equals(dirMimeType))) {
            this.logValidationWarning(OdfPackageConstraint.MANIFEST_LISTS_DIRECTORY, this.getBaseURI(), path);
            OdfFileEntry manifestEntry = this.mManifestEntries.remove(path);
            FileEntryElement manifestEle = manifestEntry.getOdfElement();
            manifestEle.getParentNode().removeChild((Node)((Object)manifestEle));
        }
    }

    private void initializeMediaType(String firstEntryName) throws SAXException, IOException {
        ZipArchiveEntry mimetypeEntry = this.mZipEntries.get(OdfFile.MEDIA_TYPE.getPath());
        if (mimetypeEntry != null) {
            if (this.mErrorHandler != null) {
                this.validateMimeTypeEntry(mimetypeEntry, firstEntryName);
            }
            String entryMediaType = this.getMediaTypeFromEntry(mimetypeEntry);
            String manifestMediaType = this.getMediaTypeFromManifest();
            if (entryMediaType != null && !entryMediaType.equals(EMPTY_STRING)) {
                this.mMediaType = entryMediaType;
                if (this.mErrorHandler != null) {
                    if (manifestMediaType != null && !manifestMediaType.equals(EMPTY_STRING)) {
                        if (!entryMediaType.equals(manifestMediaType)) {
                            this.logValidationError(OdfPackageConstraint.MIMETYPE_DIFFERS_FROM_PACKAGE, this.getBaseURI(), CONTROL_CHAR_PATTERN.matcher(this.mMediaType).replaceAll(EMPTY_STRING), manifestMediaType);
                        }
                    } else {
                        this.logValidationError(OdfPackageConstraint.MIMETYPE_WITHOUT_MANIFEST_MEDIATYPE, this.getBaseURI(), CONTROL_CHAR_PATTERN.matcher(this.mMediaType).replaceAll(EMPTY_STRING), manifestMediaType);
                    }
                }
            } else if (manifestMediaType != null && !manifestMediaType.equals(EMPTY_STRING)) {
                this.mMediaType = manifestMediaType;
            }
        } else {
            String manifestMediaType = this.getMediaTypeFromManifest();
            if (manifestMediaType != null && !manifestMediaType.equals(EMPTY_STRING)) {
                this.mMediaType = manifestMediaType;
            }
            if (this.mErrorHandler != null) {
                this.logValidationWarning(OdfPackageConstraint.MIMETYPE_NOT_IN_PACKAGE, this.getBaseURI(), new Object[0]);
            }
        }
    }

    private void validateMimeTypeEntry(ZipArchiveEntry mimetypeEntry, String firstEntryName) throws SAXException {
        if (mimetypeEntry.getMethod() != 0) {
            this.logValidationError(OdfPackageConstraint.MIMETYPE_IS_COMPRESSED, this.getBaseURI(), new Object[0]);
        }
        if (mimetypeEntry.getExtra() != null && mimetypeEntry.getExtra().length > 0) {
            this.logValidationError(OdfPackageConstraint.MIMETYPE_HAS_EXTRA_FIELD, this.getBaseURI(), new Object[0]);
        }
        if (!OdfFile.MEDIA_TYPE.getPath().equals(firstEntryName) || mimetypeEntry.getDataOffset() != 38L) {
            this.logValidationError(OdfPackageConstraint.MIMETYPE_NOT_FIRST_IN_PACKAGE, this.getBaseURI(), new Object[0]);
        }
    }

    private String getMediaTypeFromManifest() {
        OdfFileEntry rootDocumentEntry = this.mManifestEntries.get(SLASH);
        if (rootDocumentEntry != null) {
            return rootDocumentEntry.getMediaTypeString();
        }
        return null;
    }

    private String getMediaTypeFromEntry(ZipArchiveEntry mimetypeEntry) throws SAXException, IOException {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.mZipFile.getInputStream(mimetypeEntry).transferTo(out);
            string = new String(out.toByteArray(), 0, out.size(), "UTF-8");
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
                this.handleIOException(ex, false);
                return null;
            }
        }
        out.close();
        return string;
    }

    private void handleIOException(IOException ex, boolean warningOnly) throws SAXException, IOException {
        if (this.mErrorHandler != null) {
            SAXParseException se = new SAXParseException(ex.getMessage(), null, ex);
            try {
                if (warningOnly) {
                    this.mErrorHandler.warning(se);
                } else {
                    this.mErrorHandler.error(se);
                }
            }
            catch (SAXException e1) {
                if (e1 == se) {
                    throw ex;
                }
                throw e1;
            }
        }
        throw ex;
    }

    void cacheDocument(OdfPackageDocument doc, String internalPath) {
        if (!internalPath.isEmpty()) {
            internalPath = OdfPackage.normalizeDirectoryPath(internalPath);
            this.updateFileEntry(this.ensureFileEntryExistence(internalPath), doc.getMediaTypeString());
            this.mPkgDocuments.put(internalPath, doc);
        }
    }

    void setBaseURI(String baseURI) {
        this.mBaseURI = baseURI;
    }

    public String getBaseURI() {
        return this.mBaseURI;
    }

    public OdfPackageDocument loadDocument(String internalPath) {
        OdfPackageDocument doc = this.getCachedDocument(internalPath);
        if (doc == null) {
            String mediaTypeString = this.getMediaTypeString();
            OdfDocument.OdfMediaType odfMediaType = OdfDocument.OdfMediaType.getOdfMediaType(mediaTypeString);
            if (odfMediaType == null) {
                doc = new OdfPackageDocument(this, internalPath, mediaTypeString);
            } else {
                try {
                    String documentMediaType = this.getMediaTypeString(internalPath);
                    odfMediaType = OdfDocument.OdfMediaType.getOdfMediaType(documentMediaType);
                    if (odfMediaType == null) {
                        return null;
                    }
                    doc = OdfDocument.loadDocument(this, internalPath);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
        return doc;
    }

    @Deprecated
    public OdfPackageDocument getCachedDocument(String internalPath) {
        internalPath = OdfPackage.normalizeDirectoryPath(internalPath);
        return this.mPkgDocuments.get(internalPath);
    }

    void cacheDom(Document dom, String internalPath) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        this.insert(dom, internalPath, null);
    }

    Document getCachedDom(String internalPath) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        return this.mPkgDoms.get(internalPath);
    }

    Map<String, Document> getCachedDoms() {
        return this.mPkgDoms;
    }

    public void removeDocument(String internalPath) {
        internalPath = OdfPackage.normalizeDirectoryPath(internalPath);
        Set<String> allPackageFileNames = this.getFilePaths();
        if (internalPath.equals(SLASH)) {
            for (String entryName : allPackageFileNames) {
                this.remove(entryName);
            }
            this.remove(SLASH);
        } else {
            ArrayList<String> directoryEntryNames = new ArrayList<String>();
            for (String entryName : allPackageFileNames) {
                if (!entryName.startsWith(internalPath)) continue;
                directoryEntryNames.add(entryName);
            }
            for (String entryName : directoryEntryNames) {
                this.remove(entryName);
            }
            this.remove(internalPath);
        }
    }

    Set<String> getCachedPackageDocuments() {
        return this.mPkgDocuments.keySet();
    }

    public OdfPackageDocument getRootDocument() {
        OdfPackageDocument odfPackageDocument = null;
        odfPackageDocument = this.mPkgDocuments.get(EMPTY_STRING);
        if (odfPackageDocument == null) {
            odfPackageDocument = this.loadDocument(EMPTY_STRING);
        }
        return odfPackageDocument;
    }

    public OdfManifestDom getManifestDom() {
        return this.mManifestDom;
    }

    public String getMediaTypeString(String internalPath) {
        String mediaType = null;
        if (internalPath != null) {
            if (internalPath.equals(EMPTY_STRING) || internalPath.equals(SLASH)) {
                return this.mMediaType;
            }
            mediaType = this.getMediaTypeFromEntry(OdfPackage.normalizePath(internalPath));
            if (mediaType == null) {
                mediaType = this.getMediaTypeFromEntry(OdfPackage.normalizeDirectoryPath(internalPath));
            }
        }
        return mediaType;
    }

    private String getMediaTypeFromEntry(String internalPath) {
        OdfFileEntry entry = this.getFileEntry(internalPath);
        if (entry != null) {
            return entry.getMediaTypeString();
        }
        return null;
    }

    public String getMediaTypeString() {
        return this.mMediaType;
    }

    void setMediaTypeString(String mediaType) {
        this.mMediaType = mediaType;
    }

    public OdfFileEntry getFileEntry(String internalPath) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        return this.mManifestEntries.get(internalPath);
    }

    public Set<String> getFilePaths() {
        return this.mManifestEntries.keySet();
    }

    public boolean contains(String internalPath) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        return this.mManifestEntries.containsKey(internalPath);
    }

    public void save(String odfPath) throws SAXException, IOException {
        File f = new File(odfPath);
        this.save(f);
    }

    public void save(File pkgFile) throws SAXException, IOException {
        String baseURL = OdfPackage.getBaseURLFromFile(pkgFile);
        try (FileOutputStream fos = new FileOutputStream(pkgFile);){
            this.save(fos, baseURL);
        }
    }

    public void save(Path pkgFile) throws SAXException, IOException {
        this.save(pkgFile.toFile());
    }

    public void save(OutputStream odfStream) throws SAXException, IOException {
        this.save(odfStream, null);
    }

    public void setPassword(String password) {
        this.mNewPwd = password;
    }

    private void save(OutputStream odfStream, String baseURL) throws IOException, SAXException {
        this.mBaseURI = baseURL;
        OdfFileEntry rootEntry = this.mManifestEntries.get(SLASH);
        if (rootEntry == null) {
            rootEntry = new OdfFileEntry(this.getManifestDom().getRootElement().newFileEntryElement(SLASH, this.mMediaType));
            this.mManifestEntries.put(SLASH, rootEntry);
        } else {
            rootEntry.setMediaTypeString(this.mMediaType);
        }
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(odfStream);){
            this.mManifestEntries.remove(OdfFile.MEDIA_TYPE.getPath());
            Set<String> keys = this.mManifestEntries.keySet();
            boolean isFirstFile = true;
            CRC32 crc = new CRC32();
            long modTime = Instant.now().toEpochMilli();
            byte[] data = null;
            for (String path : keys) {
                if (isFirstFile) {
                    isFirstFile = false;
                    data = this.mMediaType.getBytes("UTF-8");
                    this.createZipEntry(OdfFile.MEDIA_TYPE.getPath(), data, zos, modTime, crc);
                }
                if (!(path.endsWith(SLASH) || path.equals(OdfFile.MANIFEST.getPath()) || path.equals(OdfFile.MEDIA_TYPE.getPath()))) {
                    data = this.getBytes(path);
                    this.createZipEntry(path, data, zos, modTime, crc);
                }
                data = null;
            }
            this.createZipEntry("META-INF/", null, zos, modTime, crc);
            data = this.getBytes(OdfFile.MANIFEST.getPath());
            this.createZipEntry(OdfFile.MANIFEST.getPath(), data, zos, modTime, crc);
            zos.flush();
        }
        odfStream.flush();
    }

    private void createZipEntry(String path, byte[] data, ZipArchiveOutputStream zos, long modTime, CRC32 crc) throws IOException {
        ZipArchiveEntry ze = this.mZipEntries.get(path);
        if (ze == null) {
            ze = new ZipArchiveEntry(path);
        }
        ze.setTime(modTime);
        if (this.fileNeedsCompression(path)) {
            ze.setMethod(8);
        } else {
            ze.setMethod(0);
        }
        crc.reset();
        if (data != null) {
            OdfFileEntry fileEntry = this.mManifestEntries.get(path);
            if (data.length > 0 && this.fileNeedsEncryption(path)) {
                data = this.encryptData(data, fileEntry);
                ze.setMethod(0);
                ze.setCompressedSize((long)data.length);
            } else {
                if (fileEntry != null) {
                    fileEntry.setSize(null);
                    FileEntryElement fileEntryEle = fileEntry.getOdfElement();
                    EncryptionDataElement encryptionDataElement = OdfElement.findFirstChildNode(EncryptionDataElement.class, (Node)((Object)fileEntryEle));
                    while (encryptionDataElement != null) {
                        fileEntryEle.removeChild((Node)((Object)encryptionDataElement));
                        encryptionDataElement = OdfElement.findFirstChildNode(EncryptionDataElement.class, (Node)((Object)fileEntryEle));
                    }
                }
                ze.setCompressedSize(-1L);
            }
            ze.setSize((long)data.length);
            crc.update(data);
            ze.setCrc(crc.getValue());
        } else {
            ze.setSize(0L);
            ze.setCrc(0L);
            ze.setCompressedSize(-1L);
        }
        zos.putArchiveEntry(ze);
        if (data != null) {
            zos.write(data, 0, data.length);
        }
        zos.closeArchiveEntry();
        this.mZipEntries.put(path, ze);
    }

    private boolean fileNeedsCompression(String internalPath) {
        String suffix;
        boolean result = true;
        if (internalPath.equals(OdfFile.MEDIA_TYPE.getPath())) {
            return false;
        }
        if (internalPath.lastIndexOf(DOT) > 0 && COMPRESSED_FILETYPES.contains((suffix = internalPath.substring(internalPath.lastIndexOf(DOT) + 1, internalPath.length())).toLowerCase())) {
            result = false;
        }
        return result;
    }

    private boolean fileNeedsEncryption(String internalPath) {
        if (this.mNewPwd != null) {
            if (internalPath.endsWith(SLASH) || OdfFile.MANIFEST.getPath().equals(internalPath) || OdfFile.MEDIA_TYPE.getPath().equals(internalPath)) {
                return false;
            }
            return this.fileNeedsCompression(internalPath);
        }
        return false;
    }

    @Override
    public void close() {
        if (this.mZipFile != null) {
            try {
                this.mZipFile.close();
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        this.mZipFile = null;
        this.mMediaType = null;
        this.mZipEntries = null;
        this.mPkgDoms = null;
        this.mMemoryFileCache = null;
        this.mManifestEntries = null;
        this.mBaseURI = null;
        this.mResolver = null;
    }

    private void parseManifest() throws SAXException, IOException {
        this.mManifestDom = (OdfManifestDom)OdfFileDom.newFileDom(this, OdfFile.MANIFEST.getPath());
        ManifestElement manifestEle = this.mManifestDom.getRootElement();
        if (manifestEle != null) {
            this.setManifestVersion(manifestEle.getVersionAttribute());
        } else {
            this.logValidationError(OdfPackageConstraint.MANIFEST_NOT_IN_PACKAGE, this.getBaseURI(), new Object[0]);
        }
        Map<String, OdfFileEntry> entries = this.getManifestEntries();
        FileEntryElement fileEntryEle = OdfElement.findFirstChildNode(FileEntryElement.class, (Node)((Object)manifestEle));
        while (fileEntryEle != null) {
            String path = fileEntryEle.getFullPathAttribute();
            if (path.equals(EMPTY_STRING)) {
                if (this.getErrorHandler() != null) {
                    this.logValidationError(OdfPackageConstraint.MANIFEST_WITH_EMPTY_PATH, this.getBaseURI(), new Object[0]);
                }
            } else {
                OdfFileEntry currentFileEntry = entries.get(path);
                if (currentFileEntry == null) {
                    currentFileEntry = new OdfFileEntry(fileEntryEle);
                }
                if (path != null) {
                    entries.put(path, currentFileEntry);
                }
            }
            fileEntryEle = OdfElement.findNextChildNode(FileEntryElement.class, (Node)((Object)fileEntryEle));
        }
        this.mMemoryFileCache.remove(OdfFile.MANIFEST.getPath());
        this.mPkgDoms.put(OdfFile.MANIFEST.getPath(), (Document)((Object)this.mManifestDom));
    }

    XMLReader getXMLReader() throws ParserConfigurationException, SAXException {
        SAXParser parser;
        SAXParserFactoryImpl saxFactory = new SAXParserFactoryImpl();
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
        try {
            saxFactory.setXIncludeAware(false);
            saxFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException();
        }
        try {
            parser = saxFactory.newSAXParser();
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce);
        }
        XMLReader xmlReader = parser.getXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return xmlReader;
    }

    private void createSubEntries(String internalPath) {
        ManifestElement manifestEle = this.getManifestDom().getRootElement();
        StringTokenizer tok = new StringTokenizer(internalPath, SLASH);
        if (tok.countTokens() > 1) {
            Object path = EMPTY_STRING;
            while (tok.hasMoreTokens()) {
                OdfFileEntry fileEntry;
                String directory = tok.nextToken();
                if (!tok.hasMoreTokens() || (fileEntry = this.mManifestEntries.get(path = (String)path + directory + SLASH)) != null) continue;
                this.mManifestEntries.put((String)path, new OdfFileEntry(manifestEle.newFileEntryElement((String)path, null)));
            }
        }
    }

    public void insert(Document fileDOM, String internalPath, String mediaType) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        if (mediaType == null) {
            mediaType = XML_MEDIA_TYPE;
        }
        if (fileDOM == null) {
            this.mPkgDoms.remove(internalPath);
        } else {
            this.mPkgDoms.put(internalPath, fileDOM);
        }
        if (!internalPath.endsWith(OdfFile.MANIFEST.internalPath)) {
            this.updateFileEntry(this.ensureFileEntryExistence(internalPath), mediaType);
        }
        this.mMemoryFileCache.remove(internalPath);
    }

    public void insertDocument(OdfPackageDocument sourceDocument, String destinationPath) {
        Map<String, OdfFileEntry> manifestEntriesToCopy;
        destinationPath = OdfPackage.normalizeDirectoryPath(destinationPath);
        this.flushDoms(sourceDocument);
        String sourceSubPath = null;
        if (sourceDocument.isRootDocument()) {
            manifestEntriesToCopy = sourceDocument.getPackage().getManifestEntries();
            sourceSubPath = EMPTY_STRING;
        } else {
            manifestEntriesToCopy = sourceDocument.getPackage().getSubDirectoryEntries(sourceDocument.getDocumentPath());
            sourceSubPath = sourceDocument.getDocumentPath();
        }
        this.addEntriesToPackageAndManifest(manifestEntriesToCopy, sourceDocument, sourceSubPath, destinationPath);
        if (!this.mManifestEntries.containsKey(destinationPath)) {
            ManifestElement manifestEle = this.mManifestDom.getRootElement();
            OdfFileEntry embedDocumentRootEntry = new OdfFileEntry(manifestEle.newFileEntryElement(destinationPath, sourceDocument.getMediaTypeString()));
            this.mManifestEntries.put(destinationPath, embedDocumentRootEntry);
        }
        sourceDocument.setPackage(this);
        this.cacheDocument(sourceDocument, destinationPath);
    }

    /*
     * WARNING - void declaration
     */
    private void addEntriesToPackageAndManifest(Map<String, OdfFileEntry> entryMapToCopy, OdfPackageDocument sourceDocument, String subDocumentPath, String destinationPath) {
        destinationPath = sourceDocument.setDocumentPath(destinationPath);
        Set<String> entryNameList = entryMapToCopy.keySet();
        for (String string : entryNameList) {
            OdfFileEntry entry = entryMapToCopy.get(string);
            if (entry == null) continue;
            try {
                void var7_11;
                String string2;
                if (!subDocumentPath.equals(EMPTY_STRING) && (string2 = string.substring(subDocumentPath.length())).length() == 0) {
                    String string3 = SLASH;
                }
                if (var7_11.endsWith(SLASH)) {
                    void var7_7;
                    if (var7_11.equals(SLASH)) {
                        this.insert((byte[])null, destinationPath, sourceDocument.getMediaTypeString());
                        continue;
                    }
                    String mediaType = sourceDocument.getMediaTypeString();
                    if (mediaType == null || mediaType.length() == 0) continue;
                    if (!destinationPath.equals(SLASH)) {
                        String string4 = destinationPath + (String)var7_11;
                    }
                    this.insert((byte[])null, (String)var7_7, entry.getMediaTypeString());
                    continue;
                }
                String documentDirectory = null;
                documentDirectory = destinationPath.equals(SLASH) ? EMPTY_STRING : destinationPath;
                String packagePath = documentDirectory + (String)var7_11;
                this.insert(sourceDocument.getPackage().getInputStream(entry.getPath()), packagePath, entry.getMediaTypeString());
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    void flushDoms(OdfPackageDocument parentDocument) {
        OdfPackage pkg = parentDocument.getPackage();
        if (parentDocument.isRootDocument()) {
            for (String xmlFilePath : pkg.getCachedDoms().keySet()) {
                pkg.insert(pkg.getCachedDom(xmlFilePath), xmlFilePath, XML_MEDIA_TYPE);
            }
        } else {
            String parentDocumentPath = parentDocument.getDocumentPath();
            for (String xmlFilePath : pkg.getCachedDoms().keySet()) {
                if (!xmlFilePath.startsWith(parentDocumentPath)) continue;
                pkg.insert(pkg.getCachedDom(xmlFilePath), xmlFilePath, XML_MEDIA_TYPE);
            }
        }
    }

    private Map<String, OdfFileEntry> getSubDirectoryEntries(String directory) {
        directory = OdfPackage.normalizeDirectoryPath(directory);
        HashMap<String, OdfFileEntry> subEntries = new HashMap<String, OdfFileEntry>();
        Map<String, OdfFileEntry> allEntries = this.getManifestEntries();
        Set<String> rootEntryNameSet = this.getFilePaths();
        for (String entryName : rootEntryNameSet) {
            if (!entryName.startsWith(directory)) continue;
            subEntries.put(entryName, allEntries.get(entryName));
        }
        return subEntries;
    }

    public Set<String> getDocumentPaths() {
        return this.getDocumentPaths(null, null);
    }

    public Set<String> getDocumentPaths(String mediaTypeString) {
        return this.getDocumentPaths(mediaTypeString, null);
    }

    Set<String> getDocumentPaths(String mediaTypeString, String subDirectory) {
        HashSet<String> innerDocuments = new HashSet<String>();
        Set<String> packageFilePaths = this.getFilePaths();
        for (String filePath : packageFilePaths) {
            String fileMediaType;
            if (subDirectory != null && (!filePath.startsWith(subDirectory) || filePath.equals(subDirectory)) || filePath.length() <= 1 || !filePath.endsWith(SLASH) || (fileMediaType = this.getFileEntry(filePath).getMediaTypeString()) == null || fileMediaType.equals(EMPTY_STRING) || mediaTypeString != null && !mediaTypeString.equals(fileMediaType)) continue;
            innerDocuments.add(filePath);
        }
        return innerDocuments;
    }

    private OdfFileEntry ensureFileEntryExistence(String internalPath) {
        OdfFileEntry fileEntry = null;
        if (!OdfFile.MANIFEST.internalPath.equals(internalPath) && !internalPath.equals(EMPTY_STRING)) {
            if (this.mManifestEntries == null) {
                this.mManifestEntries = new HashMap<String, OdfFileEntry>();
            }
            if ((fileEntry = this.mManifestEntries.get(internalPath)) == null) {
                ManifestElement manifestEle = this.getManifestDom().getRootElement();
                if (manifestEle == null) {
                    return null;
                }
                fileEntry = new OdfFileEntry(manifestEle.newFileEntryElement(internalPath, EMPTY_STRING));
                this.mManifestEntries.put(internalPath, fileEntry);
            }
        }
        return fileEntry;
    }

    private void updateFileEntry(OdfFileEntry fileEntry, String mediaType) {
        fileEntry.setMediaTypeString(mediaType);
        fileEntry.setSize(null);
    }

    public Document getDom(String internalPath) throws SAXException, ParserConfigurationException, IllegalArgumentException, TransformerConfigurationException, TransformerException, IOException {
        Document dom = this.mPkgDoms.get(internalPath);
        if (dom != null) {
            return dom;
        }
        InputStream is = this.getInputStream(internalPath);
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            factory.setXIncludeAware(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException();
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(this.getEntityResolver());
        String uri = this.getBaseURI() + internalPath;
        if (this.mErrorHandler != null) {
            builder.setErrorHandler(this.mErrorHandler);
        }
        InputSource ins = new InputSource(is);
        ins.setSystemId(uri);
        dom = builder.parse(ins);
        if (dom != null) {
            this.mPkgDoms.put(internalPath, dom);
            this.mMemoryFileCache.remove(internalPath);
        }
        return dom;
    }

    public void insert(URI sourceURI, String internalPath, String mediaType) throws Exception {
        InputStream is = null;
        is = sourceURI.isAbsolute() ? sourceURI.toURL().openStream() : new FileInputStream(sourceURI.toString());
        this.insert(is, internalPath, mediaType);
    }

    public void insert(InputStream fileStream, String internalPath, String mediaType) throws IOException {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        if (fileStream == null) {
            this.insert((byte[])null, internalPath, mediaType);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bis = null;
            bis = fileStream instanceof BufferedInputStream ? (BufferedInputStream)fileStream : new BufferedInputStream(fileStream);
            bis.transferTo(baos);
            byte[] data = baos.toByteArray();
            this.insert(data, internalPath, mediaType);
        }
    }

    public void insert(byte[] fileBytes, String internalPath, String mediaTypeString) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        if (OdfFile.MEDIA_TYPE.getPath().equals(internalPath)) {
            try {
                this.setMediaTypeString(new String(fileBytes, "UTF-8"));
            }
            catch (UnsupportedEncodingException useEx) {
                LOG.log(Level.SEVERE, "ODF file could not be created as string!", useEx);
            }
            return;
        }
        if (fileBytes != null) {
            this.mMemoryFileCache.put(internalPath, fileBytes);
            if (this.mPkgDoms.containsKey(internalPath)) {
                this.mPkgDoms.remove(internalPath);
            }
        }
        this.updateFileEntry(this.ensureFileEntryExistence(internalPath), mediaTypeString);
    }

    Map<String, OdfFileEntry> getManifestEntries() {
        return this.mManifestEntries;
    }

    public byte[] getBytes(String internalPath) {
        if (internalPath == null || internalPath.equals(EMPTY_STRING)) {
            return null;
        }
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        byte[] data = null;
        if (internalPath.equals(OdfFile.MEDIA_TYPE.getPath())) {
            if (this.mMediaType == null) {
                return null;
            }
            try {
                data = this.mMediaType.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException use) {
                LOG.log(Level.SEVERE, null, use);
                return null;
            }
        } else if (this.mPkgDoms.get(internalPath) != null) {
            data = this.flushDom(this.mPkgDoms.get(internalPath));
            this.mMemoryFileCache.put(internalPath, data);
        } else if (this.mManifestEntries.containsKey(internalPath) && this.mMemoryFileCache.get(internalPath) != null) {
            data = this.mMemoryFileCache.get(internalPath);
        }
        if (data == null) {
            ZipArchiveEntry entry = null;
            entry = this.mZipEntries.get(internalPath);
            if (entry != null) {
                try (InputStream inputStream = this.mZipFile.getInputStream(entry);){
                    if (inputStream != null) {
                        OdfFileEntry manifestEntry;
                        EncryptionDataElement encryptionDataElement;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        inputStream.transferTo(out);
                        data = out.toByteArray();
                        if (!internalPath.equals(OdfFile.MEDIA_TYPE.getPath()) && !internalPath.equals(OdfFile.MANIFEST.getPath()) && (encryptionDataElement = (manifestEntry = this.getManifestEntries().get(internalPath)).getEncryptionData()) != null) {
                            byte[] newData = this.decryptData(data, manifestEntry, encryptionDataElement);
                            if (newData != null) {
                                data = newData;
                            } else {
                                LOG.log(Level.SEVERE, null, "Wrong password being used for decryption!");
                            }
                        }
                        this.mMemoryFileCache.put(internalPath, data);
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
        return data;
    }

    private byte[] encryptData(byte[] data, OdfFileEntry fileEntry) {
        byte[] encryptedData = null;
        try {
            SecretKeySpec key;
            fileEntry.setSize(data.length);
            Deflater compresser = new Deflater(8, true);
            compresser.setInput(data);
            compresser.finish();
            byte[] compressedData = new byte[data.length];
            int compressedDataLength = compresser.deflate(compressedData);
            byte[] passBytes = this.mNewPwd.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance(this.isAES ? "SHA-256" : "SHA-1");
            passBytes = md.digest(passBytes);
            md.reset();
            md.update(compressedData, 0, Math.min(compressedDataLength, 1024));
            byte[] checksumBytes = new byte[this.isAES ? 32 : 20];
            md.digest(checksumBytes, 0, checksumBytes.length);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] salt = new byte[16];
            secureRandom.nextBytes(salt);
            if (this.isAES) {
                PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator((Digest)new SHA1Digest());
                generator.init(passBytes, salt, 100000);
                KeyParameter keyParam = (KeyParameter)generator.generateDerivedParameters(256);
                key = new SecretKeySpec(keyParam.getKey(), "AES");
            } else {
                byte[] dk = this.derivePBKDF2Key(passBytes, salt, 1024, 16);
                key = new SecretKeySpec(dk, "Blowfish");
            }
            Cipher cipher = Cipher.getInstance(this.isAES ? "AES/CBC/ISO10126Padding" : "Blowfish/CFB/NoPadding");
            byte[] iv = new byte[this.isAES ? 16 : 8];
            secureRandom.nextBytes(iv);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(1, (Key)key, ivParameterSpec);
            encryptedData = cipher.doFinal(compressedData, 0, compressedDataLength);
            String checksum = new Base64Binary(checksumBytes).toString();
            FileEntryElement fileEntryElement = fileEntry.getOdfElement();
            EncryptionDataElement encryptionDataElement = OdfElement.findFirstChildNode(EncryptionDataElement.class, (Node)((Object)fileEntryElement));
            if (encryptionDataElement != null) {
                fileEntryElement.removeChild((Node)((Object)encryptionDataElement));
            }
            encryptionDataElement = fileEntryElement.newEncryptionDataElement(checksum, this.isAES ? "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0#sha256-1k" : "SHA1/1K");
            String initialisationVector = new Base64Binary(iv).toString();
            AlgorithmElement algorithmElement = OdfElement.findFirstChildNode(AlgorithmElement.class, (Node)((Object)encryptionDataElement));
            if (algorithmElement != null) {
                encryptionDataElement.removeChild((Node)((Object)algorithmElement));
            }
            algorithmElement = encryptionDataElement.newAlgorithmElement(this.isAES ? "http://www.w3.org/2001/04/xmlenc#aes256-cbc" : "Blowfish CFB", initialisationVector);
            String saltStr = new Base64Binary(salt).toString();
            KeyDerivationElement keyDerivationElement = OdfElement.findFirstChildNode(KeyDerivationElement.class, (Node)((Object)encryptionDataElement));
            if (keyDerivationElement != null) {
                encryptionDataElement.removeChild((Node)((Object)keyDerivationElement));
            }
            keyDerivationElement = encryptionDataElement.newKeyDerivationElement(this.isAES ? 100000 : 1024, "PBKDF2", saltStr);
            StartKeyGenerationElement startKeyGenerationElement = OdfElement.findFirstChildNode(StartKeyGenerationElement.class, (Node)((Object)encryptionDataElement));
            if (startKeyGenerationElement != null) {
                encryptionDataElement.removeChild((Node)((Object)startKeyGenerationElement));
            }
            encryptionDataElement.newStartKeyGenerationElement(this.isAES ? "http://www.w3.org/2000/09/xmldsig#sha256" : "SHA1").setKeySizeAttribute(this.isAES ? 32 : 20);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, null, e);
        }
        return encryptedData;
    }

    private byte[] decryptData(byte[] data, OdfFileEntry manifestEntry, EncryptionDataElement encryptionDataElement) {
        byte[] decompressData = null;
        try {
            Cipher cipher;
            SecretKeySpec key;
            MessageDigest md;
            KeyDerivationElement keyDerivationElement = OdfElement.findFirstChildNode(KeyDerivationElement.class, (Node)((Object)encryptionDataElement));
            AlgorithmElement algorithmElement = OdfElement.findFirstChildNode(AlgorithmElement.class, (Node)((Object)encryptionDataElement));
            String saltStr = keyDerivationElement.getSaltAttribute();
            String ivStr = algorithmElement.getInitialisationVectorAttribute();
            String checksum = encryptionDataElement.getChecksumAttribute();
            byte[] salt = Base64Binary.valueOf(saltStr).getBytes();
            byte[] iv = Base64Binary.valueOf(ivStr).getBytes();
            byte[] passBytes = this.mOldPwd.getBytes(StandardCharsets.UTF_8);
            String algorithm = algorithmElement.getAlgorithmNameAttribute();
            boolean bl = this.isAES = algorithm.contains("aes256-cbc") || algorithm.contains("AES-256-CBC");
            if (this.isAES) {
                md = MessageDigest.getInstance("SHA-256");
                passBytes = md.digest(passBytes);
                PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator((Digest)new SHA1Digest());
                generator.init(passBytes, salt, 100000);
                KeyParameter keyParam = (KeyParameter)generator.generateDerivedParameters(256);
                key = new SecretKeySpec(keyParam.getKey(), "AES");
                cipher = Cipher.getInstance("AES/CBC/ISO10126Padding");
                md.reset();
            } else {
                md = MessageDigest.getInstance("SHA-1");
                passBytes = md.digest(passBytes);
                byte[] dk = this.derivePBKDF2Key(passBytes, salt, 1024, 16);
                key = new SecretKeySpec(dk, "Blowfish");
                cipher = Cipher.getInstance("Blowfish/CFB/NoPadding");
                md.reset();
            }
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(2, (Key)key, ivParameterSpec);
            byte[] decryptedData = cipher.doFinal(data);
            md.update(decryptedData, 0, Math.min(decryptedData.length, 1024));
            int digestLength = md.getDigestLength();
            byte[] checksumBytes = new byte[digestLength];
            md.digest(checksumBytes, 0, digestLength);
            String newChecksum = new Base64Binary(checksumBytes).toString();
            if (!newChecksum.equals(checksum)) {
                throw new OdfDecryptedException("The given password is wrong, please check it.");
            }
            Inflater decompresser = new Inflater(true);
            decompresser.setInput(decryptedData);
            decompressData = new byte[manifestEntry.getSize().intValue()];
            decompresser.inflate(decompressData);
            decompresser.end();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, null, e);
        }
        return decompressData;
    }

    byte[] derivePBKDF2Key(byte[] password, byte[] salt, int iterationCount, int keyLength) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec keyspec = new SecretKeySpec(password, "HmacSHA1");
        Mac hmac = Mac.getInstance("HmacSHA1");
        hmac.init(keyspec);
        int hmacLen = hmac.getMacLength();
        int l = keyLength % hmacLen > 0 ? keyLength / hmacLen + 1 : keyLength / hmacLen;
        int r = keyLength - (l - 1) * hmacLen;
        byte[] T = new byte[l * hmacLen];
        int offset = 0;
        for (int i = 1; i <= l; ++i) {
            byte[] Ur = new byte[hmacLen];
            byte[] Ui = new byte[salt.length + 4];
            System.arraycopy(salt, 0, Ui, 0, salt.length);
            Ui[salt.length + 0] = (byte)(i >>> 24);
            Ui[salt.length + 1] = (byte)(i >>> 16);
            Ui[salt.length + 2] = (byte)(i >>> 8);
            Ui[salt.length + 3] = (byte)i;
            for (int j = 0; j < iterationCount; ++j) {
                Ui = hmac.doFinal(Ui);
                for (int k = 0; k < T.length; ++k) {
                    int n = k;
                    Ur[n] = (byte)(Ur[n] ^ Ui[k]);
                }
            }
            System.arraycopy(Ur, 0, T, offset, hmacLen);
            offset += hmacLen;
        }
        if (r < hmacLen) {
            byte[] DK = new byte[keyLength];
            System.arraycopy(T, 0, DK, 0, keyLength);
            return DK;
        }
        return T;
    }

    private byte[] flushDom(Document dom) {
        if (dom instanceof OdfFileDom) {
            OdfFileDom odfDom = (OdfFileDom)((Object)dom);
            Map<String, String> nsByUri = odfDom.getMapNamespacePrefixByUri();
            OdfElement root = odfDom.getRootElement();
            if (root != null) {
                for (Map.Entry<String, String> entry : nsByUri.entrySet()) {
                    root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + entry.getValue(), entry.getKey());
                }
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DOMXSImplementationSourceImpl dis = new DOMXSImplementationSourceImpl();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)dis.getDOMImplementation("LS"));
        LSSerializer writer = impl.createLSSerializer();
        LSOutput output = impl.createLSOutput();
        output.setByteStream(baos);
        writer.write(dom, output);
        return baos.toByteArray();
    }

    public InputStream getInputStream(String internalPath) {
        byte[] data = this.getBytes(internalPath = OdfPackage.normalizeFilePath(internalPath));
        if (data != null && data.length != 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            return bais;
        }
        return null;
    }

    public InputStream getInputStream(String internalPath, boolean useOriginal) {
        InputStream stream = null;
        if (useOriginal) {
            ZipArchiveEntry entry = this.mOriginalZipEntries.get(internalPath);
            if (entry != null) {
                try {
                    stream = this.mZipFile.getInputStream(entry);
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        } else {
            stream = this.getInputStream(internalPath);
        }
        return stream;
    }

    public InputStream getInputStream() throws IOException, SAXException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.save(out, this.mBaseURI);
        return new ByteArrayInputStream(out.toByteArray());
    }

    public OutputStream insertOutputStream(String internalPath) throws Exception {
        return this.insertOutputStream(internalPath, null);
    }

    public OutputStream insertOutputStream(String internalPath, String mediaType) throws IOException {
        final String fPath = internalPath = OdfPackage.normalizeFilePath(internalPath);
        final OdfFileEntry fFileEntry = this.getFileEntry(internalPath);
        final String fMediaType = mediaType;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                byte[] data = this.toByteArray();
                if (fMediaType == null || fMediaType.length() == 0) {
                    OdfPackage.this.insert(data, fPath, fFileEntry == null ? null : fFileEntry.getMediaTypeString());
                } else {
                    OdfPackage.this.insert(data, fPath, fMediaType);
                }
                super.close();
            }
        };
        return baos;
    }

    public void remove(String internalPath) {
        internalPath = OdfPackage.normalizePath(internalPath);
        if (this.mZipEntries != null && this.mZipEntries.containsKey(internalPath)) {
            this.mZipEntries.remove(internalPath);
        }
        if (this.mManifestEntries != null && this.mManifestEntries.containsKey(internalPath)) {
            OdfFileEntry manifestEntry = this.mManifestEntries.remove(internalPath);
            FileEntryElement manifestEle = manifestEntry.getOdfElement();
            manifestEle.getParentNode().removeChild((Node)((Object)manifestEle));
        }
    }

    public long getSize(String internalPath) {
        long size = -1L;
        internalPath = OdfPackage.normalizePath(internalPath);
        if (this.mZipEntries != null && this.mZipEntries.containsKey(internalPath)) {
            ZipArchiveEntry zipEntry = this.mZipEntries.get(internalPath);
            size = zipEntry.getSize();
        }
        return size;
    }

    private String encodeXMLAttributes(String attributeValue) {
        String encodedValue = QUOTATION_PATTERN.matcher(attributeValue).replaceAll(ENCODED_QUOTATION);
        encodedValue = APOSTROPHE_PATTERN.matcher(encodedValue).replaceAll(ENCODED_APOSTROPHE);
        return encodedValue;
    }

    public EntityResolver getEntityResolver() {
        if (this.mResolver == null) {
            this.mResolver = new Resolver(this);
        }
        return this.mResolver;
    }

    public URIResolver getURIResolver() {
        if (this.mResolver == null) {
            this.mResolver = new Resolver(this);
        }
        return this.mResolver;
    }

    private static String getBaseURLFromFile(File file) throws IOException {
        String baseURL = Util.toExternalForm(file.getCanonicalFile().toURI());
        baseURL = BACK_SLASH_PATTERN.matcher(baseURL).replaceAll(SLASH);
        return baseURL;
    }

    static String normalizeFilePath(String internalPath) {
        if (internalPath.equals(EMPTY_STRING)) {
            return SLASH;
        }
        return OdfPackage.normalizePath(internalPath);
    }

    static String normalizeDirectoryPath(String directoryPath) {
        if (!((String)(directoryPath = OdfPackage.normalizePath((String)directoryPath))).equals(EMPTY_STRING)) {
            if (!((String)directoryPath).endsWith(SLASH)) {
                directoryPath = (String)directoryPath + SLASH;
            }
            if (((String)directoryPath).startsWith(SLASH) && !((String)directoryPath).equals(SLASH)) {
                directoryPath = ((String)directoryPath).substring(1);
            }
        }
        return directoryPath;
    }

    static String normalizePath(String path) {
        if (path == null) {
            String errMsg = "The internalPath given by parameter is NULL!";
            LOG.severe(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        if (!OdfPackage.mightBeExternalReference(path)) {
            if (path.isEmpty()) {
                path = SLASH;
            } else {
                if (path.contains("\\")) {
                    path = BACK_SLASH_PATTERN.matcher(path).replaceAll(SLASH);
                }
                while (path.contains("//")) {
                    path = DOUBLE_SLASH_PATTERN.matcher(path).replaceAll(SLASH);
                }
                if (path.contains("/.") || path.contains("./")) {
                    path = OdfPackage.removeChangeDirectories(path);
                }
                if (path.startsWith(SLASH) && !path.equals(SLASH)) {
                    path = path.substring(1);
                }
            }
        }
        return path;
    }

    private static boolean mightBeExternalReference(String internalPath) {
        boolean isExternalReference = false;
        if (internalPath.startsWith(DOUBLE_DOT) || internalPath.startsWith(SLASH) && !internalPath.equals(SLASH) || internalPath.contains(COLON)) {
            isExternalReference = true;
        }
        return isExternalReference;
    }

    private static String removeChangeDirectories(String path) {
        String lastPath;
        boolean isDirectory = path.endsWith(SLASH);
        StringTokenizer tokenizer = new StringTokenizer(path, SLASH);
        int tokenCount = tokenizer.countTokens();
        ArrayList<String> tokenList = new ArrayList<String>(tokenCount);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            tokenList.add(token);
        }
        if (!isDirectory && ((lastPath = (String)tokenList.get(tokenCount - 1)).equals(DOT) || lastPath.equals(DOUBLE_DOT))) {
            isDirectory = true;
        }
        int removeDirLevel = 0;
        StringBuilder out = new StringBuilder();
        for (int i = tokenCount - 1; i >= 0; --i) {
            String currentToken = (String)tokenList.get(i);
            if (currentToken.equals(DOUBLE_DOT)) {
                ++removeDirLevel;
                continue;
            }
            if (currentToken.equals(DOT)) continue;
            if (removeDirLevel > 0) {
                --removeDirLevel;
                continue;
            }
            out.insert(0, SLASH);
            out.insert(0, currentToken);
        }
        if (removeDirLevel > 0) {
            return EMPTY_STRING;
        }
        if (!isDirectory) {
            out.deleteCharAt(out.length() - 1);
        }
        return out.toString();
    }

    public static boolean isExternalReference(String internalPath) {
        if (OdfPackage.mightBeExternalReference(internalPath)) {
            return true;
        }
        return OdfPackage.mightBeExternalReference(OdfPackage.normalizePath(internalPath));
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.mErrorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.mErrorHandler;
    }

    void logValidationWarning(ValidationConstraint constraint, String baseURI, Object ... o) throws SAXException {
        if (this.mErrorHandler == null) {
            return;
        }
        int varCount = 0;
        if (o != null) {
            varCount = o.length;
        }
        switch (varCount) {
            case 0: {
                this.mErrorHandler.warning(new OdfValidationException(constraint, baseURI, o));
                break;
            }
            case 1: {
                this.mErrorHandler.warning(new OdfValidationException(constraint, baseURI, o[0]));
                break;
            }
            case 2: {
                this.mErrorHandler.warning(new OdfValidationException(constraint, baseURI, o[0], o[1]));
            }
        }
    }

    void logValidationError(ValidationConstraint constraint, String baseURI, Object ... o) throws SAXException {
        if (this.mErrorHandler == null) {
            return;
        }
        int varCount = 0;
        if (o != null) {
            varCount = o.length;
        }
        switch (varCount) {
            case 0: {
                this.mErrorHandler.error(new OdfValidationException(constraint, baseURI, o));
                break;
            }
            case 1: {
                this.mErrorHandler.error(new OdfValidationException(constraint, baseURI, o[0]));
                break;
            }
            case 2: {
                this.mErrorHandler.error(new OdfValidationException(constraint, baseURI, o[0], o[1]));
            }
        }
    }

    void setManifestVersion(String odfVersion) {
        this.mManifestVersion = odfVersion;
    }

    String getManifestVersion() {
        return this.mManifestVersion;
    }

    public String getNextMarkupId() {
        return Integer.toString(this.mTransientMarkupId++);
    }

    public static enum OdfFile {
        IMAGE_DIRECTORY("Pictures"),
        MANIFEST("META-INF/manifest.xml"),
        MEDIA_TYPE("mimetype");

        private final String internalPath;

        private OdfFile(String internalPath) {
            this.internalPath = internalPath;
        }

        public String getPath() {
            return this.internalPath;
        }
    }
}

