/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.ResourceUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.changes.CollabTextDocument;
import org.odftoolkit.odfdom.changes.Component;
import org.odftoolkit.odfdom.changes.JsonOperationProducer;
import org.odftoolkit.odfdom.changes.PageArea;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfMetaDom;
import org.odftoolkit.odfdom.dom.OdfSchemaConstraint;
import org.odftoolkit.odfdom.dom.OdfSettingsDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterLeftElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderLeftElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfStylesBase;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStylePageLayout;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.odftoolkit.odfdom.pkg.rdfa.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class OdfSchemaDocument
extends OdfPackageDocument {
    private static final Logger LOG = Logger.getLogger(OdfSchemaDocument.class.getName());
    protected OdfContentDom mContentDom;
    protected OdfStylesDom mStylesDom;
    protected OdfMetaDom mMetaDom;
    protected OdfSettingsDom mSettingsDom;
    protected JsonOperationProducer mJsonOperationQueue;
    private Component mRootComponent;
    private static final OdfName STYLE_HEADER_FIRST = OdfName.newName(OdfDocumentNamespace.STYLE, "header-first");
    private static final OdfName STYLE_FOOTER_FIRST = OdfName.newName(OdfDocumentNamespace.STYLE, "footer-first");

    protected OdfSchemaDocument(OdfPackage pkg, String internalPath, String mediaTypeString) {
        super(pkg, internalPath, mediaTypeString);
        ErrorHandler errorHandler = pkg.getErrorHandler();
        if (errorHandler != null) {
            if (pkg.getFileEntry(internalPath + "content.xml") == null && pkg.getFileEntry(internalPath + "styles.xml") == null) {
                try {
                    Object baseURI = pkg.getBaseURI();
                    if (baseURI == null) {
                        baseURI = internalPath;
                    } else if (!internalPath.equals("")) {
                        baseURI = "/" + internalPath;
                    }
                    errorHandler.error(new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.DOCUMENT_WITHOUT_CONTENT_NOR_STYLES_XML, (String)baseURI, new Object[0]));
                }
                catch (SAXException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
            InputStream mimetypeStream = pkg.getInputStream(OdfPackage.OdfFile.MEDIA_TYPE.getPath(), true);
            if (internalPath.equals("") && mimetypeStream == null) {
                try {
                    errorHandler.error(new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.PACKAGE_SHALL_CONTAIN_MIMETYPE, pkg.getBaseURI(), new Object[0]));
                }
                catch (SAXException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public JsonOperationProducer getJsonOperationQueue() {
        return this.mJsonOperationQueue;
    }

    public void setJsonOperationQueue(JsonOperationProducer queue) {
        this.mJsonOperationQueue = queue;
    }

    public JSONObject getOperations(CollabTextDocument operationDoc) throws SAXException, JSONException, IOException {
        JSONObject ops = null;
        JsonOperationProducer queue = this.getJsonOperationQueue();
        if (queue == null) {
            try {
                this.getStylesDom();
                this.getContentDom();
                queue = this.getJsonOperationQueue();
            }
            catch (SAXException ex) {
                LOG.log(Level.SEVERE, null, ex);
                throw ex;
            }
        }
        if (queue != null) {
            ops = queue.getDocumentOperations();
        }
        return ops;
    }

    public Component getRootComponent() {
        if (this.mRootComponent == null) {
            try {
                this.getContentDom();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        return this.mRootComponent;
    }

    public OdfElement getRootComponentElement(String masterStyleName, PageArea pageArea, boolean createIfNotExisting) {
        OdfElement targetElement = null;
        try {
            OdfStylesDom stylesDom = this.getStylesDom();
            if (stylesDom != null) {
                OfficeMasterStylesElement masterStyles = stylesDom.getMasterStyles();
                if (masterStyles == null) {
                    masterStyles = stylesDom.getOrCreateMasterStyles();
                }
                StyleMasterPageElement masterPage = masterStyles.getOrCreateMasterPage(masterStyleName);
                if (pageArea.getPageAreaName().contains("header")) {
                    String localName = null;
                    localName = pageArea.equals((Object)PageArea.HEADER_FIRST) ? PageArea.HEADER_FIRST.getLocalName() : (pageArea.equals((Object)PageArea.HEADER_EVEN) ? PageArea.HEADER_EVEN.getLocalName() : PageArea.HEADER_DEFAULT.getLocalName());
                    targetElement = (OdfElement)((Object)masterPage.getChildElement(StyleHeaderElement.ELEMENT_NAME.getUri(), localName, 0));
                    OdfOfficeAutomaticStyles autoStyles = stylesDom.getOrCreateAutomaticStyles();
                    String pageLayoutName = masterPage.getStylePageLayoutNameAttribute();
                    if (targetElement == null && createIfNotExisting) {
                        if (pageArea.equals((Object)PageArea.HEADER_FIRST)) {
                            targetElement = OdfXMLFactory.newOdfElement(stylesDom, STYLE_HEADER_FIRST);
                        } else if (pageArea.equals((Object)PageArea.HEADER_EVEN)) {
                            targetElement = new StyleHeaderLeftElement(stylesDom);
                            OdfStylePageLayout pageLayout = null;
                            pageLayout = pageLayoutName != null && !pageLayoutName.isEmpty() ? autoStyles.getOrCreatePageLayout(pageLayoutName) : autoStyles.newPageLayout();
                            pageLayout.setStylePageUsageAttribute("right");
                        } else {
                            targetElement = new StyleHeaderElement(stylesDom);
                        }
                        masterPage.appendChild((Node)((Object)targetElement));
                    }
                } else {
                    String localName = null;
                    localName = pageArea.equals((Object)PageArea.FOOTER_FIRST) ? PageArea.FOOTER_FIRST.getLocalName() : (pageArea.equals((Object)PageArea.FOOTER_EVEN) ? PageArea.FOOTER_EVEN.getLocalName() : PageArea.FOOTER_DEFAULT.getLocalName());
                    targetElement = (OdfElement)((Object)masterPage.getChildElement(StyleFooterElement.ELEMENT_NAME.getUri(), localName, 0));
                    OdfOfficeAutomaticStyles autoStyles = stylesDom.getOrCreateAutomaticStyles();
                    String pageLayoutName = masterPage.getStylePageLayoutNameAttribute();
                    if (targetElement == null && createIfNotExisting) {
                        if (pageArea.equals((Object)PageArea.FOOTER_FIRST)) {
                            targetElement = OdfXMLFactory.newOdfElement(stylesDom, STYLE_FOOTER_FIRST);
                        } else if (pageArea.equals((Object)PageArea.FOOTER_EVEN)) {
                            targetElement = new StyleFooterLeftElement(stylesDom);
                            OdfStylePageLayout pageLayout = autoStyles.getOrCreatePageLayout(pageLayoutName);
                            pageLayout.setStylePageUsageAttribute("right");
                        } else {
                            targetElement = new StyleFooterElement(stylesDom);
                        }
                        masterPage.appendChild((Node)((Object)targetElement));
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return targetElement;
    }

    public void setRootComponent(Component rootComponent) {
        this.mRootComponent = rootComponent;
    }

    public InputStream getContentStream() throws Exception {
        String path = this.getXMLFilePath(OdfXMLFile.CONTENT);
        return this.mPackage.getInputStream(path);
    }

    public InputStream getStylesStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.STYLES));
    }

    public InputStream getSettingsStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.SETTINGS));
    }

    public InputStream getMetaStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.META));
    }

    protected String getXMLFilePath(OdfXMLFile file) {
        return file.mFileName;
    }

    public String getBaseURI() {
        return this.mPackage.getBaseURI();
    }

    public OdfContentDom getContentDom() throws SAXException, IOException {
        if (this.mContentDom == null) {
            this.mContentDom = (OdfContentDom)((Object)this.getCachedDom(this.getAbsoluteFilePath(OdfXMLFile.CONTENT.getFileName())));
            if (this.mContentDom == null) {
                this.mContentDom = new OdfContentDom(this, this.getAbsoluteFilePath(OdfXMLFile.CONTENT.getFileName()));
            }
        }
        return this.mContentDom;
    }

    public OdfStylesDom getStylesDom() throws SAXException, IOException {
        if (this.mStylesDom == null) {
            this.mStylesDom = (OdfStylesDom)((Object)this.getCachedDom(this.getAbsoluteFilePath(OdfXMLFile.STYLES.getFileName())));
            if (this.mStylesDom == null) {
                this.mStylesDom = new OdfStylesDom(this, this.getAbsoluteFilePath(OdfXMLFile.STYLES.getFileName()));
            }
        }
        return this.mStylesDom;
    }

    public OdfMetaDom getMetaDom() throws SAXException, IOException {
        if (this.mMetaDom == null) {
            this.mMetaDom = (OdfMetaDom)((Object)this.getCachedDom(this.getAbsoluteFilePath(OdfXMLFile.META.getFileName())));
            if (this.mMetaDom == null) {
                this.mMetaDom = new OdfMetaDom(this, this.getAbsoluteFilePath(OdfXMLFile.META.getFileName()));
            }
        }
        return this.mMetaDom;
    }

    public OdfSettingsDom getSettingsDom() throws SAXException, IOException {
        if (this.mSettingsDom == null) {
            this.mSettingsDom = (OdfSettingsDom)((Object)this.getCachedDom(this.getAbsoluteFilePath(OdfXMLFile.SETTINGS.getFileName())));
            if (this.mSettingsDom == null) {
                this.mSettingsDom = new OdfSettingsDom(this, this.getAbsoluteFilePath(OdfXMLFile.SETTINGS.getFileName()));
            }
        }
        return this.mSettingsDom;
    }

    public void setContentDom(OdfContentDom contentDom) {
        this.mContentDom = contentDom;
    }

    public void setStylesDom(OdfStylesDom stylesDom) {
        this.mStylesDom = stylesDom;
    }

    public void setMetaDom(OdfMetaDom metaDom) {
        this.mMetaDom = metaDom;
    }

    public void setSettingsDom(OdfSettingsDom settingsDom) {
        this.mSettingsDom = settingsDom;
    }

    public OdfOfficeStyles getDocumentStyles() {
        OdfOfficeStyles documentStyles = null;
        try {
            OdfStylesDom stylesDom = this.getStylesDom();
            if (stylesDom != null) {
                documentStyles = stylesDom.getOfficeStyles();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return documentStyles;
    }

    public OdfOfficeMasterStyles getOfficeMasterStyles() {
        OfficeMasterStylesElement officeMasterStyles = null;
        try {
            OdfStylesDom stylesDom = this.getStylesDom();
            if (stylesDom != null) {
                officeMasterStyles = stylesDom.getOrCreateMasterStyles();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return officeMasterStyles;
    }

    public OdfOfficeStyles getOrCreateDocumentStyles() {
        OdfOfficeStyles documentStyles = null;
        try {
            OdfStylesDom stylesDom = this.getStylesDom();
            if (stylesDom != null) {
                documentStyles = stylesDom.getOfficeStyles();
            }
            if (documentStyles == null) {
                stylesDom.getOrCreateOfficeStyles();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return documentStyles;
    }

    public OdfStyle getStyleByName(OdfStyleFamily styleFamily, String styleName) throws SAXException, IOException {
        OdfContentDom odfContentDom;
        OdfStyle odfStyle = this.getStyleByName(this.getStylesDom(), styleFamily, styleName);
        if (odfStyle == null && (odfContentDom = this.getContentDom()) != null) {
            odfStyle = this.getStyleByName(odfContentDom.getAutomaticStyles(), styleFamily, styleName);
        }
        return odfStyle;
    }

    private OdfStyle getStyleByName(OdfStylesDom odfStylesDom, OdfStyleFamily styleFamily, String styleName) {
        OdfStyle odfStyle = null;
        if (odfStylesDom != null && (odfStyle = this.getStyleByName(odfStylesDom.getOfficeStyles(), styleFamily, styleName)) == null) {
            odfStyle = this.getStyleByName(odfStylesDom.getAutomaticStyles(), styleFamily, styleName);
        }
        return odfStyle;
    }

    private OdfStyle getStyleByName(OdfStylesBase odfStylesBase, OdfStyleFamily styleFamily, String styleName) {
        OdfStyle odfStyle = null;
        if (odfStylesBase != null) {
            odfStyle = odfStylesBase.getStyle(styleName, styleFamily);
        }
        return odfStyle;
    }

    public OdfStyle getStyleByDisplayName(OdfStyleFamily styleFamily, String styleDisplayName) throws SAXException, IOException {
        OdfContentDom odfContentDom;
        OdfStyle odfStyle = this.getStyleByDisplayName(this.getStylesDom(), styleFamily, styleDisplayName);
        if (odfStyle == null && (odfContentDom = this.getContentDom()) != null) {
            odfStyle = this.getStyleByDisplayName(odfContentDom.getAutomaticStyles(), styleFamily, styleDisplayName);
        }
        return odfStyle;
    }

    private OdfStyle getStyleByDisplayName(OdfStylesDom odfStylesDom, OdfStyleFamily styleFamily, String styleName) {
        OdfStyle odfStyle = null;
        if (odfStylesDom != null && (odfStyle = this.getStyleByDisplayName(odfStylesDom.getOfficeStyles(), styleFamily, styleName)) == null) {
            odfStyle = this.getStyleByDisplayName(odfStylesDom.getAutomaticStyles(), styleFamily, styleName);
        }
        return odfStyle;
    }

    private OdfStyle getStyleByDisplayName(OdfStylesBase odfStylesBase, OdfStyleFamily styleFamily, String styleName) {
        if (odfStylesBase != null) {
            for (OdfStyle odfStyle : odfStylesBase.getStylesForFamily(styleFamily)) {
                String displayName = odfStyle.getStyleDisplayNameAttribute();
                if (displayName == null || !displayName.equals(styleName)) continue;
                return odfStyle;
            }
        }
        return null;
    }

    @Deprecated(since="explicit state whether the search should be recursive")
    public List<TableTableElement> getTables() {
        return this.getTables(true);
    }

    public List<TableTableElement> getTables(boolean deepSearch) {
        ArrayList<TableTableElement> tableList = new ArrayList<TableTableElement>();
        try {
            StyleMasterPageElement defaultMasterPage;
            OfficeBodyElement officeBody = OdfElement.findFirstChildNode(OfficeBodyElement.class, (Node)((Object)this.getContentDom().getRootElement()));
            OdfElement contentRoot = OdfElement.findFirstChildNode(OdfElement.class, (Node)((Object)officeBody));
            this.fillTableList((Element)((Object)contentRoot), tableList, deepSearch);
            if (!deepSearch) {
                return tableList;
            }
            Map<String, StyleMasterPageElement> masterPages = this.getMasterPages();
            if (masterPages != null && (defaultMasterPage = masterPages.get("Standard")) != null) {
                this.fillTableList((Element)((Object)defaultMasterPage), tableList, deepSearch);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return tableList;
    }

    private List<TableTableElement> fillTableList(Element startElement, List<TableTableElement> tableList, boolean recurse) {
        NodeList childList = startElement.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node childNode = childList.item(i);
            if (!(childNode instanceof Element)) continue;
            if (childNode instanceof TableTableElement) {
                tableList.add((TableTableElement)((Object)childList.item(i)));
                continue;
            }
            if (!recurse) continue;
            this.fillTableList((Element)childNode, tableList, recurse);
        }
        return tableList;
    }

    @Deprecated
    public Map<String, StyleMasterPageElement> getMasterPages() throws Exception {
        NodeList lstMasterPages;
        OdfStylesDom stylesDoc = this.getStylesDom();
        OfficeMasterStylesElement masterStyles = OdfElement.findFirstChildNode(OfficeMasterStylesElement.class, (Node)((Object)stylesDoc.getRootElement()));
        HashMap<String, StyleMasterPageElement> masterPages = null;
        if (masterStyles != null && (lstMasterPages = stylesDoc.getElementsByTagNameNS(OdfDocumentNamespace.STYLE.getUri(), "master-page")) != null && lstMasterPages.getLength() > 0) {
            masterPages = new HashMap<String, StyleMasterPageElement>();
            for (int i = 0; i < lstMasterPages.getLength(); ++i) {
                StyleMasterPageElement masterPage = (StyleMasterPageElement)((Object)lstMasterPages.item(i));
                String styleName = masterPage.getStyleNameAttribute();
                masterPages.put(styleName, masterPage);
            }
        }
        return masterPages;
    }

    @Override
    public void close() {
        this.mContentDom = null;
        this.mStylesDom = null;
        this.mMetaDom = null;
        this.mSettingsDom = null;
        super.close();
    }

    public OdfFileDom getFileDom(OdfXMLFile file) throws SAXException, IOException {
        return this.getFileDom(this.getXMLFilePath(file));
    }

    public Model getRDFMetadata() throws Exception {
        Model m = this.getInContentMetadata().union(this.getManifestRDFMetadata());
        return m;
    }

    public Model getInContentMetadata() throws Exception {
        Model documentRDFModel = ModelFactory.createDefaultModel();
        Model fileRDFModel = null;
        block0: for (String internalPath : this.getPackage().getFilePaths()) {
            for (OdfXMLFile file : OdfXMLFile.values()) {
                if (!Util.isSubPathOf(internalPath, this.getDocumentPath()) || !internalPath.endsWith(file.getFileName())) continue;
                fileRDFModel = this.getXMLFileMetadata(internalPath);
                if (fileRDFModel.size() <= 0L) continue block0;
                documentRDFModel = documentRDFModel.union(fileRDFModel);
                continue block0;
            }
        }
        if (fileRDFModel.size() > 0L) {
            documentRDFModel = documentRDFModel.union(fileRDFModel);
        }
        return documentRDFModel;
    }

    public Model getInContentMetadataFromCache() throws Exception {
        Model m = ModelFactory.createDefaultModel();
        for (OdfXMLFile file : OdfXMLFile.values()) {
            for (Model m1 : this.getFileDom(file).getInContentMetadataCache().values()) {
                m = m.union(m1);
            }
        }
        return m;
    }

    public Model getManifestRDFMetadata() throws Exception {
        Model m = ModelFactory.createDefaultModel();
        for (String internalPath : this.getPackage().getFilePaths()) {
            if (!Util.isSubPathOf(internalPath, this.getDocumentPath()) || !this.getPackage().getMediaTypeString(internalPath).endsWith("application/rdf+xml")) continue;
            Model m1 = ModelFactory.createDefaultModel();
            String RDFBaseUri = Util.getRDFBaseUri(this.getPackage().getBaseURI(), internalPath);
            m1.read((Reader)new InputStreamReader(this.getPackage().getInputStream(internalPath), "utf-8"), RDFBaseUri);
            ResourceUtils.renameResource((Resource)m1.getResource(RDFBaseUri), (String)RDFBaseUri.substring(0, RDFBaseUri.length() - 1));
            if (m1.size() <= 0L) continue;
            m = m.union(m1);
        }
        return m;
    }

    public Model getBookmarkRDFMetadata() throws Exception {
        Model m = ModelFactory.createDefaultModel();
        for (OdfXMLFile file : OdfXMLFile.values()) {
            OdfFileDom dom = this.getFileDom(file);
            m = m.union(dom.getBookmarkRDFMetadata());
        }
        return m;
    }

    public static enum OdfXMLFile {
        CONTENT("content.xml"),
        META("meta.xml"),
        SETTINGS("settings.xml"),
        STYLES("styles.xml");

        private final String mFileName;

        public String getFileName() {
            return this.mFileName;
        }

        private OdfXMLFile(String fileName) {
            this.mFileName = fileName;
        }
    }
}

