/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.search;

import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.text.OdfWhitespaceProcessor;
import org.odftoolkit.odfdom.incubator.search.Navigation;
import org.odftoolkit.odfdom.incubator.search.SelectionManager;
import org.odftoolkit.odfdom.incubator.search.TextSelection;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextNavigation
extends Navigation<TextSelection> {
    private static final String mMatchedElementName = "text:p,text:h";
    private final Pattern mPattern;
    private final OdfTextDocument mTextDocument;
    private TextSelection mCurrentSelectedItem;
    private TextSelection mNextSelectedItem;
    private String mCurrentText;
    private int mCurrentIndex;
    private boolean mbFinishFindInHeaderFooter;
    private SelectionManager mSelectionManager;

    public TextNavigation(String pattern, OdfTextDocument doc) {
        this(Pattern.compile(pattern), doc);
    }

    public TextNavigation(Pattern pattern, OdfTextDocument doc) {
        this.mPattern = pattern;
        this.mTextDocument = doc;
        this.mCurrentSelectedItem = null;
        this.mbFinishFindInHeaderFooter = false;
        this.mSelectionManager = doc.getSelectionManager();
        this.mNextSelectedItem = this.findNextSelection(null);
    }

    public SelectionManager getSelectionManager() {
        return this.mSelectionManager;
    }

    private TextSelection findInHeaderFooter(TextSelection selected) {
        int nextIndex;
        OdfStylesDom styledom = null;
        OdfOfficeMasterStyles masterpage = null;
        OdfElement element = null;
        if (selected != null && (nextIndex = this.setCurrentTextAndGetIndex(selected)) != -1) {
            TextSelection item = new TextSelection(this.mCurrentText, selected.getContainerElement(), nextIndex, this.mSelectionManager);
            return item;
        }
        try {
            styledom = this.mTextDocument.getStylesDom();
            if (styledom == null) {
                return null;
            }
            NodeList list = styledom.getElementsByTagName("office:master-styles");
            if (list.getLength() <= 0) {
                return null;
            }
            masterpage = (OdfOfficeMasterStyles)((Object)list.item(0));
            element = selected == null ? (OdfElement)((Object)this.getNextMatchElementInTree((Node)((Object)masterpage), (Node)((Object)masterpage))) : (OdfElement)((Object)this.getNextMatchElementInTree((Node)((Object)selected.getContainerElement()), (Node)((Object)masterpage)));
            if (element != null) {
                TextSelection item = new TextSelection(this.mCurrentText, element, this.mCurrentIndex, this.mSelectionManager);
                return item;
            }
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(TextNavigation.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private TextSelection findNextSelection(TextSelection selected) {
        TextSelection result = null;
        if (!this.mbFinishFindInHeaderFooter) {
            result = this.findInHeaderFooter(selected);
            if (result != null) {
                this.mSelectionManager.registerItem(result);
                return result;
            }
            selected = null;
            this.mbFinishFindInHeaderFooter = true;
        }
        if (selected == null) {
            OdfElement element = null;
            try {
                element = (OdfElement)((Object)this.getNextMatchElement((Node)((Object)this.mTextDocument.getContentRoot())));
            }
            catch (Exception ex) {
                Logger.getLogger(TextNavigation.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            if (element != null) {
                result = new TextSelection(this.mCurrentText, element, this.mCurrentIndex, this.mSelectionManager);
                this.mSelectionManager.registerItem(result);
                return result;
            }
            return null;
        }
        OdfElement containerElement = selected.getContainerElement();
        int nextIndex = this.setCurrentTextAndGetIndex(selected);
        if (nextIndex != -1) {
            result = new TextSelection(this.mCurrentText, containerElement, nextIndex, this.mSelectionManager);
            this.mSelectionManager.registerItem(result);
            return result;
        }
        OdfElement element = (OdfElement)((Object)this.getNextMatchElement((Node)((Object)containerElement)));
        if (element != null) {
            result = new TextSelection(this.mCurrentText, element, this.mCurrentIndex, this.mSelectionManager);
            this.mSelectionManager.registerItem(result);
            return result;
        }
        return null;
    }

    private int setCurrentTextAndGetIndex(TextSelection selected) {
        int index = selected.getIndex();
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        String content = textProcessor.getText((Node)((Object)selected.getContainerElement()));
        int nextIndex = -1;
        Matcher matcher = this.mPattern.matcher(content);
        try {
            if (matcher.find(index + selected.getText().length())) {
                nextIndex = matcher.start();
                int eIndex = matcher.end();
                this.mCurrentText = content.substring(nextIndex, eIndex);
            }
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
        return nextIndex;
    }

    @Override
    public TextSelection next() {
        if (this.mNextSelectedItem == null) {
            throw new NoSuchElementException();
        }
        this.mCurrentSelectedItem = this.mNextSelectedItem;
        this.mNextSelectedItem = this.findNextSelection(this.mCurrentSelectedItem);
        return this.mCurrentSelectedItem;
    }

    @Override
    public boolean hasNext() {
        return this.mNextSelectedItem != null;
    }

    @Override
    public OdfElement getElement() {
        if (this.mCurrentSelectedItem != null) {
            return this.mCurrentSelectedItem.getElement();
        }
        return null;
    }

    @Override
    public boolean match(Node element) {
        OdfWhitespaceProcessor textProcessor;
        String content;
        Matcher matcher;
        if (element instanceof OdfElement && mMatchedElementName.contains(element.getNodeName()) && (matcher = this.mPattern.matcher(content = (textProcessor = new OdfWhitespaceProcessor()).getText(element))).find()) {
            this.mCurrentIndex = matcher.start();
            int eIndex = matcher.end();
            this.mCurrentText = content.substring(this.mCurrentIndex, eIndex);
            return true;
        }
        return false;
    }
}

