/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDataStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextFixedAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextTimeValueAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextPrintTimeElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "print-time");

    public TextPrintTimeElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getStyleDataStyleNameAttribute() {
        StyleDataStyleNameAttribute attr = (StyleDataStyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "data-style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleDataStyleNameAttribute(String styleDataStyleNameValue) {
        StyleDataStyleNameAttribute attr = new StyleDataStyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleDataStyleNameValue);
    }

    public Boolean getTextFixedAttribute() {
        TextFixedAttribute attr = (TextFixedAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "fixed");
        if (attr != null && !attr.getValue().isEmpty()) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setTextFixedAttribute(Boolean textFixedValue) {
        TextFixedAttribute attr = new TextFixedAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(textFixedValue);
    }

    public String getTextTimeValueAttribute() {
        TextTimeValueAttribute attr = (TextTimeValueAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "time-value");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextTimeValueAttribute(String textTimeValueValue) {
        TextTimeValueAttribute attr = new TextTimeValueAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textTimeValueValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

