/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.OdfSettingsDom;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class OdfTextDocument
extends OdfDocument {
    private static final String EMPTY_TEXT_DOCUMENT_PATH = "/OdfTextDocument.odt";
    static final OdfPackageDocument.Resource EMPTY_TEXT_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfTextDocument.odt");
    private Boolean hasTabsRelativeToIndent = null;

    public static OdfTextDocument newTextDocument() throws Exception {
        return (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT);
    }

    public static OdfTextDocument newTextDocument(Boolean enableCollaboration) throws Exception {
        return (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT, enableCollaboration);
    }

    public static OdfTextDocument newTextDocument(OdfMediaType mimeType) throws Exception {
        return (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT);
    }

    public static OdfTextDocument newTextTemplateDocument() throws Exception {
        return (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT_TEMPLATE);
    }

    public static OdfTextDocument newTextMasterDocument() throws Exception {
        OdfTextDocument doc = (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT_MASTER);
        doc.changeMode(OdfMediaType.TEXT_MASTER);
        return doc;
    }

    public static OdfTextDocument newTextMasterTemplateDocument() throws Exception {
        OdfTextDocument doc = (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT_MASTER);
        doc.changeMode(OdfMediaType.TEXT_MASTER_TEMPLATE);
        return doc;
    }

    public static OdfTextDocument newTextWebDocument() throws Exception {
        OdfTextDocument doc = (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT_WEB);
        doc.changeMode(OdfMediaType.TEXT_WEB);
        return doc;
    }

    public static OdfTextDocument loadDocument(InputStream inputStream) throws Exception {
        return (OdfTextDocument)OdfDocument.loadDocument(inputStream);
    }

    public static OdfTextDocument loadDocument(InputStream inputStream, Boolean enableCollaboration) throws Exception {
        return (OdfTextDocument)OdfDocument.loadDocument(inputStream, enableCollaboration);
    }

    public static OdfTextDocument loadDocument(InputStream inputStream, Map<String, Object> configuration) throws Exception {
        return (OdfTextDocument)OdfDocument.loadDocument(inputStream, configuration);
    }

    public static OdfTextDocument loadDocument(InputStream inputStream, Map<String, Object> configuration, Boolean enableCollaboration) throws Exception {
        return (OdfTextDocument)OdfDocument.loadDocument(inputStream, configuration, enableCollaboration);
    }

    public static OdfTextDocument loadDocument(String documentPath) throws Exception {
        return (OdfTextDocument)OdfDocument.loadDocument(documentPath);
    }

    public static OdfTextDocument loadDocument(File file) throws Exception {
        return (OdfTextDocument)OdfDocument.loadDocument(file);
    }

    protected OdfTextDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType, Boolean enableCollaboration) throws SAXException {
        super(pkg, internalPath, odfMediaType.mMediaType);
        this.mHasCollaboration = enableCollaboration;
    }

    protected OdfTextDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) throws SAXException {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    @Override
    public OfficeTextElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeTextElement.class);
    }

    public OdfTextParagraph newParagraph(String text) throws Exception {
        OdfTextParagraph para = this.newParagraph();
        para.addContent(text);
        return para;
    }

    public OdfTextParagraph newParagraph() throws Exception {
        OfficeTextElement odfText = this.getContentRoot();
        return (OdfTextParagraph)odfText.newTextPElement();
    }

    public OdfTextParagraph addText(String text) throws Exception {
        OfficeTextElement odfText = this.getContentRoot();
        Node n = odfText.getLastChild();
        OdfTextParagraph para = OdfTextParagraph.class.isInstance(n) ? (OdfTextParagraph)((Object)n) : this.newParagraph();
        para.addContent(text);
        return para;
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    public Boolean hasTabsRelativeToIndent() {
        if (this.hasTabsRelativeToIndent == null) {
            block7: {
                try {
                    OdfSettingsDom settingsDom = this.getSettingsDom();
                    if (settingsDom == null) break block7;
                    NodeList configItemSets = settingsDom.getRootElement().getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:config:1.0", "config-item-set");
                    Element configElement = null;
                    for (int i = 0; i < configItemSets.getLength(); ++i) {
                        Node config = configItemSets.item(i);
                        if (!(config instanceof Element)) continue;
                        configElement = (Element)config;
                        if (configElement.getLocalName().equals("config-item-set") && configElement.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:config:1.0", "name").equals("ooo:configuration-settings")) break;
                        configElement = null;
                    }
                    if (configElement == null) break block7;
                    NodeList configItems = configElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:config:1.0", "config-item");
                    for (int i = 0; i < configItems.getLength(); ++i) {
                        Node config = configItems.item(i);
                        if (!(config instanceof Element) || !(configElement = (Element)config).getLocalName().equals("config-item") || !configElement.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:config:1.0", "name").equals("TabsRelativeToIndent")) continue;
                        Node child = configElement.getFirstChild();
                        if (child instanceof Text) {
                            this.hasTabsRelativeToIndent = ((Text)child).getTextContent().equals("true");
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(OdfTextDocument.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.hasTabsRelativeToIndent == null) {
                this.hasTabsRelativeToIndent = true;
            }
        }
        return this.hasTabsRelativeToIndent;
    }

    public static enum OdfMediaType implements MediaType
    {
        TEXT(OdfDocument.OdfMediaType.TEXT),
        TEXT_TEMPLATE(OdfDocument.OdfMediaType.TEXT_TEMPLATE),
        TEXT_MASTER(OdfDocument.OdfMediaType.TEXT_MASTER),
        TEXT_MASTER_TEMPLATE(OdfDocument.OdfMediaType.TEXT_MASTER_TEMPLATE),
        TEXT_WEB(OdfDocument.OdfMediaType.TEXT_WEB);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        @Override
        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

