/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.db.DbDatabaseNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbHostnameAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbLocalSocketAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbPortAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbTypeAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element db:server-database}. */
public class DbServerDatabaseElement extends OdfElement {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.DB, "server-database");

  /**
   * Create the instance of <code>DbServerDatabaseElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public DbServerDatabaseElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element db:server-database}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbDatabaseNameAttribute</code>
   * , See {@odf.attribute db:database-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbDatabaseNameAttribute() {
    DbDatabaseNameAttribute attr =
        (DbDatabaseNameAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "database-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbDatabaseNameAttribute</code> , See
   * {@odf.attribute db:database-name}
   *
   * @param dbDatabaseNameValue The type is <code>String</code>
   */
  public void setDbDatabaseNameAttribute(String dbDatabaseNameValue) {
    DbDatabaseNameAttribute attr = new DbDatabaseNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbDatabaseNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbHostnameAttribute</code> ,
   * See {@odf.attribute db:hostname}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbHostnameAttribute() {
    DbHostnameAttribute attr =
        (DbHostnameAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "hostname");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbHostnameAttribute</code> , See
   * {@odf.attribute db:hostname}
   *
   * @param dbHostnameValue The type is <code>String</code>
   */
  public void setDbHostnameAttribute(String dbHostnameValue) {
    DbHostnameAttribute attr = new DbHostnameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbHostnameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbLocalSocketAttribute</code> ,
   * See {@odf.attribute db:local-socket}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbLocalSocketAttribute() {
    DbLocalSocketAttribute attr =
        (DbLocalSocketAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "local-socket");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbLocalSocketAttribute</code> , See
   * {@odf.attribute db:local-socket}
   *
   * @param dbLocalSocketValue The type is <code>String</code>
   */
  public void setDbLocalSocketAttribute(String dbLocalSocketValue) {
    DbLocalSocketAttribute attr = new DbLocalSocketAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbLocalSocketValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbPortAttribute</code> , See
   * {@odf.attribute db:port}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getDbPortAttribute() {
    DbPortAttribute attr = (DbPortAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "port");
    if (attr != null) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbPortAttribute</code> , See
   * {@odf.attribute db:port}
   *
   * @param dbPortValue The type is <code>Integer</code>
   */
  public void setDbPortAttribute(Integer dbPortValue) {
    DbPortAttribute attr = new DbPortAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(dbPortValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbTypeAttribute</code> , See
   * {@odf.attribute db:type}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbTypeAttribute() {
    DbTypeAttribute attr = (DbTypeAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "type");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbTypeAttribute</code> , See
   * {@odf.attribute db:type}
   *
   * @param dbTypeValue The type is <code>String</code>
   */
  public void setDbTypeAttribute(String dbTypeValue) {
    DbTypeAttribute attr = new DbTypeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbTypeValue);
  }

  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
